/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class PxUtil {
    static final TypeInfo pxEditor = PxUtil.typeInfo("pxEditor:PxEditor");
    static final TypeInfo hxView = PxUtil.typeInfo("hx:HxView");
    static final TypeInfo hxPxView = PxUtil.typeInfo("hx:HxPxView");
    static final TypeInfo pdf = PxUtil.typeInfo("pdf:PxViewToPdf");
    static TypeInfo[] emptyTypeInfo = new TypeInfo[0];
    static final BIcon editorBadge = BIcon.std("badges/edit.png");

    public static AgentList explode(AgentList agentList) {
        AgentInfo[] agentInfoArray = agentList.list();
        int n = 0;
        int n2 = 0;
        while (n2 < agentInfoArray.length) {
            AgentInfo agentInfo = agentInfoArray[n2];
            if (agentInfo instanceof BAbstractPxView) {
                BAbstractPxView bAbstractPxView = (BAbstractPxView)agentInfo;
                if (pxEditor != null) {
                    agentList.add(agentList.size(), new PxEditor(bAbstractPxView));
                }
                if (hxView != null) {
                    AgentList agentList2 = bAbstractPxView.getAgents();
                    agentList2 = agentList2.filter(AgentFilter.is(hxView));
                    TypeInfo typeInfo = agentList2.getDefault().getAgentType();
                    agentList.add(n++, new PxHx(bAbstractPxView, typeInfo));
                }
                if (pdf != null) {
                    agentList.add(agentList.size(), new PxPdf(bAbstractPxView));
                }
            }
            ++n2;
        }
        return agentList;
    }

    static TypeInfo typeInfo(String string) {
        try {
            return Sys.getRegistry().getType(string);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static class PxEditor
    extends PxAgent {
        public BIcon getIcon(Context context) {
            return BIcon.make(this.pxView.getIcon(), editorBadge);
        }

        public BPermissions getRequiredPermissions() {
            return BPermissions.adminWrite;
        }

        PxEditor(BAbstractPxView bAbstractPxView) {
            super(bAbstractPxView, "editor", pxEditor);
        }
    }

    public static class PxHx
    extends PxExporter {
        public PxHx(BAbstractPxView bAbstractPxView, TypeInfo typeInfo) {
            super(bAbstractPxView, "hx", typeInfo);
        }

        public PxHx(BAbstractPxView bAbstractPxView) {
            super(bAbstractPxView, "hx", hxPxView);
        }
    }

    public static class PxPdf
    extends PxExporter {
        public PxPdf(BAbstractPxView bAbstractPxView) {
            super(bAbstractPxView, "pdf", pdf);
        }
    }

    public static class PxMobile
    extends PxExporter {
        public PxMobile(BAbstractPxView bAbstractPxView, TypeInfo typeInfo) {
            super(bAbstractPxView, "mobile", typeInfo);
        }
    }

    public static class PxExporter
    extends PxAgent {
        public BIcon getIcon(Context context) {
            return BIcon.std("files/" + this.subId + ".png");
        }

        public BPermissions getRequiredPermissions() {
            return this.pxView.getRequiredPermissions();
        }

        PxExporter(BAbstractPxView bAbstractPxView, String string, TypeInfo typeInfo) {
            super(bAbstractPxView, string, typeInfo);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class PxAgent
    implements AgentInfo {
        BAbstractPxView pxView;
        String subId;
        TypeInfo agentType;
        static /* synthetic */ Class class$javax$baja$agent$BAbstractPxView;

        public BObject getInstance() {
            try {
                Class clazz = this.agentType.getTypeSpec().getResolvedType().getTypeClass();
                Class[] classArray = new Class[1];
                Class clazz2 = class$javax$baja$agent$BAbstractPxView;
                if (clazz2 == null) {
                    clazz2 = class$javax$baja$agent$BAbstractPxView = PxAgent.class("[Ljavax.baja.agent.BAbstractPxView;", false);
                }
                classArray[0] = clazz2;
                Constructor constructor = clazz.getConstructor(classArray);
                return (BObject)constructor.newInstance(this.pxView);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new BajaRuntimeException(throwable);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new BajaRuntimeException(exception);
            }
        }

        public final BAbstractPxView getPxView() {
            return this.pxView;
        }

        public final String getAgentId() {
            return this.pxView.getName() + '/' + this.subId;
        }

        public final TypeInfo getAgentType() {
            return this.agentType;
        }

        public final String getAppName() {
            return null;
        }

        public TypeInfo[] getAgentOn() {
            return emptyTypeInfo;
        }

        public String getDisplayName(Context context) {
            Object[] objectArray = new Object[]{this.pxView.getDisplayName(context)};
            return Lexicon.make("baja", context).getText("px." + this.subId, objectArray);
        }

        public String toString() {
            return this.pxView.getName() + " as " + TextUtil.getClassName(this.getClass());
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public PxAgent(BAbstractPxView bAbstractPxView, String string, TypeInfo typeInfo) {
            this.pxView = bAbstractPxView;
            this.subId = string;
            this.agentType = typeInfo;
        }
    }
}

