/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;

public class ObjectUtil {
    public static String generateUniqueName(String string, NameContainer nameContainer) {
        char c;
        int n;
        if (!nameContainer.contains(string)) {
            return string;
        }
        int n2 = -1;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            if (!Character.isDigit(string.charAt(n3))) break;
            n2 = n3--;
        }
        String string2 = string;
        int n4 = 1;
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            n4 = Integer.parseInt(string.substring(n2)) + 1;
            n = n2;
            while (n < string.length() - 1) {
                c = string.charAt(n);
                if (c == '0') {
                    string2 = string2 + '0';
                    ++n;
                    continue;
                }
                break;
            }
        } else if (n2 == 0) {
            string2 = "";
            n4 = Integer.parseInt(string) + 1;
            n = n2;
            while (n < string.length() - 1) {
                c = string.charAt(n);
                if (c == '0') {
                    string2 = string2 + '0';
                    ++n;
                    continue;
                }
                break;
            }
        }
        n = n4;
        while (true) {
            if (n - n4 > 100000) {
                throw new IllegalStateException("NameContainer not functioning");
            }
            String string3 = string2 + n;
            if (!nameContainer.contains(string3)) {
                return string3;
            }
            ++n;
        }
    }

    public static String generateUniqueSlotName(String string, NameContainer nameContainer) {
        char c;
        int n;
        if (!nameContainer.contains(string)) {
            return string;
        }
        string = SlotPath.unescape(string);
        int n2 = -1;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            if (!Character.isDigit(string.charAt(n3))) break;
            n2 = n3--;
        }
        String string2 = string;
        int n4 = 1;
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            n4 = Integer.parseInt(string.substring(n2)) + 1;
            n = n2;
            while (n < string.length() - 1) {
                c = string.charAt(n);
                if (c == '0') {
                    string2 = string2 + '0';
                    ++n;
                    continue;
                }
                break;
            }
        } else if (n2 == 0) {
            string2 = "";
            n4 = Integer.parseInt(string) + 1;
            n = n2;
            while (n < string.length() - 1) {
                c = string.charAt(n);
                if (c == '0') {
                    string2 = string2 + '0';
                    ++n;
                    continue;
                }
                break;
            }
        }
        n = n4;
        while (true) {
            if (n - n4 > 100000) {
                throw new IllegalStateException("NameContainer not functioning");
            }
            String string3 = SlotPath.escape(string2 + n);
            if (!nameContainer.contains(string3)) {
                return string3;
            }
            ++n;
        }
    }

    public static String stripDigitsFromEnd(String string) {
        int n = string.length() - 1;
        boolean bl = false;
        while (Character.isDigit(string.charAt(n)) || string.charAt(n) == '$') {
            if (n == 0) {
                return string;
            }
            bl = true;
            --n;
        }
        if (!bl) {
            return string;
        }
        return string.substring(0, n + 1);
    }

    public static BOrd getReferenceHelpOrd(BObject bObject) {
        String string = bObject.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n).replace('.', '/');
        String string3 = string.substring(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("local:|module://").append(bObject.getType().getModule().getModuleName()).append("/doc/").append(string2).append('/').append(string3).append(".bajadoc");
        return BOrd.make(stringBuffer.toString());
    }

    public static BOrd getGuideHelpOrd(TypeInfo typeInfo) {
        String string = typeInfo.getModuleName();
        String string2 = typeInfo.getLexicon(null).get("help.guide.base");
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append("local:|module://").append(string).append("/doc/");
        } else if (string2.startsWith("module:")) {
            stringBuffer.append("local:|").append(string2);
        } else {
            stringBuffer.append(string2);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
            stringBuffer.append('/');
        }
        stringBuffer.append(string).append('-').append(typeInfo.getTypeName()).append(".html");
        return BOrd.make(stringBuffer.toString());
    }

    public static BOrd getGuideHelpOrd(BObject bObject) {
        return ObjectUtil.getGuideHelpOrd(bObject.getType().getTypeInfo());
    }

    public static BOrd toSpyRelative(BObject bObject) {
        BINavNode bINavNode;
        String string;
        if (bObject instanceof BINavNode && (string = ObjectUtil.toNavPath(bINavNode = (BINavNode)((Object)bObject), BNavRoot.INSTANCE)) != null) {
            return BOrd.make("spy:/nav" + string);
        }
        return null;
    }

    public static BOrd toSpyLocal(BObject bObject) {
        BINavNode bINavNode;
        String string;
        if (bObject instanceof BINavNode && (string = ObjectUtil.toNavPath(bINavNode = (BINavNode)((Object)bObject), BNavRoot.INSTANCE)) != null) {
            return BOrd.make("local:|spy:/nav" + string);
        }
        return null;
    }

    public static BOrd toSpyRemote(BObject bObject) {
        String string;
        BISpaceNode bISpaceNode;
        BISession bISession;
        if (bObject instanceof BISpaceNode && (bISession = (bISpaceNode = (BISpaceNode)((Object)bObject)).getSession()) != null && (string = ObjectUtil.toNavPath(bISpaceNode, bISession)) != null) {
            return BOrd.make(bISession.getNavOrd() + "|spy:/nav/localhost" + string);
        }
        return null;
    }

    static String toNavPath(BINavNode object, Object object2) {
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeInfo typeInfo = Sys.getRegistry().getType("file:BogFile");
        TypeInfo typeInfo2 = Sys.getRegistry().getType("baja:VirtualComponentSpace");
        TypeInfo typeInfo3 = Sys.getRegistry().getType("fox:FoxVirtualSpace");
        while (object != null && object != object2) {
            object3 = object.getNavParent();
            if (object instanceof BComponentSpace || object.getType().is(typeInfo) || object3 != null && (object3.getType().is(typeInfo2) || object3.getType().is(typeInfo3))) {
                object = object.getNavParent();
                continue;
            }
            String string = object.getNavName();
            if (string == null) {
                return null;
            }
            arrayList.add(string);
            object = object3;
        }
        object3 = new StringBuffer();
        int n = arrayList.size() - 1;
        while (n >= 0) {
            String string = (String)arrayList.get(n);
            ((StringBuffer)object3).append('/').append(SlotPath.escape(string));
            --n;
        }
        return ((StringBuffer)object3).toString();
    }

    public static void dump(BComplex bComplex) {
        PrintWriter printWriter = new PrintWriter(System.out);
        ObjectUtil.dump(printWriter, bComplex);
        printWriter.flush();
    }

    public static void dump(PrintWriter printWriter, BComplex bComplex) {
        ObjectUtil.dump(null, printWriter, bComplex, false);
    }

    public static void dumpComponents(BComplex bComplex) {
        PrintWriter printWriter = new PrintWriter(System.out);
        ObjectUtil.dumpComponents(printWriter, bComplex);
        printWriter.flush();
    }

    public static void dumpComponents(PrintWriter printWriter, BComplex bComplex) {
        ObjectUtil.dump(null, printWriter, bComplex, true);
    }

    private static final void dump(String string, PrintWriter printWriter, BComplex bComplex, boolean bl) {
        if (string == null) {
            string = "";
        }
        printWriter.print(string);
        printWriter.print(bComplex.getName());
        printWriter.print(" [" + bComplex.getType() + "] ");
        if (bComplex.isComponent()) {
            printWriter.print(" h=" + bComplex.asComponent().getHandle());
        }
        printWriter.println();
        String string2 = string + "  ";
        SlotCursor slotCursor = bComplex.getProperties();
        while (slotCursor.next()) {
            BObject bObject = slotCursor.get();
            if (bl && !(bObject instanceof BComponent)) continue;
            if (bObject instanceof BComplex) {
                ObjectUtil.dump(string2, printWriter, (BComplex)bObject, bl);
                continue;
            }
            printWriter.print(string2);
            printWriter.print(slotCursor.property().getName());
            printWriter.print(": ");
            printWriter.println(slotCursor.get());
        }
    }

    public static interface NameContainer {
        public boolean contains(String var1);
    }
}

