/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BRetryableAction
extends BComponent {
    public static final Property status = BRetryableAction.newProperty(3, BStatus.ok, null);
    public static final Property faultCause = BRetryableAction.newProperty(3, "", BFacets.make("fieldWidth", 55));
    public static final Property delay = BRetryableAction.newProperty(0, BRelTime.makeSeconds(30), BFacets.make("min", BRelTime.DEFAULT));
    public static final Property retryInterval = BRetryableAction.newProperty(0, BRelTime.makeMinutes(5), BFacets.make("min", BRelTime.makeSeconds(15)));
    public static final Property lastSuccess = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    public static final Property lastAttempt = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    public static final Property nextExecuteTime = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    public static final Action schedule = BRetryableAction.newAction(0, null);
    public static final Action execute = BRetryableAction.newAction(16, null);
    public static final Action cancel = BRetryableAction.newAction(0, null);
    public static final Type TYPE;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$util$BRetryableAction;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BRelTime getDelay() {
        return (BRelTime)this.get(delay);
    }

    public void setDelay(BRelTime bRelTime) {
        this.set(delay, (BValue)bRelTime, null);
    }

    public BRelTime getRetryInterval() {
        return (BRelTime)this.get(retryInterval);
    }

    public void setRetryInterval(BRelTime bRelTime) {
        this.set(retryInterval, (BValue)bRelTime, null);
    }

    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    public void setLastSuccess(BAbsTime bAbsTime) {
        this.set(lastSuccess, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    public void setLastAttempt(BAbsTime bAbsTime) {
        this.set(lastAttempt, (BValue)bAbsTime, null);
    }

    public BAbsTime getNextExecuteTime() {
        return (BAbsTime)this.get(nextExecuteTime);
    }

    public void setNextExecuteTime(BAbsTime bAbsTime) {
        this.set(nextExecuteTime, (BValue)bAbsTime, null);
    }

    public void schedule() {
        this.invoke(schedule, null, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.isRetryCondition()) {
            this.schedule();
        }
    }

    public final void doSchedule() {
        BAbsTime bAbsTime = Clock.time();
        BAbsTime bAbsTime2 = this.getNextExecuteTime();
        if (bAbsTime2.isNull() || this.ticket.isExpired()) {
            this.cancelTicket();
            BAbsTime bAbsTime3 = bAbsTime.add(this.getDelay());
            this.ticket = Clock.schedule((BComponent)this, bAbsTime3, execute, null);
            this.setNextExecuteTime(bAbsTime3);
        }
    }

    public final void doExecute() {
        try {
            this.setLastAttempt(Clock.time());
            this.cancelTicket();
            this.doExecution();
            this.configSuccess();
        }
        catch (Exception exception) {
            this.configFail(exception);
        }
    }

    protected abstract void doExecution() throws Exception;

    public final void doCancel() {
        this.stopRetrying();
        this.canceled();
    }

    protected void canceled() {
    }

    protected final void configSuccess() {
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.setNextExecuteTime(BAbsTime.NULL);
        this.setLastSuccess(Clock.time());
    }

    private final void configFail(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = "Execution failed.";
            exception.printStackTrace();
        }
        this.setStatus(BStatus.fault);
        this.setFaultCause(string);
        this.scheduleRetry();
    }

    protected void scheduleRetry() {
        this.cancelTicket();
        BAbsTime bAbsTime = Clock.time().add(this.getRetryInterval());
        this.ticket = Clock.schedule((BComponent)this, bAbsTime, execute, null);
        this.setNextExecuteTime(bAbsTime);
    }

    protected final void stopRetrying() {
        this.cancelTicket();
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.setNextExecuteTime(BAbsTime.NULL);
    }

    protected final void cancelTicket() {
        this.ticket.cancel();
        this.ticket = Clock.expiredTicket;
    }

    public final boolean isRetryCondition() {
        boolean bl = false;
        if (!this.getNextExecuteTime().isNull() || this.getLastAttempt().isAfter(this.getLastSuccess())) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ticket = Clock.expiredTicket;
    }

    public BRetryableAction() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$util$BRetryableAction;
        if (clazz == null) {
            clazz = class$com$tridium$util$BRetryableAction = BRetryableAction.class("[Lcom.tridium.util.BRetryableAction;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

