/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import java.io.IOException;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class TzXmlDecoder {
    public static BTimeZone getTimeZone(XElem xElem) throws IOException {
        return TzXmlDecoder.getTimeZone(xElem, true);
    }

    public static BTimeZone getTimeZone(XElem xElem, boolean bl) throws IOException {
        XElem xElem2;
        BTimeZone bTimeZone = null;
        String string = xElem.get("id");
        int n = TzXmlDecoder.getRelTime("utcOffset", xElem, true);
        String string2 = string;
        String string3 = string;
        String string4 = string;
        String string5 = string;
        XElem xElem3 = xElem.elem("display");
        if (xElem3 != null) {
            string2 = xElem3.get("name", string);
            string3 = xElem3.get("short", string2);
            string4 = xElem3.get("dstName", string);
            string5 = xElem3.get("dstShort", string4);
        }
        if ((xElem2 = xElem.elem("dst")) == null) {
            bTimeZone = bl ? BTimeZone.make(string, n) : BTimeZone.makeIgnoringCache(string, n);
        } else {
            int n2 = TzXmlDecoder.getRelTime("savings", xElem2, true);
            DstRule dstRule = TzXmlDecoder.getRule("start", xElem2, true);
            DstRule dstRule2 = TzXmlDecoder.getRule("end", xElem2, true);
            bTimeZone = bl ? BTimeZone.make(string, string2, string3, string4, string5, n, n2, dstRule, dstRule2) : BTimeZone.makeIgnoringCache(string, string2, string3, string4, string5, n, n2, dstRule, dstRule2);
        }
        return bTimeZone;
    }

    public static int getRelTime(String string, XElem xElem, boolean bl) {
        String string2 = xElem.get(string, null);
        if (string2 == null) {
            if (bl) {
                throw new XException("Missing \"" + string + "\" attribute.", xElem);
            }
            return -1;
        }
        try {
            if (string2.endsWith("h")) {
                return (int)(Float.parseFloat(string2.substring(0, string2.length() - 1)) * 3600000.0f);
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new XException("Invalid time format: " + string2, xElem);
        }
    }

    public static DstRule getRule(String string, XElem xElem, boolean bl) throws IOException {
        String string2;
        String string3;
        BTime bTime = null;
        int n = -1;
        BMonth bMonth = null;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        BWeekday bWeekday = null;
        XElem xElem2 = xElem.elem(string);
        if (xElem2 == null) {
            if (bl) {
                throw new XException("Missing \"" + string + "\" element.", xElem);
            }
            return null;
        }
        String string4 = xElem2.get("time");
        int n5 = string4.indexOf(32);
        if (n5 == -1) {
            bTime = TzXmlDecoder.parseTime(string4);
            n = 0;
        } else {
            bTime = TzXmlDecoder.parseTime(string4.substring(0, n5));
            n = DstRule.decodeTimeMode(string4.substring(n5 + 1));
        }
        String string5 = xElem2.get("month");
        bMonth = (BMonth)BMonth.january.decodeFromString(string5);
        String string6 = xElem2.get("weekday", null);
        if (string6 != null) {
            bWeekday = (BWeekday)BWeekday.sunday.decodeFromString(string6);
        }
        if ((string3 = xElem2.get("week", null)) != null) {
            try {
                n4 = DstRule.decodeWeek(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XException("Invalid week specification: " + string3, xElem2);
            }
        } else {
            n4 = -1;
        }
        if ((string2 = xElem2.get("day", null)) != null) {
            if (string2.endsWith("...")) {
                n3 = 1;
                n2 = Integer.parseInt(string2.substring(0, string2.length() - 3));
            } else if (string2.startsWith("...")) {
                n3 = 2;
                n2 = Integer.parseInt(string2.substring(3));
            } else {
                n3 = 0;
                n2 = Integer.parseInt(string2);
            }
        } else {
            n3 = -1;
        }
        if (n3 == -1) {
            if (n4 == -1) {
                throw new XException("Week is required if no day is specified.", xElem2);
            }
            if (bWeekday == null) {
                throw new XException("Weekday is required if no day is specified.", xElem2);
            }
            return DstRule.makeWeekday(bTime, n, n4, bWeekday, bMonth);
        }
        if (n3 == 0) {
            if (n4 != -1) {
                throw new XException("\"week\" is not a valid attribute for exact day rules.", xElem2);
            }
            if (bWeekday != null) {
                throw new XException("\"weekday\" is not a valid attribute for exact day rules.", xElem2);
            }
            return DstRule.makeExact(bTime, n, bMonth, n2);
        }
        if (n3 == 1) {
            if (n4 != -1) {
                throw new XException("\"week\" is not a valid attribute for \"on or after\" rules.", xElem2);
            }
            if (bWeekday == null) {
                throw new XException("\"weekday\" is a required attribute for \"on or after\" rules.", xElem2);
            }
            return DstRule.makeOnOrAfter(bTime, n, bMonth, n2, bWeekday);
        }
        if (n3 == 2) {
            if (n4 != -1) {
                throw new XException("\"week\" is not a valid attribute for \"on or before\" rules.", xElem2);
            }
            if (bWeekday == null) {
                throw new XException("\"weekday\" is a required attribute for \"on or before\" rules.", xElem2);
            }
            return DstRule.makeOnOrBefore(bTime, n, bMonth, n2, bWeekday);
        }
        throw new XException("Invalid day mode: " + n3, xElem2);
    }

    public static BTime parseTime(String string) {
        int n = string.indexOf(58);
        int n2 = Integer.parseInt(string.substring(0, n));
        int n3 = Integer.parseInt(string.substring(n + 1));
        return BTime.make(n2, n3, 0, 0);
    }
}

