/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimeZoneDatabaseManifest {
    private XElem rootElem;
    private Map zoneElemsById;
    private Version version;

    public static TimeZoneDatabaseManifest make(InputStream inputStream) throws Exception {
        return TimeZoneDatabaseManifest.make(XParser.make((InputStream)inputStream).parse(true));
    }

    public static TimeZoneDatabaseManifest make(XElem xElem) {
        if (xElem.name().equals("htzdb")) {
            return new TimeZoneDatabaseManifest(xElem);
        }
        if (xElem.name().equals("timezonedb")) {
            TimeZoneDatabaseManifest timeZoneDatabaseManifest = new TimeZoneDatabaseManifest(new XElem("htzdb"));
            XElem xElem2 = xElem.elem("config");
            timeZoneDatabaseManifest.setMinYear(xElem2.geti("minYear", 1995));
            timeZoneDatabaseManifest.setMaxYear(xElem2.geti("maxYear", 2015));
            XElem[] xElemArray = xElem.elem("timezones").elems("zone");
            int n = 0;
            while (n < xElemArray.length) {
                timeZoneDatabaseManifest.addZoneId(xElemArray[n].get("id"));
                ++n;
            }
            return timeZoneDatabaseManifest;
        }
        throw new IllegalArgumentException("not a valid time zone database manifest");
    }

    public void write(OutputStream outputStream) throws IOException {
        XWriter xWriter = new XWriter(outputStream);
        this.rootElem.write(xWriter);
        xWriter.flush();
    }

    public String getSource() {
        return this.rootElem.get("source", null);
    }

    public void setSource(String string) {
        this.rootElem.setAttr("source", string);
    }

    public String getDescription() {
        return this.rootElem.get("description", null);
    }

    public void setDescription(String string) {
        this.rootElem.setAttr("description", string);
    }

    public String getVendor() {
        return this.rootElem.get("vendor", "");
    }

    public void setVendor(String string) {
        this.rootElem.setAttr("vendor", string);
    }

    public Version getVersion() {
        if (this.version == null) {
            this.version = new Version(this.rootElem.get("version", ""));
        }
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
        this.rootElem.setAttr("version", version.toString());
    }

    public int getMinYear() {
        return this.rootElem.geti("minYear", 1995);
    }

    public void setMinYear(int n) {
        this.rootElem.setAttr("minYear", String.valueOf(n));
    }

    public int getMaxYear() {
        return this.rootElem.geti("maxYear", 2015);
    }

    public void setMaxYear(int n) {
        this.rootElem.setAttr("maxYear", String.valueOf(n));
    }

    public String[] getZoneIds() {
        String[] stringArray = new String[this.zoneElemsById.size()];
        this.zoneElemsById.keySet().toArray(stringArray);
        return stringArray;
    }

    public boolean containsZoneId(String string) {
        return this.zoneElemsById.containsKey(string);
    }

    public void addZoneId(String string) {
        if (this.containsZoneId(string)) {
            return;
        }
        XElem xElem = new XElem("zone");
        xElem.setAttr("id", string);
        this.rootElem.addContent((XContent)xElem);
        this.zoneElemsById.put(string, xElem);
    }

    public void removeZoneId(String string) {
        XElem xElem = (XElem)this.zoneElemsById.get(string);
        if (xElem != null) {
            this.rootElem.removeContent((XContent)xElem);
            this.zoneElemsById.remove(string);
        }
    }

    private final /* synthetic */ void this() {
        this.version = null;
    }

    private TimeZoneDatabaseManifest(XElem xElem) {
        this.this();
        this.rootElem = xElem.copy();
        this.zoneElemsById = new TreeMap();
        XElem[] xElemArray = this.rootElem.elems("zone");
        int n = 0;
        while (n < xElemArray.length) {
            this.zoneElemsById.put(xElemArray[n].get("id"), xElemArray[n]);
            ++n;
        }
    }
}

