/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import com.tridium.timezone.HistoricalTimeZone;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneException;

public final class HistoricalTimeZoneDate {
    public static final short ANNUAL = -1;
    private static final short[] daysInMonth = new short[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final HistoricalTimeZoneDate END_OF_TIME = HistoricalTimeZoneDate.makeMaximumDate();
    public static final HistoricalTimeZoneDate START_OF_TIME = HistoricalTimeZoneDate.makeMinimumDate();
    private short theYear;
    private short theTimeOfDayIsExpressedIn;
    private BMonth theMonth;
    private HistoricalTimeZoneDay theDay;
    private BTime theTimeOfDay;

    public static final String timePolicyToString(short s) {
        switch (s) {
            case 1: {
                return "Standard Time";
            }
            case 2: {
                return "Coordinated Universal Time";
            }
            case 0: {
                return "Wall Time";
            }
        }
        return "Unknown";
    }

    public static final HistoricalTimeZoneDate make() {
        return HistoricalTimeZoneDate.makeFromEpochMillis(System.currentTimeMillis());
    }

    public static final HistoricalTimeZoneDate makeFromEpochMillis(long l) {
        HistoricalTimeZoneDate historicalTimeZoneDate = new HistoricalTimeZoneDate();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        gregorianCalendar.clear();
        gregorianCalendar.setTimeInMillis(l);
        historicalTimeZoneDate.theYear = (short)gregorianCalendar.get(1);
        historicalTimeZoneDate.theMonth = BMonth.make((short)gregorianCalendar.get(2));
        historicalTimeZoneDate.theDay = HistoricalTimeZoneDay.makeExactDay((short)gregorianCalendar.get(5));
        historicalTimeZoneDate.theTimeOfDay = BTime.make(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14));
        historicalTimeZoneDate.theTimeOfDayIsExpressedIn = (short)2;
        return historicalTimeZoneDate;
    }

    public static final HistoricalTimeZoneDate make(short s, BMonth bMonth, HistoricalTimeZoneDay historicalTimeZoneDay, BTime bTime, short s2) {
        HistoricalTimeZoneDate historicalTimeZoneDate = new HistoricalTimeZoneDate();
        historicalTimeZoneDate.theYear = s;
        historicalTimeZoneDate.theMonth = bMonth;
        historicalTimeZoneDate.theDay = historicalTimeZoneDay;
        historicalTimeZoneDate.theTimeOfDay = bTime;
        historicalTimeZoneDate.theTimeOfDayIsExpressedIn = s2;
        return historicalTimeZoneDate;
    }

    public final void update(short s, BMonth bMonth, HistoricalTimeZoneDay historicalTimeZoneDay, BTime bTime, short s2) {
        this.theYear = s;
        this.theMonth = bMonth;
        this.theDay = historicalTimeZoneDay;
        this.theTimeOfDay = bTime;
        this.theTimeOfDayIsExpressedIn = s2;
    }

    public final void update(HistoricalTimeZoneDate historicalTimeZoneDate) {
        this.update(historicalTimeZoneDate.theYear, historicalTimeZoneDate.theMonth, historicalTimeZoneDate.theDay, historicalTimeZoneDate.theTimeOfDay, historicalTimeZoneDate.theTimeOfDayIsExpressedIn);
    }

    public static final HistoricalTimeZoneDate makeMinimumDate() {
        return HistoricalTimeZoneDate.make((short)HistoricalTimeZone.MIN_YEAR, BMonth.january, HistoricalTimeZoneDay.FIRST_DAY_OF_YEAR, BTime.MIDNIGHT, (short)0);
    }

    public static final HistoricalTimeZoneDate makeMaximumDate() {
        return HistoricalTimeZoneDate.make((short)HistoricalTimeZone.MAX_YEAR, BMonth.december, HistoricalTimeZoneDay.LAST_DAY_OF_YEAR, BTime.make(23, 59, 59, 999), (short)0);
    }

    public static final HistoricalTimeZoneDate makeYearStart(short s) {
        return HistoricalTimeZoneDate.make(s, BMonth.january, HistoricalTimeZoneDay.FIRST_DAY_OF_YEAR, BTime.MIDNIGHT, (short)0);
    }

    public static final HistoricalTimeZoneDate makeYearEnd(short s) {
        return HistoricalTimeZoneDate.make(s, BMonth.december, HistoricalTimeZoneDay.LAST_DAY_OF_YEAR, BTime.make(23, 59, 59, 999), (short)0);
    }

    public static final HistoricalTimeZoneDate makeYearMonthStart(short s, BMonth bMonth) {
        return HistoricalTimeZoneDate.make(s, bMonth, HistoricalTimeZoneDay.FIRST_DAY_OF_YEAR, BTime.MIDNIGHT, (short)0);
    }

    public static final HistoricalTimeZoneDate makeYearMonthEnd(short s, BMonth bMonth) {
        short s2 = daysInMonth[bMonth.getOrdinal()];
        if (bMonth.equals(BMonth.february) && HistoricalTimeZoneDate.isLeapYear(s)) {
            s2 = (short)(s2 + 1);
        }
        return HistoricalTimeZoneDate.make(s, bMonth, HistoricalTimeZoneDay.makeExactDay(s2), BTime.make(23, 59, 59, 999), (short)0);
    }

    public static final HistoricalTimeZoneDate makeYearMonthDayStart(short s, BMonth bMonth, short s2) throws TimeZoneException {
        short s3 = daysInMonth[bMonth.getOrdinal()];
        if (bMonth.equals(BMonth.february) && HistoricalTimeZoneDate.isLeapYear(s)) {
            s3 = (short)(s3 + 1);
        }
        if (s2 > s3) {
            throw new TimeZoneException("ERROR: Requested an invalid day of the month.");
        }
        return HistoricalTimeZoneDate.make(s, bMonth, HistoricalTimeZoneDay.makeExactDay(s2), BTime.MIDNIGHT, (short)0);
    }

    public static final HistoricalTimeZoneDate makeYearMonthDayEnd(short s, BMonth bMonth, short s2) throws TimeZoneException {
        short s3 = daysInMonth[bMonth.getOrdinal()];
        if (bMonth.equals(BMonth.february) && HistoricalTimeZoneDate.isLeapYear(s)) {
            s3 = (short)(s3 + 1);
        }
        if (s2 > s3) {
            throw new TimeZoneException("ERROR: Requested an invalid day of the month.");
        }
        return HistoricalTimeZoneDate.make(s, bMonth, HistoricalTimeZoneDay.makeExactDay(s2), BTime.make(23, 59, 59, 999), (short)0);
    }

    public static final HistoricalTimeZoneDate makeAnnualDate(BMonth bMonth, HistoricalTimeZoneDay historicalTimeZoneDay, BTime bTime, short s) {
        return HistoricalTimeZoneDate.make((short)-1, bMonth, historicalTimeZoneDay, bTime, s);
    }

    public static final HistoricalTimeZoneDate makeAnnualDate() {
        return HistoricalTimeZoneDate.makeAnnualDate(BMonth.january, HistoricalTimeZoneDay.makeExactDay((short)1), BTime.MIDNIGHT, (short)0);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HistoricalTimeZoneDate)) {
            return false;
        }
        HistoricalTimeZoneDate historicalTimeZoneDate = (HistoricalTimeZoneDate)object;
        boolean bl = false;
        if (this.theYear == historicalTimeZoneDate.theYear && this.theMonth.equals(historicalTimeZoneDate.theMonth) && this.theDay.equals(historicalTimeZoneDate.theDay) && this.theTimeOfDay.equals(historicalTimeZoneDate.theTimeOfDay) && this.theTimeOfDayIsExpressedIn == historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        if (this.theDay.getDayExpressedAs() == 0 && this.theDay.calendarDay != 0) {
            if (this.theYear == -1) {
                return "Annually on the " + this.theMonth.toString() + ' ' + this.theDay.toString() + " at " + this.theTimeOfDay.encodeToString() + ' ' + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
            }
            return this.theMonth.toString() + ' ' + this.theDay.toString() + ", " + this.theYear + " at " + this.theTimeOfDay.encodeToString() + ' ' + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
        }
        if (this.theYear == -1) {
            return "Annually on the " + this.theDay.toString() + ' ' + this.theMonth.toString() + " at " + this.theTimeOfDay.encodeToString() + ' ' + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
        }
        return this.theDay.toString() + ' ' + this.theMonth.toString() + ", " + this.theYear + " at " + this.theTimeOfDay.encodeToString() + ' ' + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public final StringTokenizer makeHistoricalTimeZoneDateFromString(StringTokenizer stringTokenizer) {
        short s;
        this.theMonth = BMonth.january;
        this.theTimeOfDay = BTime.DEFAULT;
        this.theDay = HistoricalTimeZoneDay.make();
        this.theTimeOfDayIsExpressedIn = 0;
        int n = 0;
        String string = null;
        if (true) {
            return stringTokenizer;
        }
        do {
            switch (n) {
                case 1: {
                    if (string.equalsIgnoreCase("Jan") || string.equalsIgnoreCase("January")) {
                        this.theMonth = BMonth.january;
                        break;
                    }
                    if (string.equalsIgnoreCase("Feb") || string.equalsIgnoreCase("February")) {
                        this.theMonth = BMonth.february;
                        break;
                    }
                    if (string.equalsIgnoreCase("Mar") || string.equalsIgnoreCase("March")) {
                        this.theMonth = BMonth.march;
                        break;
                    }
                    if (string.equalsIgnoreCase("Apr") || string.equalsIgnoreCase("April")) {
                        this.theMonth = BMonth.april;
                        break;
                    }
                    if (string.equalsIgnoreCase("May") || string.equalsIgnoreCase("May")) {
                        this.theMonth = BMonth.may;
                        break;
                    }
                    if (string.equalsIgnoreCase("Jun") || string.equalsIgnoreCase("June")) {
                        this.theMonth = BMonth.june;
                        break;
                    }
                    if (string.equalsIgnoreCase("Jul") || string.equalsIgnoreCase("July")) {
                        this.theMonth = BMonth.july;
                        break;
                    }
                    if (string.equalsIgnoreCase("Aug") || string.equalsIgnoreCase("August")) {
                        this.theMonth = BMonth.august;
                        break;
                    }
                    if (string.equalsIgnoreCase("Sep") || string.equalsIgnoreCase("September")) {
                        this.theMonth = BMonth.september;
                        break;
                    }
                    if (string.equalsIgnoreCase("Oct") || string.equalsIgnoreCase("October")) {
                        this.theMonth = BMonth.october;
                        break;
                    }
                    if (string.equalsIgnoreCase("Nov") || string.equalsIgnoreCase("November")) {
                        this.theMonth = BMonth.november;
                        break;
                    }
                    if (string.equalsIgnoreCase("Dec") || string.equalsIgnoreCase("December")) {
                        this.theMonth = BMonth.december;
                        break;
                    }
                    this.theMonth = BMonth.january;
                    break;
                }
                case 2: {
                    this.theDay = HistoricalTimeZoneDay.decodeFromString(string);
                    break;
                }
                case 3: {
                    if (string.endsWith("s")) {
                        this.theTimeOfDayIsExpressedIn = 1;
                        string = string.substring(0, string.length() - 1);
                    } else if (string.endsWith("u") || string.endsWith("z") || string.endsWith("g")) {
                        this.theTimeOfDayIsExpressedIn = (short)2;
                        string = string.substring(0, string.length() - 1);
                    } else {
                        this.theTimeOfDayIsExpressedIn = 0;
                    }
                    long l = HistoricalTimeZoneDate.parseTime(string);
                    if (l == 86400000L) {
                        --l;
                    }
                    this.theTimeOfDay = BTime.make(BRelTime.make(l));
                    break;
                }
            }
            if (!stringTokenizer.hasMoreTokens()) return stringTokenizer;
            s = (short)(n + 1);
            n = s;
        } while (s < 4 && !(string = stringTokenizer.nextToken()).startsWith("#"));
        return stringTokenizer;
    }

    public final HistoricalTimeZoneDate convertToExactDate() throws TimeZoneException {
        if (this.theDay.getDayExpressedAs() != 0 && this.theDay.calendarDay != 0) {
            if (this.theYear == -1) {
                throw new TimeZoneException("ERROR: Cannot convert annual date without year");
            }
            Calendar calendar = this.toGregorianCalendar(this.theYear);
            this.theYear = (short)calendar.get(1);
            this.theMonth = BMonth.make(calendar.get(2));
            this.theDay.dayExpressedAs = (short)0;
            this.theDay.calendarDay = (short)calendar.get(5);
            this.theDay.dayOfWeek = BWeekday.make(calendar.get(7) - 1);
            this.theTimeOfDay = BTime.make(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        }
        return this;
    }

    public static final long parseTime(String string) {
        short s = 0;
        String string2 = "0";
        String string3 = "0";
        String string4 = "0";
        String string5 = "0";
        s = (short)string.indexOf(":");
        if (s != -1) {
            string2 = string.substring(0, s);
            if ((s = (short)(string = string.substring(s + 1, string.length())).indexOf(":")) != -1) {
                string3 = string.substring(0, s);
                if ((s = (short)(string = string.substring(s + 1, string.length())).indexOf(".")) != -1) {
                    string4 = string.substring(0, s);
                    string5 = string.substring(s + 1, string.length());
                } else {
                    string4 = string;
                }
            } else {
                string3 = string;
            }
        } else if (!string.equals("-")) {
            string2 = string;
        }
        long l = (long)Integer.parseInt(string2) * 3600000L;
        l += (long)Integer.parseInt(string3) * 60000L;
        l += (long)Integer.parseInt(string4) * 1000L;
        return l += (long)Integer.parseInt(string5);
    }

    private static final boolean isLeapYear(short s) {
        boolean bl = false;
        if (s % 4 == 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (bl2 && s % 100 != 0) {
            bl3 = true;
        }
        bl2 = bl3;
        boolean bl4 = false;
        if (bl2 || s % 400 == 0) {
            bl4 = true;
        }
        bl2 = bl4;
        return bl2;
    }

    public final HistoricalTimeZoneDate convertAnnualDateForYear(short s) throws TimeZoneException {
        boolean bl;
        boolean bl2 = false;
        if (this.theYear == -1) {
            bl2 = true;
        }
        if (!(bl = bl2)) {
            throw new TimeZoneException("ERROR: convertAnnualDateForYear cannot convert NON-ANNUAL dates");
        }
        HistoricalTimeZoneDate historicalTimeZoneDate = new HistoricalTimeZoneDate(this);
        historicalTimeZoneDate.setTheYear(s);
        return historicalTimeZoneDate.convertToExactDate();
    }

    public final Calendar toGregorianCalendar(short s) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        gregorianCalendar.clear();
        gregorianCalendar.set(1, s);
        gregorianCalendar.set(2, this.theMonth.getOrdinal());
        gregorianCalendar.setLenient(false);
        short s2 = this.theDay.getDayExpressedAs();
        short s3 = this.theDay.getCalendarDay();
        if (s2 == 0 && s3 != 0) {
            gregorianCalendar.set(5, this.theDay.getCalendarDay());
        } else if ((s2 == 1 || s2 == 2) && s3 != 0) {
            gregorianCalendar.set(5, this.theDay.getCalendarDay());
            while (gregorianCalendar.get(7) != this.theDay.getDayOfWeek().getOrdinal() + 1) {
                if (s2 == 1) {
                    ((Calendar)gregorianCalendar).add(5, 1);
                    continue;
                }
                ((Calendar)gregorianCalendar).add(5, -1);
            }
        } else if (s2 == 4 || s2 == 5) {
            gregorianCalendar.set(5, ((Calendar)gregorianCalendar).getActualMaximum(5));
            while (gregorianCalendar.get(7) != this.theDay.getDayOfWeek().getOrdinal() + 1) {
                ((Calendar)gregorianCalendar).add(5, -1);
            }
        } else {
            int n = 0;
            if (s2 == 0) {
                n = 1;
            } else if (s2 == 1) {
                n = 8;
            } else if (s2 == 2) {
                n = 15;
            } else if (s2 == 3) {
                n = 22;
            }
            gregorianCalendar.set(5, n);
            while (gregorianCalendar.get(7) != this.theDay.getDayOfWeek().getOrdinal() + 1) {
                ((Calendar)gregorianCalendar).add(5, 1);
            }
        }
        gregorianCalendar.set(11, this.theTimeOfDay.getHour());
        gregorianCalendar.set(12, this.theTimeOfDay.getMinute());
        gregorianCalendar.set(13, this.theTimeOfDay.getSecond());
        gregorianCalendar.set(14, this.theTimeOfDay.getMillisecond());
        return gregorianCalendar;
    }

    public static final boolean canBeCompared(HistoricalTimeZoneDate historicalTimeZoneDate, HistoricalTimeZoneDate historicalTimeZoneDate2) {
        if (historicalTimeZoneDate.theYear != -1 && historicalTimeZoneDate2.theYear != -1 && historicalTimeZoneDate.theYear != historicalTimeZoneDate2.theYear) {
            return true;
        }
        if (historicalTimeZoneDate.theMonth != historicalTimeZoneDate2.theMonth) {
            return true;
        }
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0 && historicalTimeZoneDate2.theDay.dayExpressedAs == 1) {
            if (historicalTimeZoneDate.theDay.calendarDay < historicalTimeZoneDate2.theDay.calendarDay) {
                return true;
            }
            if (historicalTimeZoneDate.theDay.calendarDay > historicalTimeZoneDate2.theDay.calendarDay + 7) {
                return true;
            }
        }
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0 && historicalTimeZoneDate2.theDay.dayExpressedAs == 2) {
            if (historicalTimeZoneDate.theDay.calendarDay < historicalTimeZoneDate2.theDay.calendarDay - 7) {
                return true;
            }
            if (historicalTimeZoneDate.theDay.calendarDay > historicalTimeZoneDate2.theDay.calendarDay) {
                return true;
            }
        }
        if (historicalTimeZoneDate2.theDay.dayExpressedAs == 0 && historicalTimeZoneDate2.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate2.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.calendarDay != historicalTimeZoneDate2.theDay.calendarDay) {
            return true;
        }
        if (historicalTimeZoneDate.theTimeOfDayIsExpressedIn != historicalTimeZoneDate2.theTimeOfDayIsExpressedIn) {
            return false;
        }
        return false;
    }

    public final boolean occursAfterAbsolute(HistoricalTimeZoneDate historicalTimeZoneDate) throws TimeZoneException {
        Calendar calendar;
        if (this.theYear == -1 && historicalTimeZoneDate.theYear == -1) {
            throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 annual dates, use occursAfterForYear instead");
        }
        if (this.theYear != -1 && historicalTimeZoneDate.theYear != -1) {
            if (this.theYear < historicalTimeZoneDate.theYear) {
                return false;
            }
            if (this.theYear > historicalTimeZoneDate.theYear) {
                return true;
            }
        }
        if (this.theMonth.getMonthOfYear() < historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theMonth.getMonthOfYear() > historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isAfter(historicalTimeZoneDate.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay - 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay + 7) {
                return true;
            }
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
        }
        short s = this.theYear == -1 ? historicalTimeZoneDate.theYear : this.theYear;
        boolean bl = false;
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        Calendar calendar2 = !bl2 ? this.toGregorianCalendar(s) : null;
        Calendar calendar3 = calendar = !bl4 ? historicalTimeZoneDate.toGregorianCalendar(s) : null;
        if (!bl2 && !bl4) {
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 times expressed differently");
            }
            return calendar2.after(calendar);
        }
        if (!bl2) {
            if (calendar2.get(5) < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (calendar2.get(5) > historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 times expressed differently");
            }
            if (calendar2.get(11) < historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return false;
            }
            if (calendar2.get(11) > historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return true;
            }
            if (calendar2.get(12) < historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return false;
            }
            if (calendar2.get(12) > historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return true;
            }
            if (calendar2.get(13) < historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return false;
            }
            if (calendar2.get(13) > historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return true;
            }
            boolean bl5 = false;
            if (calendar2.get(14) > historicalTimeZoneDate.theTimeOfDay.getMillisecond()) {
                bl5 = true;
            }
            return bl5;
        }
        if (this.theDay.calendarDay < calendar.get(5)) {
            return false;
        }
        if (this.theDay.calendarDay > calendar.get(5)) {
            return true;
        }
        if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
            throw new TimeZoneException("ERROR: occursAfteAbsolute comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < calendar.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getHour() > calendar.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() < calendar.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() > calendar.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() < calendar.get(13)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() > calendar.get(13)) {
            return true;
        }
        boolean bl6 = false;
        if (this.theTimeOfDay.getMillisecond() > calendar.get(14)) {
            bl6 = true;
        }
        return bl6;
    }

    public final boolean occursBeforeAbsolute(HistoricalTimeZoneDate historicalTimeZoneDate) throws TimeZoneException {
        Calendar calendar;
        if (this.theYear == -1 && historicalTimeZoneDate.theYear == -1) {
            throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 annual dates, use occursAfterForYear instead");
        }
        if (this.theYear != -1 && historicalTimeZoneDate.theYear != -1) {
            if (this.theYear < historicalTimeZoneDate.theYear) {
                return true;
            }
            if (this.theYear > historicalTimeZoneDate.theYear) {
                return false;
            }
        }
        if (this.theMonth.getMonthOfYear() < historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theMonth.getMonthOfYear() > historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isBefore(historicalTimeZoneDate.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay - 7) {
                return true;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
        }
        short s = this.theYear == -1 ? historicalTimeZoneDate.theYear : this.theYear;
        boolean bl = false;
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        Calendar calendar2 = !bl2 ? this.toGregorianCalendar(s) : null;
        Calendar calendar3 = calendar = !bl4 ? historicalTimeZoneDate.toGregorianCalendar(s) : null;
        if (!bl2 && !bl4) {
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
            }
            return calendar2.before(calendar);
        }
        if (!bl2) {
            if (calendar2.get(5) < historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (calendar2.get(5) > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
            }
            if (calendar2.get(11) < historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return true;
            }
            if (calendar2.get(11) > historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return false;
            }
            if (calendar2.get(12) < historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return true;
            }
            if (calendar2.get(12) > historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return false;
            }
            if (calendar2.get(13) < historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return true;
            }
            if (calendar2.get(13) > historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return false;
            }
            boolean bl5 = false;
            if (calendar2.get(14) < historicalTimeZoneDate.theTimeOfDay.getMillisecond()) {
                bl5 = true;
            }
            return bl5;
        }
        if (this.theDay.calendarDay < calendar.get(5)) {
            return true;
        }
        if (this.theDay.calendarDay > calendar.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
            throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < calendar.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getHour() > calendar.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() < calendar.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() > calendar.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() < calendar.get(13)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() > calendar.get(13)) {
            return false;
        }
        boolean bl6 = false;
        if (this.theTimeOfDay.getMillisecond() < calendar.get(14)) {
            bl6 = true;
        }
        return bl6;
    }

    public final boolean occursOnAbsolute(HistoricalTimeZoneDate historicalTimeZoneDate) throws TimeZoneException {
        Calendar calendar;
        if (this.theYear == -1 && historicalTimeZoneDate.theYear == -1) {
            throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 annual dates, use occursOnForYear instead");
        }
        if (this.theYear != -1 && historicalTimeZoneDate.theYear != -1 && this.theYear != historicalTimeZoneDate.theYear) {
            return false;
        }
        if (this.theMonth.getMonthOfYear() != historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay != historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.equivalent(historicalTimeZoneDate.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay - 7) {
                return false;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
        }
        short s = this.theYear == -1 ? historicalTimeZoneDate.theYear : this.theYear;
        boolean bl = false;
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        Calendar calendar2 = !bl2 ? this.toGregorianCalendar(s) : null;
        Calendar calendar3 = calendar = !bl4 ? historicalTimeZoneDate.toGregorianCalendar(s) : null;
        if (!bl2 && !bl4) {
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
            }
            return calendar2.equals(calendar);
        }
        if (!bl2) {
            if (calendar2.get(5) != historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
            }
            boolean bl5 = false;
            if (calendar2.get(11) == historicalTimeZoneDate.theTimeOfDay.getHour() && calendar2.get(12) == historicalTimeZoneDate.theTimeOfDay.getMinute() && calendar2.get(13) == historicalTimeZoneDate.theTimeOfDay.getSecond() && calendar2.get(14) == historicalTimeZoneDate.theTimeOfDay.getMillisecond()) {
                bl5 = true;
            }
            return bl5;
        }
        if (this.theDay.calendarDay != calendar.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
            throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
        }
        boolean bl6 = false;
        if (this.theTimeOfDay.getHour() == calendar.get(11) && this.theTimeOfDay.getMinute() == calendar.get(12) && this.theTimeOfDay.getSecond() == calendar.get(13) && this.theTimeOfDay.getMillisecond() == calendar.get(14)) {
            bl6 = true;
        }
        return bl6;
    }

    public final boolean occursAfterOrOnAbsolute(HistoricalTimeZoneDate historicalTimeZoneDate) throws TimeZoneException {
        try {
            boolean bl = false;
            if (this.occursOnAbsolute(historicalTimeZoneDate) || this.occursAfterAbsolute(historicalTimeZoneDate)) {
                bl = true;
            }
            return bl;
        }
        catch (TimeZoneException timeZoneException) {
            if (timeZoneException.getMessage().startsWith("ERROR")) {
                throw timeZoneException;
            }
            throw new TimeZoneException("ERROR: occursAfterOrOnAbsolute comparing 2 annual dates, use occursAfterOrOnForYear instead");
        }
    }

    public final boolean occursBeforeOrOnAbsolute(HistoricalTimeZoneDate historicalTimeZoneDate) throws TimeZoneException {
        try {
            boolean bl = false;
            if (this.occursOnAbsolute(historicalTimeZoneDate) || this.occursBeforeAbsolute(historicalTimeZoneDate)) {
                bl = true;
            }
            return bl;
        }
        catch (TimeZoneException timeZoneException) {
            if (timeZoneException.getMessage().startsWith("ERROR")) {
                throw timeZoneException;
            }
            throw new TimeZoneException("ERROR: occursBeforeOrOnAbsolute comparing 2 annual dates, use occursBeforeOrOnForYear instead");
        }
    }

    public final boolean occursAfterForYear(HistoricalTimeZoneDate historicalTimeZoneDate, short s) throws TimeZoneException {
        Calendar calendar;
        boolean bl;
        boolean bl2 = false;
        if (this.theYear == -1) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        boolean bl4 = false;
        if (historicalTimeZoneDate.theYear == -1) {
            bl4 = bl = true;
        }
        if (!bl3 && !bl) {
            if (this.theYear != historicalTimeZoneDate.theYear) {
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterAbsolute instead");
            }
            if (s != this.theYear) {
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 absolute dates for a different year than their own");
            }
        } else if (bl3 && !bl ? s != historicalTimeZoneDate.theYear : !bl3 && bl && s != this.theYear) {
            throw new TimeZoneException("ERROR: occursAfterForYear comparing absolute date for a different year than its own");
        }
        if (!bl3 || !bl) {
            return this.occursAfterAbsolute(historicalTimeZoneDate);
        }
        if (this.theMonth.getMonthOfYear() < historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theMonth.getMonthOfYear() > historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isAfter(historicalTimeZoneDate.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay - 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay + 7) {
                return true;
            }
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
        }
        boolean bl5 = false;
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            bl7 = true;
        }
        boolean bl8 = bl7;
        Calendar calendar2 = !bl6 ? this.toGregorianCalendar(s) : null;
        Calendar calendar3 = calendar = !bl8 ? historicalTimeZoneDate.toGregorianCalendar(s) : null;
        if (!bl6 && !bl8) {
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
            }
            return calendar2.after(calendar);
        }
        if (!bl6) {
            if (calendar2.get(5) < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (calendar2.get(5) > historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
            }
            if (calendar2.get(11) < historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return false;
            }
            if (calendar2.get(11) > historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return true;
            }
            if (calendar2.get(12) < historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return false;
            }
            if (calendar2.get(12) > historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return true;
            }
            if (calendar2.get(13) < historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return false;
            }
            if (calendar2.get(13) > historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return true;
            }
            boolean bl9 = false;
            if (calendar2.get(14) > historicalTimeZoneDate.theTimeOfDay.getMillisecond()) {
                bl9 = true;
            }
            return bl9;
        }
        if (this.theDay.calendarDay < calendar.get(5)) {
            return false;
        }
        if (this.theDay.calendarDay > calendar.get(5)) {
            return true;
        }
        if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
            throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < calendar.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getHour() > calendar.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() < calendar.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() > calendar.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() < calendar.get(13)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() > calendar.get(13)) {
            return true;
        }
        boolean bl10 = false;
        if (this.theTimeOfDay.getMillisecond() > calendar.get(14)) {
            bl10 = true;
        }
        return bl10;
    }

    public final boolean occursBeforeForYear(HistoricalTimeZoneDate historicalTimeZoneDate, short s) throws TimeZoneException {
        Calendar calendar;
        boolean bl;
        boolean bl2 = false;
        if (this.theYear == -1) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        boolean bl4 = false;
        if (historicalTimeZoneDate.theYear == -1) {
            bl4 = bl = true;
        }
        if (!bl3 && !bl) {
            if (this.theYear != historicalTimeZoneDate.theYear) {
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterAbsolute instead");
            }
            if (s != this.theYear) {
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 absolute dates for a different year than their own");
            }
        } else if (bl3 && !bl ? s != historicalTimeZoneDate.theYear : !bl3 && bl && s != this.theYear) {
            throw new TimeZoneException("ERROR: occursBeforeForYear comparing absolute date for a different year than its own");
        }
        if (!bl3 || !bl) {
            return this.occursBeforeAbsolute(historicalTimeZoneDate);
        }
        if (this.theMonth.getMonthOfYear() < historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theMonth.getMonthOfYear() > historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isBefore(historicalTimeZoneDate.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay - 7) {
                return true;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
        }
        boolean bl5 = false;
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            bl7 = true;
        }
        boolean bl8 = bl7;
        Calendar calendar2 = !bl6 ? this.toGregorianCalendar(s) : null;
        Calendar calendar3 = calendar = !bl8 ? historicalTimeZoneDate.toGregorianCalendar(s) : null;
        if (!bl6 && !bl8) {
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
            }
            return calendar2.before(calendar);
        }
        if (!bl6) {
            if (calendar2.get(5) < historicalTimeZoneDate.theDay.calendarDay) {
                return true;
            }
            if (calendar2.get(5) > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
            }
            if (calendar2.get(11) < historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return true;
            }
            if (calendar2.get(11) > historicalTimeZoneDate.theTimeOfDay.getHour()) {
                return false;
            }
            if (calendar2.get(12) < historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return true;
            }
            if (calendar2.get(12) > historicalTimeZoneDate.theTimeOfDay.getMinute()) {
                return false;
            }
            if (calendar2.get(13) < historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return true;
            }
            if (calendar2.get(13) > historicalTimeZoneDate.theTimeOfDay.getSecond()) {
                return false;
            }
            boolean bl9 = false;
            if (calendar2.get(14) < historicalTimeZoneDate.theTimeOfDay.getMillisecond()) {
                bl9 = true;
            }
            return bl9;
        }
        if (this.theDay.calendarDay < calendar.get(5)) {
            return true;
        }
        if (this.theDay.calendarDay > calendar.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
            throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < calendar.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getHour() > calendar.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() < calendar.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() > calendar.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() < calendar.get(13)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() > calendar.get(13)) {
            return false;
        }
        boolean bl10 = false;
        if (this.theTimeOfDay.getMillisecond() < calendar.get(14)) {
            bl10 = true;
        }
        return bl10;
    }

    public final boolean occursOnForYear(HistoricalTimeZoneDate historicalTimeZoneDate, short s) throws TimeZoneException {
        Calendar calendar;
        boolean bl;
        boolean bl2 = false;
        if (this.theYear == -1) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        boolean bl4 = false;
        if (historicalTimeZoneDate.theYear == -1) {
            bl4 = bl = true;
        }
        if (!bl3 && !bl) {
            if (this.theYear != historicalTimeZoneDate.theYear) {
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterAbsolute instead");
            }
            if (s != this.theYear) {
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 absolute dates for a different year than their own");
            }
        } else if (bl3 && !bl ? s != historicalTimeZoneDate.theYear : !bl3 && bl && s != this.theYear) {
            throw new TimeZoneException("ERROR: occursOnForYear comparing absolute date for a different year than its own");
        }
        if (!bl3 || !bl) {
            return this.occursOnAbsolute(historicalTimeZoneDate);
        }
        if (this.theMonth.getMonthOfYear() != historicalTimeZoneDate.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay != historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.equivalent(historicalTimeZoneDate.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && historicalTimeZoneDate.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < historicalTimeZoneDate.theDay.calendarDay - 7) {
                return false;
            }
            if (this.theDay.calendarDay > historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
        }
        boolean bl5 = false;
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (historicalTimeZoneDate.theDay.dayExpressedAs == 0 && historicalTimeZoneDate.theDay.calendarDay != 0) {
            bl7 = true;
        }
        boolean bl8 = bl7;
        Calendar calendar2 = !bl6 ? this.toGregorianCalendar(s) : null;
        Calendar calendar3 = calendar = !bl8 ? historicalTimeZoneDate.toGregorianCalendar(s) : null;
        if (!bl6 && !bl8) {
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
            }
            return calendar2.equals(calendar);
        }
        if (!bl6) {
            if (calendar2.get(5) != historicalTimeZoneDate.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
            }
            boolean bl9 = false;
            if (calendar2.get(11) == historicalTimeZoneDate.theTimeOfDay.getHour() && calendar2.get(12) == historicalTimeZoneDate.theTimeOfDay.getMinute() && calendar2.get(13) == historicalTimeZoneDate.theTimeOfDay.getSecond() && calendar2.get(14) == historicalTimeZoneDate.theTimeOfDay.getMillisecond()) {
                bl9 = true;
            }
            return bl9;
        }
        if (this.theDay.calendarDay == calendar.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != historicalTimeZoneDate.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + historicalTimeZoneDate);
            throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
        }
        boolean bl10 = false;
        if (this.theTimeOfDay.getHour() == calendar.get(11) && this.theTimeOfDay.getMinute() == calendar.get(12) && this.theTimeOfDay.getSecond() == calendar.get(13) && this.theTimeOfDay.getMillisecond() == calendar.get(14)) {
            bl10 = true;
        }
        return bl10;
    }

    public final boolean occursAfterOrOnForYear(HistoricalTimeZoneDate historicalTimeZoneDate, short s) throws TimeZoneException {
        try {
            boolean bl = false;
            if (this.occursOnForYear(historicalTimeZoneDate, s) || this.occursAfterForYear(historicalTimeZoneDate, s)) {
                bl = true;
            }
            return bl;
        }
        catch (TimeZoneException timeZoneException) {
            if (timeZoneException.getMessage().startsWith("ERROR")) {
                throw timeZoneException;
            }
            throw new TimeZoneException("ERROR: occursAfterOrOnForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterOrOnAbsolute instead");
        }
    }

    public final boolean occursBeforeOrOnForYear(HistoricalTimeZoneDate historicalTimeZoneDate, short s) throws TimeZoneException {
        try {
            boolean bl = false;
            if (this.occursOnForYear(historicalTimeZoneDate, s) || this.occursBeforeForYear(historicalTimeZoneDate, s)) {
                bl = true;
            }
            return bl;
        }
        catch (TimeZoneException timeZoneException) {
            if (timeZoneException.getMessage().startsWith("ERROR")) {
                throw timeZoneException;
            }
            throw new TimeZoneException("ERROR: occursBeforeOrOnForYear comparing 2 absolute dates that don't fall on the same year, use OccursBeforeOrOnAbsolute instead");
        }
    }

    public final HistoricalTimeZoneDay getTheDay() {
        return this.theDay;
    }

    public final BMonth getTheMonth() {
        return this.theMonth;
    }

    public final short getTheTimeOfDayIsExpressedAs() {
        return this.theTimeOfDayIsExpressedIn;
    }

    public final BTime getTheTimeOfDay() {
        return this.theTimeOfDay;
    }

    public final short getTheYear() {
        return this.theYear;
    }

    private final void setTheYear(short s) {
        this.theYear = s;
    }

    public final HistoricalTimeZoneDate setTheTimeOfDayIsExpressedAs(short s) {
        this.theTimeOfDayIsExpressedIn = s;
        return this;
    }

    private HistoricalTimeZoneDate() {
    }

    public HistoricalTimeZoneDate(HistoricalTimeZoneDate historicalTimeZoneDate) {
        this.theYear = historicalTimeZoneDate.theYear;
        this.theMonth = BMonth.make(historicalTimeZoneDate.theMonth.getOrdinal());
        this.theDay = new HistoricalTimeZoneDay(historicalTimeZoneDate.getTheDay());
        this.theTimeOfDay = BTime.make(historicalTimeZoneDate.theTimeOfDay.getHour(), historicalTimeZoneDate.theTimeOfDay.getMinute(), historicalTimeZoneDate.theTimeOfDay.getSecond(), historicalTimeZoneDate.theTimeOfDay.getMillisecond());
        this.theTimeOfDayIsExpressedIn = historicalTimeZoneDate.theTimeOfDayIsExpressedIn;
    }

    public static final class HistoricalTimeZoneDay {
        public static final HistoricalTimeZoneDay FIRST_DAY_OF_YEAR = HistoricalTimeZoneDay.makeExactDay((short)1);
        public static final HistoricalTimeZoneDay LAST_DAY_OF_YEAR = HistoricalTimeZoneDay.makeExactDay((short)31);
        private short dayExpressedAs;
        private short calendarDay;
        private BWeekday dayOfWeek;

        public static final String encodePolicy(short s, short s2) {
            if (s == 2 && s2 != 0) {
                return "First";
            }
            if (s == 1 && s2 != 0) {
                return "First";
            }
            if (s == 0 && s2 != 0) {
                return "Exact";
            }
            if (s == 0) {
                return "First";
            }
            if (s == 1) {
                return "Second";
            }
            if (s == 2) {
                return "Third";
            }
            if (s == 3) {
                return "Fourth";
            }
            if (s == 4) {
                return "Fifth";
            }
            if (s == 5) {
                return "Last";
            }
            return "Undefined";
        }

        public static final String encodeDay(short s) {
            switch (s) {
                case 0: {
                    return "Sunday";
                }
                case 1: {
                    return "Monday";
                }
                case 2: {
                    return "Tuesday";
                }
                case 3: {
                    return "Wednesday";
                }
                case 4: {
                    return "Thursday";
                }
                case 5: {
                    return "Friday";
                }
                case 6: {
                    return "Saturday";
                }
            }
            return "Undefined";
        }

        public static final HistoricalTimeZoneDay decodeFromString(String string) {
            short s = 0;
            int n = 0;
            BWeekday bWeekday = BWeekday.sunday;
            if (string.length() <= 2) {
                return HistoricalTimeZoneDay.makeExactDay((short)Integer.parseInt(string));
            }
            short s2 = (short)string.indexOf("<=");
            if (s2 != -1) {
                String string2 = string.substring(s2 + 2, string.length());
                n = 2;
                s = (short)Integer.parseInt(string2);
            } else {
                s2 = (short)string.indexOf(">=");
                if (s2 != -1) {
                    String string3 = string.substring(s2 + 2, string.length());
                    n = 1;
                    s = (short)Integer.parseInt(string3);
                } else {
                    if (string.startsWith("first")) {
                        n = 0;
                    } else if (string.startsWith("second")) {
                        n = 1;
                    } else if (string.startsWith("third")) {
                        n = 2;
                    } else if (string.startsWith("fourth")) {
                        n = 3;
                    } else if (string.startsWith("fifth")) {
                        n = 4;
                    } else if (string.startsWith("last")) {
                        n = 5;
                    }
                    s = 0;
                }
            }
            if (string.indexOf("Sun") != -1) {
                bWeekday = BWeekday.sunday;
            } else if (string.indexOf("Mon") != -1) {
                bWeekday = BWeekday.monday;
            } else if (string.indexOf("Tue") != -1) {
                bWeekday = BWeekday.tuesday;
            } else if (string.indexOf("Wed") != -1) {
                bWeekday = BWeekday.wednesday;
            } else if (string.indexOf("Thu") != -1) {
                bWeekday = BWeekday.thursday;
            } else if (string.indexOf("Fri") != -1) {
                bWeekday = BWeekday.friday;
            } else if (string.indexOf("Sat") != -1) {
                bWeekday = BWeekday.saturday;
            }
            return HistoricalTimeZoneDay.make(s, (short)n, bWeekday);
        }

        public static final HistoricalTimeZoneDay make() {
            return HistoricalTimeZoneDay.makeExactDay((short)1);
        }

        public static final HistoricalTimeZoneDay make(short s, short s2, BWeekday bWeekday) {
            HistoricalTimeZoneDay historicalTimeZoneDay = new HistoricalTimeZoneDay();
            historicalTimeZoneDay.calendarDay = s;
            historicalTimeZoneDay.dayExpressedAs = s2;
            historicalTimeZoneDay.dayOfWeek = bWeekday;
            return historicalTimeZoneDay;
        }

        public final void update(short s, short s2, BWeekday bWeekday) {
            this.calendarDay = s;
            this.dayExpressedAs = s2;
            this.dayOfWeek = bWeekday;
        }

        public final void update(HistoricalTimeZoneDay historicalTimeZoneDay) {
            this.update(historicalTimeZoneDay.calendarDay, historicalTimeZoneDay.dayExpressedAs, historicalTimeZoneDay.dayOfWeek);
        }

        public static final HistoricalTimeZoneDay makeExactDay(short s) {
            return HistoricalTimeZoneDay.make(s, (short)0, BWeekday.sunday);
        }

        public static final HistoricalTimeZoneDay makeOnOrAfter(BWeekday bWeekday, short s) {
            return HistoricalTimeZoneDay.make(s, (short)1, bWeekday);
        }

        public static final HistoricalTimeZoneDay makeOnOrBefore(BWeekday bWeekday, short s) {
            return HistoricalTimeZoneDay.make(s, (short)2, bWeekday);
        }

        public static final HistoricalTimeZoneDay makeNthWeekday(short s, BWeekday bWeekday) {
            return HistoricalTimeZoneDay.make((short)0, s, bWeekday);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HistoricalTimeZoneDay)) {
                return false;
            }
            HistoricalTimeZoneDay historicalTimeZoneDay = (HistoricalTimeZoneDay)object;
            boolean bl = false;
            if (this.dayExpressedAs == historicalTimeZoneDay.dayExpressedAs && this.dayOfWeek == historicalTimeZoneDay.dayOfWeek && this.calendarDay == historicalTimeZoneDay.calendarDay) {
                bl = true;
            }
            return bl;
        }

        public final String toString() {
            if (this.dayExpressedAs == 0 && this.calendarDay != 0) {
                return new String("" + this.calendarDay);
            }
            if (this.dayExpressedAs == 2 && this.calendarDay != 0) {
                return new String(HistoricalTimeZoneDay.encodePolicy(this.dayExpressedAs, this.calendarDay) + ' ' + HistoricalTimeZoneDay.encodeDay((short)this.dayOfWeek.getOrdinal()) + " on or before " + this.calendarDay + " in");
            }
            if (this.dayExpressedAs == 1 && this.calendarDay != 0) {
                return new String(HistoricalTimeZoneDay.encodePolicy(this.dayExpressedAs, this.calendarDay) + ' ' + HistoricalTimeZoneDay.encodeDay((short)this.dayOfWeek.getOrdinal()) + " on or after " + this.calendarDay + " in");
            }
            if (this.dayExpressedAs == 0 || this.dayExpressedAs == 1 || this.dayExpressedAs == 2 || this.dayExpressedAs == 3 || this.dayExpressedAs == 4 || this.dayExpressedAs == 5) {
                return new String(HistoricalTimeZoneDay.encodePolicy(this.dayExpressedAs, this.calendarDay) + ' ' + HistoricalTimeZoneDay.encodeDay((short)this.dayOfWeek.getOrdinal()) + " in");
            }
            return "Invalid Policy";
        }

        public final short getCalendarDay() {
            return this.calendarDay;
        }

        public final short getDayExpressedAs() {
            return this.dayExpressedAs;
        }

        public final BWeekday getDayOfWeek() {
            return this.dayOfWeek;
        }

        static final /* synthetic */ BWeekday access$4(HistoricalTimeZoneDay historicalTimeZoneDay) {
            return historicalTimeZoneDay.dayOfWeek;
        }

        private HistoricalTimeZoneDay() {
        }

        public HistoricalTimeZoneDay(HistoricalTimeZoneDay historicalTimeZoneDay) {
            this.calendarDay = historicalTimeZoneDay.calendarDay;
            this.dayExpressedAs = historicalTimeZoneDay.dayExpressedAs;
            this.dayOfWeek = historicalTimeZoneDay.dayOfWeek != null ? BWeekday.make(historicalTimeZoneDay.dayOfWeek.getOrdinal()) : BWeekday.sunday;
        }
    }
}

