/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import com.tridium.timezone.HistoricalTimeZoneDate;

public final class HistoricalDstRule {
    private String ruleName;
    private String ruleType;
    private String ruleLetters;
    private int daylightAdjMillis;
    private boolean isStartRule;
    private HistoricalTimeZoneDate occursOnAnnualDate;
    private HistoricalTimeZoneDate validFromDate;
    private HistoricalTimeZoneDate validUntilDate;

    public static final HistoricalDstRule make() {
        return HistoricalDstRule.make("null", "-", "null", HistoricalTimeZoneDate.makeMinimumDate(), HistoricalTimeZoneDate.makeMinimumDate(), HistoricalTimeZoneDate.makeMinimumDate(), 0);
    }

    public static final HistoricalDstRule make(String string, String string2, String string3, HistoricalTimeZoneDate historicalTimeZoneDate, HistoricalTimeZoneDate historicalTimeZoneDate2, HistoricalTimeZoneDate historicalTimeZoneDate3, int n) {
        HistoricalDstRule historicalDstRule = new HistoricalDstRule();
        historicalDstRule.ruleName = string;
        historicalDstRule.ruleType = string3;
        historicalDstRule.ruleLetters = string2;
        historicalDstRule.validFromDate = historicalTimeZoneDate;
        historicalDstRule.validUntilDate = historicalTimeZoneDate2;
        historicalDstRule.occursOnAnnualDate = historicalTimeZoneDate3;
        historicalDstRule.daylightAdjMillis = n;
        boolean bl = false;
        if (historicalDstRule.daylightAdjMillis != 0) {
            bl = true;
        }
        historicalDstRule.isStartRule = bl;
        return historicalDstRule;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HistoricalDstRule)) {
            return false;
        }
        HistoricalDstRule historicalDstRule = (HistoricalDstRule)object;
        boolean bl = false;
        if (this.ruleName.equals(historicalDstRule.ruleName) && this.validFromDate.equals(historicalDstRule.validFromDate) && this.validUntilDate.equals(historicalDstRule.validUntilDate) && this.ruleType.equals(historicalDstRule.ruleType) && this.occursOnAnnualDate.equals(historicalDstRule.occursOnAnnualDate) && this.daylightAdjMillis == historicalDstRule.daylightAdjMillis && this.ruleLetters.equals(historicalDstRule.ruleLetters) && this.isStartRule == historicalDstRule.isStartRule) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        String string = this.isStartRule ? "DST starts on" : "DST ends on";
        return string + ' ' + this.occursOnAnnualDate.toString();
    }

    public final String toVerboseString() {
        return " From " + this.validFromDate.toString() + " until " + this.validUntilDate.toString() + " : Change " + this.occursOnAnnualDate.toString() + ' ' + this.daylightAdjMillis + ' ' + this.ruleLetters;
    }

    public final boolean ruleAppliesForInterval(HistoricalTimeZoneDate historicalTimeZoneDate, HistoricalTimeZoneDate historicalTimeZoneDate2) {
        if (this.validFromDate.getTheYear() == historicalTimeZoneDate.getTheYear() && this.validUntilDate.getTheYear() == historicalTimeZoneDate2.getTheYear()) {
            if (this.validUntilDate.getTheYear() - this.validFromDate.getTheYear() >= 2) {
                return true;
            }
            boolean bl = false;
            if (historicalTimeZoneDate.occursBeforeAbsolute(this.occursOnAnnualDate) && historicalTimeZoneDate2.occursAfterAbsolute(this.occursOnAnnualDate)) {
                bl = true;
            }
            return bl;
        }
        if (this.validFromDate.getTheYear() == historicalTimeZoneDate2.getTheYear()) {
            return historicalTimeZoneDate2.occursAfterAbsolute(this.occursOnAnnualDate);
        }
        if (this.validUntilDate.getTheYear() == historicalTimeZoneDate.getTheYear()) {
            return historicalTimeZoneDate.occursBeforeAbsolute(this.occursOnAnnualDate);
        }
        if (this.validUntilDate.occursBeforeAbsolute(historicalTimeZoneDate) || this.validFromDate.occursAfterAbsolute(historicalTimeZoneDate2)) {
            return false;
        }
        if (this.validFromDate.occursAfterOrOnAbsolute(historicalTimeZoneDate) && this.validUntilDate.occursBeforeOrOnAbsolute(historicalTimeZoneDate2)) {
            return true;
        }
        if (this.validFromDate.occursBeforeOrOnAbsolute(historicalTimeZoneDate) && this.validUntilDate.occursAfterOrOnAbsolute(historicalTimeZoneDate2)) {
            return true;
        }
        if (this.validFromDate.occursAfterAbsolute(historicalTimeZoneDate) && this.validFromDate.occursBeforeAbsolute(historicalTimeZoneDate2)) {
            return true;
        }
        return this.validUntilDate.occursAfterAbsolute(historicalTimeZoneDate) && this.validUntilDate.occursBeforeAbsolute(historicalTimeZoneDate2);
    }

    public final boolean ruleAppliesForYear(int n) {
        boolean bl = false;
        if (this.validFromDate.getTheYear() <= n && n <= this.validUntilDate.getTheYear()) {
            bl = true;
        }
        return bl;
    }

    public final HistoricalTimeZoneDate getOccursOnAnnualDate() {
        return this.occursOnAnnualDate;
    }

    public final String getRuleLetters() {
        return this.ruleLetters;
    }

    public final String getRuleName() {
        return this.ruleName;
    }

    public final String getRuleType() {
        return this.ruleType;
    }

    public final HistoricalTimeZoneDate getStartDate() {
        return this.validFromDate;
    }

    public final HistoricalTimeZoneDate getEndDate() {
        return this.validUntilDate;
    }

    public final int getDaylightAdjMillis() {
        return this.daylightAdjMillis;
    }

    public final boolean isStartRule() {
        return this.isStartRule;
    }

    public final boolean isEndRule() {
        return this.isStartRule ^ true;
    }

    private HistoricalDstRule() {
    }

    public HistoricalDstRule(HistoricalDstRule historicalDstRule) {
        this.ruleName = new String(historicalDstRule.ruleName);
        this.ruleLetters = new String(historicalDstRule.ruleLetters);
        this.ruleType = new String(historicalDstRule.ruleType);
        this.validFromDate = new HistoricalTimeZoneDate(historicalDstRule.validFromDate);
        this.validUntilDate = new HistoricalTimeZoneDate(historicalDstRule.validUntilDate);
        this.occursOnAnnualDate = new HistoricalTimeZoneDate(historicalDstRule.occursOnAnnualDate);
        this.daylightAdjMillis = historicalDstRule.daylightAdjMillis;
        this.isStartRule = historicalDstRule.isStartRule;
    }
}

