/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class CompTransferResult
extends TransferResult {
    public final int action;
    public final BComponent origParent;
    public final String[] origNames;
    public final BComponent target;
    public final String[] insertNames;

    public void undo() throws Exception {
        if (this.action == 16) {
            this.undoCopy();
        } else {
            this.undoMove();
        }
    }

    protected BComponent makeParams() {
        return new BVector();
    }

    private final void undoCopy() throws Exception {
        String[] stringArray = this.getInsertNames();
        Context context = Transaction.start(this.target, null);
        int n = 0;
        while (n < stringArray.length) {
            Property property = this.target.getProperty(stringArray[n]);
            this.target.remove(property, context);
            ++n;
        }
        Transaction.end(this.target, context);
    }

    public void undoMove() throws Exception {
        Mark mark = CompTransferResult.rebuildMark(this.target, this.insertNames, this.origNames);
        TransferStrategy transferStrategy = TransferStrategy.make(32, mark, this.origParent, this.makeParams(), null);
        transferStrategy.transfer();
    }

    static Mark rebuildMark(BComponent bComponent, String[] stringArray, String[] stringArray2) throws Exception {
        bComponent.loadSlots();
        BObject[] bObjectArray = new BObject[stringArray.length];
        int n = 0;
        while (n < bObjectArray.length) {
            bObjectArray[n] = bComponent.get(stringArray[n]);
            ++n;
        }
        return new Mark(bObjectArray, stringArray2);
    }

    public CompTransferResult(int n, BComponent bComponent, String[] stringArray, BComponent bComponent2, String[] stringArray2) {
        super(stringArray2);
        this.action = n;
        this.origParent = bComponent;
        this.origNames = stringArray;
        this.target = bComponent2;
        this.insertNames = stringArray2;
    }
}

