/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy.se;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public class JmxInfo
extends Spy {
    private final void row(SpyWriter spyWriter, String string, MemoryUsage memoryUsage) {
        spyWriter.w("<tr>");
        spyWriter.w("<td align='left' nowrap='true'>").w(string).w("</td>");
        spyWriter.w("<td align='right' nowrap='true'>").w(memoryUsage.getInit() / 1024L).w("</td>");
        spyWriter.w("<td align='right' nowrap='true'>").w(memoryUsage.getUsed() / 1024L).w("</td>");
        spyWriter.w("<td align='right' nowrap='true'>").w(memoryUsage.getCommitted() / 1024L).w("</td>");
        spyWriter.w("<td align='right' nowrap='true'>").w(memoryUsage.getMax() / 1024L).w("</td>");
        spyWriter.w("</tr>\n");
    }

    public void write(SpyWriter spyWriter) throws Exception {
        if (Integer.parseInt(String.valueOf(System.getProperty("java.version", "1.5").charAt(2))) < 8) {
            spyWriter.w("JMX Info Unavailable, VM version &lt; 1.8\n");
            return;
        }
        spyWriter.startProps("JMX Thread Info");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        spyWriter.prop((Object)"peak thread count", threadMXBean.getPeakThreadCount());
        spyWriter.prop((Object)"current thread count", threadMXBean.getThreadCount());
        spyWriter.prop((Object)"total started thread count", Long.toString(threadMXBean.getTotalStartedThreadCount()));
        spyWriter.endProps();
        spyWriter.startProps("JMX Class Loading Info");
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        spyWriter.prop((Object)"loaded class count", classLoadingMXBean.getLoadedClassCount());
        spyWriter.prop((Object)"total loaded class count", Long.toString(classLoadingMXBean.getTotalLoadedClassCount()));
        spyWriter.prop((Object)"unloaded class count", Long.toString(classLoadingMXBean.getUnloadedClassCount()));
        spyWriter.endProps();
        List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        int n = 0;
        while (n < list.size()) {
            try {
                MemoryPoolMXBean memoryPoolMXBean = list.get(n);
                MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                MemoryUsage memoryUsage2 = memoryPoolMXBean.getPeakUsage();
                spyWriter.startTable(true);
                spyWriter.trTitle(memoryPoolMXBean.getName() + " (KB)", 5);
                spyWriter.w("<tr>");
                spyWriter.thTitle("Type");
                spyWriter.thTitle("init");
                spyWriter.thTitle("used");
                spyWriter.thTitle("committed");
                spyWriter.thTitle("max");
                spyWriter.w("</tr>");
                this.row(spyWriter, "current", memoryUsage);
                this.row(spyWriter, "peak", memoryUsage2);
                spyWriter.endTable();
            }
            catch (Exception exception) {}
            ++n;
        }
    }
}

