/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.EnumIntrospector;
import com.tridium.sys.schema.EnumType;
import com.tridium.sys.schema.SyntheticEnumType;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SyntheticEnumIntrospector
extends EnumIntrospector {
    Type introspect() throws Exception {
        int n = this.cls.getModifiers();
        if (!Modifier.isFinal(n) && !Modifier.isAbstract(n)) {
            throw this.err("BFrozenEnum subclasses must be declared final or abstract");
        }
        this.mapEnums();
        int[] nArray = new int[this.count];
        System.arraycopy(this.ordinals, 0, nArray, 0, this.count);
        return new SyntheticEnumType(this, this.def, nArray, this.byOrdinal, this.byTag, this.cls);
    }

    protected void mapEnums() throws Exception {
        NModule nModule = Nre.moduleManager.getModuleForClass(this.cls);
        if (nModule.jarFile != null) {
            XElem[] xElemArray = nModule.jarFile.getJarEntry("META-INF/module.xml");
            if (xElemArray == null) {
                xElemArray = nModule.jarFile.getJarEntry("meta-inf/module.xml");
            }
            if (xElemArray == null) {
                throw new ModuleException("Module missing META-INF/module.xml: " + nModule.jarFile.getFile());
            }
            XElem xElem = XParser.make((InputStream)new BufferedInputStream(xElemArray.getInputStream())).parse();
            if (xElem.elem("types") != null) {
                xElemArray = xElem.elem("types").elems("type");
                int n = 0;
                while (n < xElemArray.length) {
                    XElem xElem2;
                    if (xElemArray[n].get("name").equals(this.typeName) && (xElem2 = xElemArray[n].elem("entries")) != null) {
                        XElem[] xElemArray2 = xElem2.elems("entry");
                        int n2 = 0;
                        while (n2 < xElemArray2.length) {
                            BFrozenEnum bFrozenEnum;
                            Object object;
                            String string = xElemArray2[n2].get("name");
                            int n3 = xElemArray2[n2].geti("ordinal");
                            this.ordinals[this.count++] = n3;
                            if (this.byOrdinal.get(n3) != null) {
                                throw this.err("Duplicate ordinal " + n3);
                            }
                            try {
                                object = this.cls.getConstructor(Integer.TYPE);
                                bFrozenEnum = (BFrozenEnum)((Constructor)object).newInstance(new Integer(n3));
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw new BajaRuntimeException("Missing enumeration constructor.", noSuchMethodException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new BajaRuntimeException("Unable to create enumeration instance.", invocationTargetException);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw new BajaRuntimeException("Unable to create enumeration instance.", illegalAccessException);
                            }
                            catch (InstantiationException instantiationException) {
                                throw new BajaRuntimeException("Unable to create enumeration instance.", instantiationException);
                            }
                            if (this.def == null) {
                                this.def = bFrozenEnum;
                            }
                            object = new EnumType.Entry(n3, string, bFrozenEnum);
                            this.byOrdinal.put(n3, object);
                            this.byTag.put(string, object);
                            ++n2;
                        }
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    public SyntheticEnumIntrospector(int n, Class clazz) {
        super(n, clazz);
    }
}

