/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.EnumType;
import com.tridium.sys.schema.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class EnumIntrospector
extends Introspector {
    BFrozenEnum def;
    IntHashMap byOrdinal;
    HashMap byTag;
    int[] ordinals;
    int count;

    Type introspect() throws Exception {
        int n = this.cls.getModifiers();
        if (this.cls.getName().equals("javax.baja.sys.BFrozenEnum") || Modifier.isAbstract(n)) {
            return new EnumType(this, null, null, null, null);
        }
        if (!Modifier.isFinal(n)) {
            throw this.err("BFrozenEnum's must be final classes");
        }
        this.mapEnums();
        int[] nArray = new int[this.count];
        System.arraycopy(this.ordinals, 0, nArray, 0, this.count);
        return new EnumType(this, this.def, nArray, this.byOrdinal, this.byTag);
    }

    protected void mapEnums() throws Exception {
        Field[] fieldArray = this.cls.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            int n2 = field.getModifiers();
            if (Modifier.isPublic(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2) && field.getType() == this.cls && !field.getName().equals("DEFAULT")) {
                this.mapEnum(field.getName(), (BFrozenEnum)field.get(null));
            }
            ++n;
        }
        if (this.byOrdinal.size() == 0) {
            throw this.err("Must declare at least one enum");
        }
    }

    private final void mapEnum(String string, BFrozenEnum bFrozenEnum) throws Exception {
        int n = bFrozenEnum.getOrdinal();
        this.ordinals[this.count++] = n;
        if (this.byOrdinal.get(n) != null) {
            throw this.err("Duplicate ordinal " + n);
        }
        if (this.def == null) {
            this.def = bFrozenEnum;
        }
        EnumType.Entry entry = new EnumType.Entry(n, string, bFrozenEnum);
        this.byOrdinal.put(n, (Object)entry);
        this.byTag.put(string, entry);
    }

    private final /* synthetic */ void this() {
        this.byOrdinal = new IntHashMap();
        this.byTag = new HashMap();
        this.ordinals = new int[1024];
    }

    EnumIntrospector(int n, Class clazz) {
        super(n, clazz);
        this.this();
    }
}

