/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.registry.RegistryException;

public class RegistryChecksum {
    public static final long magic = 7958534986241635693L;
    public static final int version = 3;
    HashMap modules;

    void checkUpToDate(File file) {
        String string = file.getName();
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - ".jar".length());
        } else if (string.endsWith(".sjar")) {
            string = string.substring(0, string.length() - ".sjar".length());
        } else {
            return;
        }
        ModuleSnapshot moduleSnapshot = (ModuleSnapshot)this.modules.get(string);
        if (moduleSnapshot == null) {
            throw new RegistryException("Module added \"" + string + '\"');
        }
        if (moduleSnapshot.size != file.length() || moduleSnapshot.timestamp != file.lastModified()) {
            throw new RegistryException("Module changed \"" + string + '\"');
        }
        this.modules.remove(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void read(File file) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            if (dataInputStream.readLong() != 7958534986241635693L) {
                throw new IOException("Invalid magic");
            }
            if (dataInputStream.readInt() != 3) {
                throw new IOException("Invalid version");
            }
            int n = dataInputStream.readInt();
            this.modules = new HashMap(n * 3);
            int n2 = 0;
            while (n2 < n) {
                ModuleSnapshot moduleSnapshot = new ModuleSnapshot();
                moduleSnapshot.name = dataInputStream.readUTF();
                moduleSnapshot.timestamp = dataInputStream.readLong();
                moduleSnapshot.size = dataInputStream.readLong();
                this.modules.put(moduleSnapshot.name, moduleSnapshot);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            dataInputStream.close();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        dataInputStream.close();
    }

    void write(File file) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        dataOutputStream.writeLong(7958534986241635693L);
        dataOutputStream.writeInt(3);
        int n = this.modules.size();
        dataOutputStream.writeInt(n);
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            ModuleSnapshot moduleSnapshot = (ModuleSnapshot)iterator.next();
            dataOutputStream.writeUTF(moduleSnapshot.name);
            dataOutputStream.writeLong(moduleSnapshot.timestamp);
            dataOutputStream.writeLong(moduleSnapshot.size);
        }
        dataOutputStream.close();
    }

    static class ModuleSnapshot {
        String name;
        long timestamp;
        long size;

        ModuleSnapshot() {
        }
    }
}

