/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.registry.NAgentInfo;
import com.tridium.sys.registry.NAgentList;
import com.tridium.sys.registry.RegistryDatabase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Modifier;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NTypeInfo
implements TypeInfo {
    static final NTypeInfo[] noTypes = new NTypeInfo[0];
    int id;
    BTypeSpec typeSpec;
    int modifiers;
    String className;
    boolean isTransientType;
    NAgentInfo agentInfo;
    NTypeInfo superType;
    NTypeInfo[] interfaces;
    NTypeInfo[] agents;
    NTypeInfo[] is;
    NTypeInfo[] agentOn;
    Lexicon lexicon;
    String friendlyTypeName;

    public final String getModuleName() {
        return this.typeSpec.getModuleName();
    }

    public final String getTypeName() {
        return this.typeSpec.getTypeName();
    }

    public final BTypeSpec getTypeSpec() {
        return this.typeSpec;
    }

    public final BObject getInstance() {
        return this.typeSpec.getInstance();
    }

    public final TypeInfo getSuperType() {
        return this.superType;
    }

    public final TypeInfo[] getInterfaces() {
        return (TypeInfo[])this.interfaces.clone();
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public final boolean isTransient() {
        return this.isTransientType;
    }

    public final String getTypeClassName() {
        return this.className;
    }

    public final AgentInfo getAgentInfo() {
        if (this.agentInfo == null) {
            if (this.is(BIAgent.TYPE)) {
                this.agentInfo = new NAgentInfo(this);
            } else {
                throw new RegistryException("Type \"" + this + "\" is not baja:Agent");
            }
        }
        return this.agentInfo;
    }

    public final AgentList getAgents() {
        NAgentList nAgentList = new NAgentList();
        int n = this.is.length - 1;
        while (n >= 0) {
            NTypeInfo nTypeInfo = this.is[n];
            NTypeInfo[] nTypeInfoArray = nTypeInfo.agents;
            int n2 = 0;
            while (n2 < nTypeInfoArray.length) {
                nAgentList.add(nTypeInfoArray[n2].getAgentInfo());
                ++n2;
            }
            --n;
        }
        return nAgentList;
    }

    public final boolean is(TypeInfo typeInfo) {
        int n = this.is.length;
        int n2 = 0;
        while (n2 < n) {
            if (typeInfo == this.is[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final boolean is(Type type) {
        return this.is(type.getTypeInfo());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        return this.typeSpec.toString(null);
    }

    public Lexicon getLexicon(Context context) {
        if (context == null) {
            if (this.lexicon == null || !this.lexicon.language.equals(Sys.getLanguage())) {
                this.lexicon = Lexicon.make(this.getModuleName());
            }
            return this.lexicon;
        }
        return Lexicon.make(this.getModuleName(), context);
    }

    public String getDisplayName(Context context) {
        String string = this.getLexicon(context).get(this.getTypeName() + ".displayName");
        if (string != null) {
            return string;
        }
        if (this.friendlyTypeName == null) {
            this.friendlyTypeName = TextUtil.toFriendly((String)this.getTypeName());
        }
        return this.friendlyTypeName;
    }

    public BIcon getIcon(Context context) {
        String string = this.getLexicon(context).get(this.getTypeName() + ".icon");
        if (string != null) {
            return BIcon.make(string);
        }
        TypeInfo typeInfo = this.getSuperType();
        if (typeInfo != null) {
            return typeInfo.getIcon(context);
        }
        return null;
    }

    void read(RegistryDatabase registryDatabase, DataInputStream dataInputStream) throws Exception {
        this.typeSpec = BTypeSpec.make(dataInputStream.readUTF());
        this.modifiers = dataInputStream.readUnsignedShort();
        this.className = dataInputStream.readUTF();
        this.superType = NTypeInfo.readType(registryDatabase, dataInputStream);
        this.interfaces = NTypeInfo.readTypes(registryDatabase, dataInputStream);
        this.agents = NTypeInfo.readTypes(registryDatabase, dataInputStream);
        this.is = NTypeInfo.readTypes(registryDatabase, dataInputStream);
        if (dataInputStream.readBoolean()) {
            this.agentInfo = new NAgentInfo(this);
            this.agentInfo.read(registryDatabase, dataInputStream);
        }
    }

    void write(RegistryDatabase registryDatabase, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeUTF(this.typeSpec.encodeToString());
        dataOutputStream.writeShort(this.modifiers);
        dataOutputStream.writeUTF(this.className);
        NTypeInfo.writeType(registryDatabase, dataOutputStream, this.superType);
        NTypeInfo.writeTypes(registryDatabase, dataOutputStream, this.interfaces);
        NTypeInfo.writeTypes(registryDatabase, dataOutputStream, this.agents);
        NTypeInfo.writeTypes(registryDatabase, dataOutputStream, this.is);
        if (this.agentInfo == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            this.agentInfo.write(registryDatabase, dataOutputStream);
        }
    }

    static NTypeInfo readType(RegistryDatabase registryDatabase, DataInputStream dataInputStream) throws Exception {
        short s = dataInputStream.readShort();
        if (s < 0) {
            return null;
        }
        return registryDatabase.types[s];
    }

    static void writeType(RegistryDatabase registryDatabase, DataOutputStream dataOutputStream, NTypeInfo nTypeInfo) throws Exception {
        if (nTypeInfo == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(nTypeInfo.id);
        }
    }

    static NTypeInfo[] readTypes(RegistryDatabase registryDatabase, DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readUnsignedShort();
        if (n == 0) {
            return noTypes;
        }
        NTypeInfo[] nTypeInfoArray = new NTypeInfo[n];
        int n2 = 0;
        while (n2 < n) {
            nTypeInfoArray[n2] = registryDatabase.types[dataInputStream.readShort()];
            ++n2;
        }
        return nTypeInfoArray;
    }

    static void writeTypes(RegistryDatabase registryDatabase, DataOutputStream dataOutputStream, NTypeInfo[] nTypeInfoArray) throws Exception {
        int n = nTypeInfoArray.length;
        dataOutputStream.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeShort(nTypeInfoArray[n2].id);
            ++n2;
        }
    }

    static void writeAgentTypes(RegistryDatabase registryDatabase, DataOutputStream dataOutputStream, NAgentInfo[] nAgentInfoArray) throws Exception {
        int n = nAgentInfoArray.length;
        dataOutputStream.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeShort(nAgentInfoArray[n2].typeInfo.id);
            dataOutputStream.writeShort(nAgentInfoArray[n2].defaultPreferrence);
            ++n2;
        }
    }

    private final /* synthetic */ void this() {
        this.modifiers = 0;
        this.className = null;
        this.isTransientType = false;
        this.agentInfo = null;
        this.superType = null;
        this.interfaces = noTypes;
        this.agents = noTypes;
        this.is = noTypes;
        this.agentOn = noTypes;
    }

    public NTypeInfo(int n, BTypeSpec bTypeSpec) {
        this.this();
        this.id = n;
        this.typeSpec = bTypeSpec;
    }
}

