/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.registry.NDependencyInfo;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.sys.registry.RegistryDatabase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NModuleInfo
implements ModuleInfo {
    int id;
    String moduleName;
    Version bajaVersion;
    String vendor;
    Version vendorVersion;
    boolean isTransientModule;
    boolean isAutoloadModule;
    boolean isReloadableModule;
    String description;
    String moduleContent;
    NTypeInfo[] types;
    DependencyInfo[] depends;
    boolean hasPalette;
    long buildTime;

    public String getModuleName() {
        return this.moduleName;
    }

    public Version getBajaVersion() {
        return this.bajaVersion;
    }

    public String getVendor() {
        return this.vendor;
    }

    public Version getVendorVersion() {
        return this.vendorVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public TypeInfo[] getTypes() {
        return (TypeInfo[])this.types.clone();
    }

    public DependencyInfo[] getDependencies() {
        if (this.depends == null) {
            this.depends = NDependencyInfo.load(this.moduleName);
        }
        return this.depends;
    }

    public boolean isTransient() {
        return this.isTransientModule;
    }

    public boolean isAutoload() {
        return this.isAutoloadModule;
    }

    public boolean isReloadable() {
        return this.isReloadableModule;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public boolean hasPalette() {
        return this.hasPalette;
    }

    public String getModuleContent() {
        return this.moduleContent;
    }

    void read(RegistryDatabase registryDatabase, DataInputStream dataInputStream) throws Exception {
        this.moduleName = dataInputStream.readUTF();
        this.bajaVersion = new Version(dataInputStream.readUTF());
        this.vendor = dataInputStream.readUTF();
        this.vendorVersion = new Version(dataInputStream.readUTF());
        this.description = dataInputStream.readUTF();
        this.hasPalette = dataInputStream.readBoolean();
        this.buildTime = dataInputStream.readLong();
        this.types = NTypeInfo.readTypes(registryDatabase, dataInputStream);
        this.moduleContent = dataInputStream.readUTF();
        try {
            this.isAutoloadModule = dataInputStream.readBoolean();
            this.isReloadableModule = dataInputStream.readBoolean();
        }
        catch (Exception exception) {}
    }

    void write(RegistryDatabase registryDatabase, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeUTF(this.moduleName);
        dataOutputStream.writeUTF(this.bajaVersion.toString());
        dataOutputStream.writeUTF(this.vendor);
        dataOutputStream.writeUTF(this.vendorVersion.toString());
        dataOutputStream.writeUTF(this.description);
        dataOutputStream.writeBoolean(this.hasPalette);
        dataOutputStream.writeLong(this.buildTime);
        NTypeInfo.writeTypes(registryDatabase, dataOutputStream, this.types);
        dataOutputStream.writeUTF(this.moduleContent);
        dataOutputStream.writeBoolean(this.isAutoloadModule);
        dataOutputStream.writeBoolean(this.isReloadableModule);
    }

    public String toString() {
        return "NModuleInfo (" + this.moduleName + ')';
    }

    private final /* synthetic */ void this() {
        this.isTransientModule = false;
        this.isAutoloadModule = true;
        this.isReloadableModule = false;
        this.moduleContent = "doc";
        this.types = NTypeInfo.noTypes;
        this.depends = null;
        this.hasPalette = false;
    }

    protected NModuleInfo(int n) {
        this.this();
        this.id = n;
    }
}

