/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.io.ByteBuffer;

public class ClassScanner {
    private static final String[] noInterfaces = new String[0];
    public int modifiers;
    public String thisClass;
    public String superClass;
    public String[] interfaces;
    public boolean hasLoadType;
    private int[] cpClass;
    private byte[][] cpUtf;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scan(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        try {
            int n;
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readUnsignedShort();
            int n4 = dataInputStream.readUnsignedShort();
            int n5 = dataInputStream.readUnsignedShort();
            if (n2 != -889275714) {
                throw new IOException("Invalid magic");
            }
            this.cpClass = new int[n5];
            this.cpUtf = new byte[n5][];
            int n6 = 1;
            while (n6 < n5) {
                n = this.readCpInfo(dataInputStream, n6);
                if (n != 0) {
                    ++n6;
                }
                ++n6;
            }
            this.modifiers = dataInputStream.readUnsignedShort();
            this.thisClass = this.toClass(dataInputStream.readUnsignedShort());
            this.superClass = this.toClass(dataInputStream.readUnsignedShort());
            n6 = dataInputStream.readUnsignedShort();
            if (n6 == 0) {
                this.interfaces = noInterfaces;
            } else {
                this.interfaces = new String[n6];
                n = 0;
                while (n < n6) {
                    this.interfaces[n] = this.toClass(dataInputStream.readUnsignedShort());
                    ++n;
                }
            }
            Object var4_11 = null;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            dataInputStream.close();
            throw throwable;
        }
        dataInputStream.close();
    }

    private final boolean readCpInfo(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = dataInputStream.readUnsignedByte();
        switch (n2) {
            case 1: {
                int n3 = dataInputStream.readUnsignedShort();
                byte[] byArray = new byte[n3];
                dataInputStream.readFully(byArray, 0, n3);
                this.cpUtf[n] = byArray;
                this.checkLoadType(byArray);
                return false;
            }
            case 3: {
                ClassScanner.skip(dataInputStream, 4);
                return false;
            }
            case 4: {
                ClassScanner.skip(dataInputStream, 4);
                return false;
            }
            case 5: {
                ClassScanner.skip(dataInputStream, 8);
                return true;
            }
            case 6: {
                ClassScanner.skip(dataInputStream, 8);
                return true;
            }
            case 7: {
                this.cpClass[n] = dataInputStream.readUnsignedShort();
                return false;
            }
            case 8: {
                ClassScanner.skip(dataInputStream, 2);
                return false;
            }
            case 9: {
                ClassScanner.skip(dataInputStream, 4);
                return false;
            }
            case 10: {
                ClassScanner.skip(dataInputStream, 4);
                return false;
            }
            case 11: {
                ClassScanner.skip(dataInputStream, 4);
                return false;
            }
            case 12: {
                ClassScanner.skip(dataInputStream, 4);
                return false;
            }
        }
        throw new IOException("Invalid cp tag 0x" + Integer.toHexString(n2));
    }

    private final String toClass(int n) throws IOException {
        byte[] byArray = this.cpUtf[this.cpClass[n]];
        ByteBuffer byteBuffer = new ByteBuffer(byArray.length + 4);
        byteBuffer.writeShort(byArray.length);
        byteBuffer.write(byArray, 0, byArray.length);
        return byteBuffer.readUTF().replace('/', '.');
    }

    private final void checkLoadType(byte[] byArray) {
        if (this.hasLoadType) {
            return;
        }
        if (byArray.length != "loadType".length()) {
            return;
        }
        boolean bl = false;
        if (byArray[0] == 108 && byArray[1] == 111 && byArray[2] == 97 && byArray[3] == 100 && byArray[4] == 84 && byArray[5] == 121 && byArray[6] == 112 && byArray[7] == 101) {
            bl = true;
        }
        this.hasLoadType = bl;
    }

    private static final void skip(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            if (n2 < 0) {
                throw new EOFException();
            }
            n2 = (int)((long)n2 + inputStream.skip(n - n2));
        }
    }
}

