/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.sys.Nre;
import com.tridium.sys.module.Dependency;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.ModuleExtJar;
import com.tridium.sys.module.ModuleManager;
import com.tridium.util.jar.JarFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleIncompatibleException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NModule {
    protected String name;
    protected Version bajaVersion;
    protected Version vendorVersion;
    protected String description;
    protected String vendor;
    protected String preferredSymbol;
    boolean isSystemJar;
    public JarFile jarFile;
    protected Dependency[] depends;
    protected ModuleClassLoader classLoader;
    String[] typeList;
    protected Map types;
    protected Map packages;
    ModuleExtJar[] extJars;
    protected Object bmodule;
    Lexicon lexicon;
    HashMap lexicons;

    void init() {
        this.bmodule = new BModule(this);
    }

    public String getModuleName() {
        return this.name;
    }

    public String getPreferredSymbol() {
        return this.preferredSymbol;
    }

    public Version getBajaVersion() {
        return this.bajaVersion;
    }

    public String getVendor() {
        return this.vendor;
    }

    public Version getVendorVersion() {
        return this.vendorVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public BModule bmodule() {
        return (BModule)this.bmodule;
    }

    public void checkBajaVersion(Version version) throws ModuleIncompatibleException {
        if (version != null && version.compareTo(this.getBajaVersion()) > 0) {
            throw new ModuleIncompatibleException(this.getModuleName() + '-' + version);
        }
    }

    public void checkVendor(String string, Version version) throws ModuleIncompatibleException {
        if (string != null && !string.equalsIgnoreCase(this.getVendor()) || version != null && version.compareTo(this.getVendorVersion()) > 0) {
            throw new ModuleIncompatibleException(this.getModuleName() + '-' + string + '-' + version);
        }
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.isSystemJar) {
            return Class.forName(string);
        }
        return Class.forName(string, true, this.classLoader);
    }

    public URL getResource(String string) {
        if (this.isSystemJar) {
            return ClassLoader.getSystemResource(string);
        }
        return this.classLoader.getResource(string);
    }

    public ModuleClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String[] getTypeList() {
        if (this.typeList == null) {
            this.typeList = this.types.keySet().toArray(new String[this.types.size()]);
            SortUtil.sort((Object[])this.typeList);
        }
        String[] stringArray = new String[this.typeList.length];
        System.arraycopy(this.typeList, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public Type getType(String string) throws TypeException {
        Object v = this.types.get(string);
        if (v == null) {
            throw new TypeNotFoundException(this.name + ':' + string);
        }
        if (v instanceof Type) {
            return (Type)v;
        }
        String string2 = (String)v;
        try {
            Class clazz = this.loadClass(string2);
            v = this.types.get(string);
            if (v == null || !(v instanceof Type)) {
                throw new TypeException("Class loaded, but didn't register a type " + this.name + ':' + string + '=' + string2);
            }
            return (Type)v;
        }
        catch (TypeException typeException) {
            throw typeException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeException("Class not found for type " + this.name + ':' + string + '=' + string2);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            Throwable throwable = exceptionInInitializerError.getException();
            if (throwable == null) {
                throwable = exceptionInInitializerError;
            }
            throw new TypeException(exceptionInInitializerError.toString() + ' ' + this.name + ':' + string + '=' + string2, throwable);
        }
        catch (Throwable throwable) {
            throw new TypeException(throwable.toString() + ' ' + this.name + ':' + string + '=' + string2, throwable);
        }
    }

    public void register(String string, Type type) {
        this.types.put(string, type);
    }

    public void register(String string, String string2) {
        this.types.put(string, string2);
    }

    public ZipFile getZipFile() {
        if (this.jarFile instanceof JarFile) {
            return this.jarFile.zip;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Lexicon getLexicon(String string) {
        HashMap hashMap = this.lexicons;
        synchronized (hashMap) {
            Lexicon lexicon = (Lexicon)this.lexicons.get(string);
            if (lexicon == null) {
                lexicon = Lexicon.make(this.bmodule(), string);
                this.lexicons.put(string, lexicon);
            }
            return lexicon;
        }
    }

    public final Lexicon getLexicon() {
        if (this.lexicon == null || !this.lexicon.language.equals(Sys.getLanguage())) {
            this.lexicon = this.getLexicon(Sys.getLanguage());
        }
        return this.lexicon;
    }

    public File getFile() {
        return this.jarFile.getFile();
    }

    public String getTypeClassName(String string) {
        Object v = this.types.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return ((Type)v).getTypeClass().getName();
    }

    public boolean isSystemJar() {
        return this.isSystemJar;
    }

    public String toString() {
        return this.name + '-' + this.vendor + '-' + this.vendorVersion;
    }

    public void loadAllTypes() {
        String[] stringArray = this.getTypeList();
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.getType(stringArray[n]);
            }
            catch (TypeException typeException) {
                ModuleManager.log.error("Cannot load type", typeException);
            }
            ++n;
        }
    }

    public boolean isSynthetic() {
        if (this.getZipFile() == null) {
            return true;
        }
        return this.getZipFile().getName().endsWith(".sjar");
    }

    public boolean isTransient() {
        boolean bl = false;
        if (this.getZipFile() == null) {
            bl = true;
        }
        return bl;
    }

    public boolean containsPackage(String string) {
        return this.packages.containsKey(string);
    }

    void readXml(XElem xElem) throws IOException {
        this.readAttributes(xElem);
        this.readDependencies(xElem);
        this.readTypes(xElem);
        this.readExts(xElem);
        this.__postReadXml(xElem);
    }

    private final void readAttributes(XElem xElem) throws IOException {
        this.name = xElem.get("name");
        this.bajaVersion = new Version(xElem.get("bajaVersion"));
        this.vendorVersion = new Version(xElem.get("vendorVersion"));
        this.description = xElem.get("description");
        this.vendor = xElem.get("vendor");
        this.preferredSymbol = xElem.get("preferredSymbol");
    }

    private final void readDependencies(XElem xElem) throws IOException {
        XElem xElem2 = xElem.elem("dependencies");
        if (xElem2 == null) {
            return;
        }
        XElem[] xElemArray = xElem2.elems("dependency");
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>(xElemArray.length);
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem3 = xElemArray[n];
            String string = xElem3.get("name");
            String string2 = xElem3.get("bajaVersion", null);
            String string3 = xElem3.get("vendor", null);
            String string4 = xElem3.get("vendorVersion", null);
            Version version = string2 == null ? null : new Version(string2);
            Version version2 = string4 == null ? null : new Version(string4);
            arrayList.add(new Dependency(string, version, string3, version2));
            ++n;
        }
        this.depends = arrayList.toArray(new Dependency[arrayList.size()]);
    }

    private final void readTypes(XElem xElem) throws IOException {
        XElem xElem2 = xElem.elem("types");
        if (xElem2 == null) {
            return;
        }
        XElem[] xElemArray = xElem2.elems("type");
        int n = 0;
        while (n < xElemArray.length) {
            String string;
            XElem xElem3 = xElemArray[n];
            String string2 = xElem3.get("name");
            String string3 = xElem3.get("class");
            this.types.put(string2, string3);
            int n2 = string3.lastIndexOf(46);
            String string4 = string = n2 == -1 ? "" : string3.substring(0, n2);
            if (!this.packages.containsKey(string)) {
                this.packages.put(string, string);
            }
            ++n;
        }
    }

    private final void readExts(XElem xElem) throws IOException {
        XElem xElem2 = xElem.elem("extFiles");
        if (xElem2 == null) {
            return;
        }
        XElem[] xElemArray = xElem2.elems("extFile");
        this.extJars = new ModuleExtJar[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            this.extJars[n] = new ModuleExtJar(xElemArray[n]);
            ++n;
        }
    }

    private final void __postReadXml(XElem xElem) {
        String[] stringArray = Nre.registryManager.getInvalidModules();
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.name.equals(stringArray[n2])) {
                this.types.clear();
                this.types = Collections.unmodifiableMap(this.types);
                this.typeList = null;
                throw new ModuleException("Unsupported " + this.name + " module");
            }
            ++n2;
        }
    }

    private final /* synthetic */ void this() {
        this.bajaVersion = Version.ZERO;
        this.vendorVersion = Version.ZERO;
        this.types = new HashMap(63);
        this.packages = new HashMap(10);
        this.lexicons = new HashMap();
    }

    public NModule() {
        this.this();
    }
}

