/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.ModuleExtJar;
import com.tridium.sys.module.NModule;
import com.tridium.util.jar.JarEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModuleExtClassLoader
extends SecureClassLoader {
    static final Object NOT_FOUND = new Object();
    static final Log log = Log.getLog("loader");
    protected ModuleExtJar extJar;
    private Hashtable cache;
    private CodeSource codeSource;

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.nload(string, bl);
        if (clazz == null) {
            String string2 = string;
            if (this.module() != null) {
                string2 = this.module().name + ':' + string;
            }
            throw new ClassNotFoundException(string2);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class nload(String string, boolean bl) {
        Object object = ModuleClassLoader.getLoadClassLock(this.moduleClassLoader(), string);
        if (ModuleClassLoader.legacyExtClassLoader) {
            object = ModuleClassLoader.getLoadClassLock(this, string);
        }
        Object object2 = object;
        synchronized (object2) {
            Object v = this.cache.get(string);
            if (v == NOT_FOUND) {
                return null;
            }
            Class clazz = (Class)v;
            if (clazz == null) {
                clazz = this.nfind(string, bl, true);
                if (log.isTraceOn()) {
                    String string2 = "NOT FOUND";
                    if (clazz != null) {
                        BModule bModule = Sys.getModuleForClass(clazz);
                        string2 = bModule != null ? bModule.getModuleName() : "{system}";
                    }
                    log.trace(this.module().name + ':' + string + " -> " + string2);
                }
                if (clazz == null) {
                    this.cache.put(string, NOT_FOUND);
                    return null;
                }
                this.cache.put(string, clazz);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    public URL getResource(String string) {
        URL uRL = this.getResourceImpl(string);
        if (uRL != null) {
            return uRL;
        }
        return ModuleExtClassLoader.getSystemResource(string);
    }

    URL getResourceImpl(String string) {
        JarEntry jarEntry = this.module().jarFile.getJarEntry(this.extJar.getEntryPath(string));
        if (jarEntry != null) {
            return jarEntry.getURL();
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL != null) {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                return uRLConnection.getInputStream();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected Enumeration findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        URL uRL = this.getResourceImpl(string);
        if (uRL != null) {
            vector.add(uRL);
        }
        return vector.elements();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.moduleClassLoader().getPermissions(codeSource);
    }

    Class nfind(String string, boolean bl, boolean bl2) {
        Object object;
        if (bl2 && (object = this.moduleClassLoader().nload(string, bl)) != null) {
            return object;
        }
        object = this.extJar.getEntryPath(string.replace('.', '/') + ".class");
        JarEntry jarEntry = this.module().jarFile.getJarEntry((String)object);
        if (jarEntry != null) {
            byte[] byArray = null;
            try {
                int n = (int)jarEntry.getSize();
                InputStream inputStream = jarEntry.getInputStream();
                byArray = new byte[n];
                int n2 = 0;
                while (n2 < n) {
                    int n3 = inputStream.read(byArray, n2, n - n2);
                    if (n3 < 0) {
                        throw new IOException("Unexpected EOF");
                    }
                    n2 += n3;
                }
                inputStream.close();
                if (ModuleClassLoader.legacyExtClassLoader) {
                    return this.defineClass(string, byArray, 0, byArray.length, this.codeSource);
                }
                return this.moduleClassLoader().defineExtClass(string, byArray, 0, byArray.length, this.codeSource);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected ClassLoader topClassLoader() {
        return this.getParent().getParent();
    }

    protected ModuleClassLoader moduleClassLoader() {
        return (ModuleClassLoader)this.getParent();
    }

    protected NModule module() {
        return this.moduleClassLoader().module;
    }

    private final /* synthetic */ void this() {
        this.cache = new Hashtable();
    }

    ModuleExtClassLoader(ModuleClassLoader moduleClassLoader, ModuleExtJar moduleExtJar, CodeSource codeSource) {
        super(moduleClassLoader);
        this.this();
        this.extJar = moduleExtJar;
        this.codeSource = codeSource;
    }
}

