/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.LicenseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.file.BIFile;
import javax.baja.sys.Clock;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VendorCertificate {
    private String source;
    private XElem xml;
    private String signature;
    private boolean modified;

    public static VendorCertificate make(BIFile bIFile) throws Exception {
        VendorCertificate vendorCertificate = new VendorCertificate();
        vendorCertificate.load(bIFile);
        return vendorCertificate;
    }

    public static VendorCertificate make(String string, InputStream inputStream) throws Exception {
        VendorCertificate vendorCertificate = new VendorCertificate();
        vendorCertificate.load(string, inputStream);
        return vendorCertificate;
    }

    public static VendorCertificate make(String string, InputStream inputStream, boolean bl) throws Exception {
        VendorCertificate vendorCertificate = new VendorCertificate();
        vendorCertificate.load(string, inputStream, bl);
        return vendorCertificate;
    }

    public static VendorCertificate make(String string, XElem xElem) throws Exception {
        VendorCertificate vendorCertificate = new VendorCertificate();
        vendorCertificate.load(string, xElem);
        return vendorCertificate;
    }

    public String getSource() {
        return this.source;
    }

    public String getVendor() {
        return this.xml.get("vendor");
    }

    public void setVendor(String string) {
        this.modify();
        this.xml.setAttr("vendor", string);
    }

    public boolean isExpired() {
        boolean bl = false;
        if (Clock.millis() > this.getExpiration()) {
            bl = true;
        }
        return bl;
    }

    public long getExpiration() {
        return LicenseUtil.parseDate(this.xml.get("expiration"));
    }

    public void setExpiration(long l) {
        this.modify();
        this.xml.setAttr("expiration", LicenseUtil.formatDate(l));
    }

    public long getGenerated() {
        return LicenseUtil.parseDate(this.xml.get("generated"));
    }

    public Version getVersion() {
        return new Version(this.xml.get("version"));
    }

    public void setVersion(Version version) {
        this.modify();
        this.xml.setAttr("version", version.toString());
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String string) {
        this.modify();
        this.signature = string;
    }

    public String getPublicKey() {
        XElem xElem = this.xml.elem("publicKey");
        return xElem == null ? null : xElem.string();
    }

    public void setPublicKey(String string) {
        this.modify();
        XElem xElem = this.xml.elem("publicKey");
        if (xElem != null) {
            this.xml.removeContent((XContent)xElem);
        }
        xElem = new XElem("publicKey");
        xElem.addContent((XContent)new XText(string));
        this.xml.addContent((XContent)xElem);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(BIFile bIFile) throws Exception {
        InputStream inputStream = bIFile.getInputStream();
        try {
            this.load(bIFile.toString(), XParser.make((InputStream)inputStream).parse());
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        inputStream.close();
    }

    public void load(String string, InputStream inputStream) throws Exception {
        this.load(string, inputStream, true);
    }

    public void load(String string, InputStream inputStream, boolean bl) throws Exception {
        this.load(string, XParser.make((InputStream)inputStream).parse(bl));
    }

    public void load(String string, XElem xElem) throws Exception {
        this.source = string == null ? string : "Unknown";
        this.parse(xElem);
    }

    private final void parse(XElem xElem) throws Exception {
        XElem xElem2;
        XElem xElem3;
        if (!xElem.qname().equals("certificate")) {
            throw new XException("Root element must be <certificate> element", xElem);
        }
        this.modified = false;
        this.xml = new XElem("certificate");
        int n = 0;
        while (n < xElem.attrSize()) {
            this.xml.addAttr(xElem.attrName(n), xElem.attrValue(n));
            ++n;
        }
        if (xElem.get("generated", null) == null) {
            this.xml.addAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        }
        if ((xElem3 = xElem.elem("signature")) != null) {
            this.signature = xElem3.string();
        }
        if ((xElem2 = xElem.elem("publicKey")) != null) {
            this.xml.addContent((XContent)xElem2.copy());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(BIFile bIFile) throws IOException {
        OutputStream outputStream = bIFile.getOutputStream();
        try {
            VendorCertificate.format(this.save(), new XWriter(outputStream));
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        outputStream.close();
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, true);
    }

    public void save(OutputStream outputStream, boolean bl) throws IOException {
        XWriter xWriter = new XWriter(outputStream);
        this.save(xWriter);
        xWriter.flush();
        if (bl) {
            xWriter.close();
        }
    }

    public void save(XWriter xWriter) throws IOException {
        VendorCertificate.format(this.save(), xWriter);
    }

    public XElem save() {
        if (this.modified) {
            this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
            this.modified = false;
        }
        XElem xElem = this.xml.copy();
        if (this.signature != null) {
            XElem xElem2 = new XElem("signature");
            xElem2.addContent((XContent)new XText(this.signature));
            xElem.addContent((XContent)xElem2);
        }
        return xElem;
    }

    public static void format(XElem xElem, XWriter xWriter) {
        VendorCertificate.formatr(xElem, xWriter, "");
        xWriter.flush();
    }

    private static final void formatr(XElem xElem, XWriter xWriter, String string) {
        xWriter.w((Object)string).w('<').w((Object)xElem.name());
        int n = xElem.attrSize();
        int n2 = 0;
        while (n2 < n) {
            xWriter.w((Object)" ").attr(xElem.attrName(n2), xElem.attrValue(n2));
            ++n2;
        }
        if (xElem.contentSize() == 0) {
            xWriter.w((Object)"/>").nl();
            return;
        }
        xWriter.w('>');
        XElem[] xElemArray = xElem.elems();
        if (xElemArray.length > 0) {
            xWriter.nl();
        }
        int n3 = 0;
        while (n3 < xElemArray.length) {
            VendorCertificate.formatr(xElemArray[n3], xWriter, string + ' ');
            ++n3;
        }
        if (xElem.text() != null) {
            xElem.text().write(xWriter);
        }
        if (xElemArray.length > 0) {
            xWriter.w((Object)string);
        }
        xWriter.w((Object)"</").w((Object)xElem.name()).w('>').nl();
    }

    protected void modify() {
        this.signature = null;
        this.modified = true;
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("  VendorCertificate");
        printWriter.println("    source:     " + this.source);
        printWriter.println("    vendor:     " + this.getVendor());
        printWriter.println("    version:    " + this.getVersion());
        printWriter.println("    expiration: " + LicenseUtil.formatDate(this.getExpiration()));
        printWriter.println("    generated:  " + LicenseUtil.formatDate(this.getGenerated()));
        printWriter.flush();
    }

    private final /* synthetic */ void this() {
        this.source = "Unknown";
        this.signature = null;
        this.modified = false;
    }

    public VendorCertificate() {
        this.this();
        this.xml = new XElem("certificate");
        this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        this.modified = true;
    }
}

