/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.NreLib;
import com.tridium.sys.license.dom.Feature;
import com.tridium.sys.license.dom.HostLicenseSet;
import com.tridium.sys.license.dom.LicenseSet;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.util.Version;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LicenseTest {
    static final long NEVER = Long.MAX_VALUE;
    int verifies;
    VendorLicense trid;

    public static void main(String[] stringArray) throws Exception {
        LicenseTest licenseTest = new LicenseTest();
        licenseTest.readTridium();
        licenseTest.fromScratch();
        licenseTest.licenseSet();
        System.out.println("ALL TESTS PASSED [" + licenseTest.verifies + ']');
    }

    public void readTridium() throws Exception {
        BIFile bIFile = BFileSystem.INSTANCE.findFile(new FilePath("!licenses/Tridium.license"));
        if (bIFile == null) {
            bIFile = BFileSystem.INSTANCE.findFile(new FilePath("!licenses/Vykon.license"));
        }
        VendorLicense vendorLicense = this.trid = new VendorLicense();
        vendorLicense.load(bIFile);
        boolean bl = false;
        if (vendorLicense.getExpiration() == Long.MAX_VALUE) {
            bl = true;
        }
        this.verify(bl);
        this.verify(vendorLicense.getHostId().equals(NreLib.getHostId()));
        this.verify(vendorLicense.getVendor().equals("Tridium"));
        boolean bl2 = false;
        if (vendorLicense.getVersion() != null) {
            bl2 = true;
        }
        this.verify(bl2);
        Feature feature = vendorLicense.getFeature("about");
        boolean bl3 = false;
        if (feature == vendorLicense.getFeature("AbOuT")) {
            bl3 = true;
        }
        this.verify(bl3);
        this.verify(feature.getName().equals("about"));
        this.verify(feature.getKey().equals("about"));
        boolean bl4 = false;
        if (feature.getExpiration() == Long.MAX_VALUE) {
            bl4 = true;
        }
        this.verify(bl4);
        boolean bl5 = false;
        if (feature.get("owner") != null) {
            bl5 = true;
        }
        this.verify(bl5);
        boolean bl6 = false;
        if (feature.get("project") != null) {
            bl6 = true;
        }
        this.verify(bl6);
        boolean bl7 = false;
        if (feature.get("foobar") == null) {
            bl7 = true;
        }
        this.verify(bl7);
        boolean bl8 = false;
        if (feature.get("foobar", "rocking") == "rocking") {
            bl8 = true;
        }
        this.verify(bl8);
        Feature.Brand brand = vendorLicense.getBrandFeature();
        this.verifyEq(brand.getStationIn(), "*");
        this.verifyEq(brand.getStationOut(), "*");
        this.verifyEq(brand.getWbIn(), "*");
        this.verifyEq(brand.getWbOut(), "*");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        vendorLicense.save(byteArrayOutputStream);
        this.roundRobinIO(this.trid);
    }

    public void fromScratch() throws Exception {
        VendorLicense vendorLicense = new VendorLicense();
        vendorLicense.setVendor("brianco");
        vendorLicense.setVersion(new Version("3.2"));
        vendorLicense.setHostId("win-host-id");
        vendorLicense.setSignature("abcdefghijklmnopqrstuvwxyz");
        this.roundRobinIO(vendorLicense);
        Feature feature = vendorLicense.addFeature("kickIt");
        boolean bl = false;
        if (vendorLicense.getFeature("KickIt") == feature) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (feature.getParent() == vendorLicense) {
            bl2 = true;
        }
        this.verify(bl2);
        this.verify(feature.getName().equals("kickIt"));
        boolean bl3 = false;
        if (feature.list().length == 0) {
            bl3 = true;
        }
        this.verify(bl3);
        this.roundRobinIO(vendorLicense);
        feature.set("alpha", "bravo");
        feature.set("charlie", "delta");
        feature.set("bool", false);
        feature.set("int", 77);
        boolean bl4 = false;
        if (feature.list().length == 4) {
            bl4 = true;
        }
        this.verify(bl4);
        this.verifyEq(feature.get("alpha"), "bravo");
        this.verifyEq(feature.get("charlie"), "delta");
        this.verify(feature.getb("bool", true) ^ true);
        boolean bl5 = false;
        if (feature.geti("int", 99) == 77) {
            bl5 = true;
        }
        this.verify(bl5);
        this.roundRobinIO(vendorLicense);
        vendorLicense.removeFeature("kickIt");
        boolean bl6 = false;
        if (vendorLicense.getFeature("KickIt") == null) {
            bl6 = true;
        }
        this.verify(bl6);
        this.roundRobinIO(vendorLicense);
    }

    public void licenseSet() throws Exception {
        BDirectory bDirectory = BFileSystem.INSTANCE.makeDir(new FilePath("!licenses/test"), null);
        VendorLicense vendorLicense = this.makeLic(bDirectory, "A", "tridium", "vykon", null);
        VendorLicense vendorLicense2 = this.makeLic(bDirectory, "A", "acme", null, null);
        VendorLicense vendorLicense3 = this.makeLic(bDirectory, "B", "tridium", "vykon", null);
        VendorLicense vendorLicense4 = this.makeLic(bDirectory, "C", "tridium", "vykon", "C-tridium-1.license");
        VendorLicense vendorLicense5 = this.makeLic(bDirectory, "C", "tridium", "vykon", "C-tridium-2.license");
        VendorLicense vendorLicense6 = this.makeLic(bDirectory, "D", "tridium", "tridium", "D-tridium-1.license");
        VendorLicense vendorLicense7 = this.makeLic(bDirectory, "D", "tridium", "vykon", "D-tridium-2.license");
        LicenseSet licenseSet = new LicenseSet();
        licenseSet.load(bDirectory);
        HostLicenseSet hostLicenseSet = licenseSet.toHostLicenseSet("no way", "vykon");
        boolean bl = false;
        if (hostLicenseSet == null) {
            bl = true;
        }
        this.verify(bl);
        hostLicenseSet = licenseSet.toHostLicenseSet("A", "vykon");
        this.verifyEq(hostLicenseSet.getHostId(), "A");
        this.verifyEq(hostLicenseSet.getVendorLicense("acme"), vendorLicense2);
        this.verifyEq(hostLicenseSet.getVendorLicense("tridium"), vendorLicense);
        this.verifyEq(hostLicenseSet.getTridiumLicense(), vendorLicense);
        this.verifyEq(hostLicenseSet.getBrandFeature().getBrandId(), "vykon");
        hostLicenseSet = licenseSet.toHostLicenseSet("B", "vykon");
        this.verifyEq(hostLicenseSet.getHostId(), "B");
        this.verifyEq(hostLicenseSet.getTridiumLicense(), vendorLicense3);
        this.verifyEq(hostLicenseSet.getBrandFeature().getBrandId(), "vykon");
        Exception exception = null;
        try {
            hostLicenseSet = licenseSet.toHostLicenseSet("C", "vykon");
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        boolean bl2 = false;
        if (exception != null) {
            bl2 = true;
        }
        this.verify(bl2);
        hostLicenseSet = licenseSet.toHostLicenseSet("D", "tridium");
        this.verifyEq(hostLicenseSet.getHostId(), "D");
        this.verifyEq(hostLicenseSet.getTridiumLicense(), vendorLicense6);
        this.verifyEq(hostLicenseSet.getBrandFeature().getBrandId(), "tridium");
        hostLicenseSet = licenseSet.toHostLicenseSet("D", "vykon");
        this.verifyEq(hostLicenseSet.getHostId(), "D");
        this.verifyEq(hostLicenseSet.getTridiumLicense(), vendorLicense7);
        this.verifyEq(hostLicenseSet.getBrandFeature().getBrandId(), "vykon");
    }

    VendorLicense makeLic(BIFile bIFile, String string, String string2, String string3, String string4) throws Exception {
        VendorLicense vendorLicense = new VendorLicense();
        vendorLicense.setHostId(string);
        vendorLicense.setVendor(string2);
        vendorLicense.setVersion(new Version("3.3"));
        vendorLicense.setSignature("sig");
        if (string2.equals("tridium")) {
            Feature feature = vendorLicense.addFeature("brand");
            feature.set("brandId", string3 == null ? "vykon" : string3);
        }
        if (string4 == null) {
            string4 = string + '-' + string2 + ".license";
        }
        vendorLicense.save(BFileSystem.INSTANCE.makeFile(bIFile.getFilePath().merge(string4), null));
        return vendorLicense;
    }

    public void roundRobinIO(VendorLicense vendorLicense) throws Exception {
        byte[] byArray = this.saveToBuf(vendorLicense);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        VendorLicense vendorLicense2 = new VendorLicense();
        vendorLicense2.load(vendorLicense.getSource(), byteArrayInputStream);
        this.verifyEq(vendorLicense, vendorLicense2);
    }

    public void verifyEq(VendorLicense vendorLicense, VendorLicense vendorLicense2) throws Exception {
        this.verifyEq(vendorLicense.getVendor(), vendorLicense2.getVendor());
        this.verifyEq(vendorLicense.getExpiration(), vendorLicense2.getExpiration());
        this.verifyEq(vendorLicense.getHostId(), vendorLicense2.getHostId());
        Feature[] featureArray = vendorLicense.getFeatures();
        Feature[] featureArray2 = vendorLicense2.getFeatures();
        boolean bl = false;
        if (featureArray.length == featureArray2.length) {
            bl = true;
        }
        this.verify(bl);
        int n = 0;
        while (n < featureArray.length) {
            this.verifyEq(featureArray[n], featureArray2[n]);
            ++n;
        }
        this.verifyEq(this.saveToBuf(vendorLicense), this.saveToBuf(vendorLicense2));
    }

    public void verifyEq(Feature feature, Feature feature2) {
        this.verifyEq(feature.getName(), feature2.getName());
        this.verifyEq(feature.getExpiration(), feature2.getExpiration());
        String[] stringArray = feature.list();
        String[] stringArray2 = feature2.list();
        boolean bl = false;
        if (stringArray.length == stringArray2.length) {
            bl = true;
        }
        this.verify(bl);
        int n = 0;
        while (n < stringArray.length) {
            this.verifyEq(stringArray[n], stringArray2[n]);
            this.verifyEq(feature.get(stringArray[n]), feature2.get(stringArray2[n]));
            ++n;
        }
    }

    public void verifyEq(String string, String string2) {
        if (string == null) {
            boolean bl = false;
            if (string2 == null) {
                bl = true;
            }
            this.verify(bl);
        } else {
            this.verify(string.equals(string2));
        }
    }

    public void verifyEq(long l, long l2) {
        boolean bl = false;
        if (l == l2) {
            bl = true;
        }
        this.verify(bl);
    }

    public void verifyEq(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        if (byArray.length == byArray2.length) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = true;
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                bl2 = false;
                break;
            }
            ++n;
        }
        this.verify(bl2);
    }

    public void verify(boolean bl) {
        if (bl) {
            ++this.verifies;
        } else {
            throw new RuntimeException("Test failed");
        }
    }

    public byte[] saveToBuf(VendorLicense vendorLicense) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
        vendorLicense.save(xWriter);
        return byteArrayOutputStream.toByteArray();
    }

    private final /* synthetic */ void this() {
        this.verifies = 0;
    }

    public LicenseTest() {
        this.this();
    }
}

