/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.dom.HostLicenseSet;
import com.tridium.sys.license.dom.LicenseSet;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LicenseDatabase
extends LicenseSet {
    public static final LicenseDatabase LOCAL_INSTANCE = new LocalLicenseDatabase();
    protected BDirectory licenseDbRoot;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$VendorLicense;

    public Iterator iterator() throws Exception {
        return new LicenseDatabaseIterator();
    }

    public boolean add(VendorLicense vendorLicense) throws Exception {
        if (vendorLicense.getHostId().equals("*")) {
            return false;
        }
        VendorLicense vendorLicense2 = this.getLicense(vendorLicense.getHostId(), vendorLicense.getVendor(), vendorLicense.getBrandId());
        if (vendorLicense2 == null || vendorLicense.getGenerated() >= vendorLicense2.getGenerated()) {
            BDirectory bDirectory = this.makeHostDirectory(vendorLicense.getHostId());
            BIFile bIFile = this.getSpace().makeFile(bDirectory.getFilePath().merge(vendorLicense.getLicenseName() + ".license"));
            OutputStream outputStream = bIFile.getOutputStream();
            this.writeLicense(vendorLicense, outputStream);
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            return true;
        }
        return false;
    }

    public boolean remove(VendorLicense vendorLicense) throws Exception {
        return this.removeLicense(vendorLicense.getHostId(), vendorLicense.getVendor(), vendorLicense.getBrandId());
    }

    public void clear() throws Exception {
        BDirectory bDirectory = this.getSpace().makeDir(this.getRootPath(), null);
        BIFile[] bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            if (bIFileArray[n] instanceof BDirectory) {
                BIFile[] bIFileArray2 = ((BDirectory)bIFileArray[n]).listFiles();
                boolean bl = true;
                int n2 = 0;
                while (n2 < bIFileArray2.length) {
                    if ("license".equals(bIFileArray2[n2].getExtension())) {
                        bIFileArray2[n2].delete();
                    } else {
                        bl = false;
                    }
                    ++n2;
                }
                if (bl) {
                    bIFileArray[n].delete();
                }
            }
            ++n;
        }
    }

    public HostLicenseSet toHostLicenseSet(String string, String string2) throws Exception {
        HostLicenseSet hostLicenseSet = null;
        this.init();
        BDirectory bDirectory = this.getHostDirectory(string);
        if (bDirectory != null) {
            BIFile[] bIFileArray = bDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                if ("license".equals(bIFileArray[n].getExtension())) {
                    VendorLicense vendorLicense = VendorLicense.make(bIFileArray[n]);
                    if (string2 == null || vendorLicense.getBrandId() == null || vendorLicense.getBrandId().equals(string2)) {
                        if (hostLicenseSet == null) {
                            hostLicenseSet = new HostLicenseSet();
                        }
                        if (hostLicenseSet.getVendorLicense(vendorLicense.getVendor()) != null) {
                            throw new RuntimeException("Duplicate licenses for same hostId and vendor: " + vendorLicense.getVendor());
                        }
                        hostLicenseSet.add(vendorLicense);
                    }
                }
                ++n;
            }
        }
        return hostLicenseSet;
    }

    public String[] getHostIds() {
        this.init();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = LicenseDatabase.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        BDirectory bDirectory = (BDirectory)this.getSpace().findFile(this.getRootPath());
        if (bDirectory != null) {
            BIFile[] bIFileArray = bDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                if (bIFileArray[n] instanceof BDirectory) {
                    BIFile[] bIFileArray2 = ((BDirectory)bIFileArray[n]).listFiles();
                    int n2 = 0;
                    while (n2 < bIFileArray2.length) {
                        if ("license".equals(bIFileArray2[n2].getExtension())) {
                            array.add((Object)bIFileArray[n].getFileName());
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return (String[])array.trim();
    }

    public VendorLicense[] getLicenses(String string) {
        return this.getLicenses(string, null);
    }

    public VendorLicense[] getLicenses(String string, String string2) {
        this.init();
        String string3 = string2;
        Class clazz = class$com$tridium$sys$license$dom$VendorLicense;
        if (clazz == null) {
            clazz = class$com$tridium$sys$license$dom$VendorLicense = LicenseDatabase.class("[Lcom.tridium.sys.license.dom.VendorLicense;", false);
        }
        Array array = new Array(clazz);
        BDirectory bDirectory = this.getHostDirectory(string);
        if (bDirectory != null) {
            BIFile[] bIFileArray = bDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                if ("license".equals(bIFileArray[n].getExtension())) {
                    try {
                        VendorLicense vendorLicense = VendorLicense.make(bIFileArray[n]);
                        if (string3 == null || vendorLicense.getBrandId() == null || string3.equals(vendorLicense.getBrandId())) {
                            array.add((Object)vendorLicense);
                            string3 = vendorLicense.getBrandId();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
        }
        return (VendorLicense[])array.trim();
    }

    public VendorLicense getLicense(String string, String string2, String string3) {
        this.init();
        BDirectory bDirectory = this.getHostDirectory(string);
        if (bDirectory != null) {
            String string4 = "tridium".equalsIgnoreCase(string2) && string3 != null ? string3 : string2;
            BIFile bIFile = (BIFile)bDirectory.getNavChild(string4 + ".license");
            try {
                return bIFile == null ? null : VendorLicense.make(bIFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public boolean removeLicense(String string, String string2, String string3) throws Exception {
        String string4;
        BIFile bIFile;
        BDirectory bDirectory = this.getHostDirectory(string);
        if (bDirectory != null && (bIFile = (BIFile)bDirectory.getNavChild((string4 = "tridium".equalsIgnoreCase(string2) && string3 != null ? string3 : string2) + ".license")) != null) {
            bIFile.delete();
            if (bDirectory.listFiles().length == 0) {
                bDirectory.delete();
            }
            return true;
        }
        return false;
    }

    public void importFile(BIFile bIFile) throws Exception {
        if ("lar".equals(bIFile.getExtension())) {
            this.importLicenses(bIFile);
        } else if ("license".equals(bIFile.getExtension())) {
            this.add(VendorLicense.make(bIFile));
        } else {
            throw new IllegalArgumentException("importFile argument must be a license file or license archive");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importLicenses(BIFile bIFile) throws Exception {
        InputStream inputStream = bIFile.getInputStream();
        try {
            this.importLicenses(inputStream);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        inputStream.close();
    }

    /*
     * Exception decompiling
     */
    public void importLicenses(InputStream var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 101->105)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void exportLicenses(OutputStream var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 239->243)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void exportLicenses(String[] var1_1, OutputStream var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 235->239)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected BDirectory getHostDirectory(String string) {
        return (BDirectory)this.getSpace().findFile(this.getRootPath().merge(string));
    }

    protected BDirectory makeHostDirectory(String string) throws Exception {
        return this.getSpace().makeDir(this.getRootPath().merge(string));
    }

    protected BFileSpace getSpace() {
        return this.licenseDbRoot.getFileSpace();
    }

    protected FilePath getRootPath() {
        return this.licenseDbRoot.getFilePath();
    }

    protected void init() {
    }

    protected void writeLicense(VendorLicense vendorLicense, OutputStream outputStream) throws Exception {
        XWriter xWriter = new XWriter(outputStream);
        vendorLicense.save(xWriter);
        xWriter.flush();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LicenseDatabase(BDirectory bDirectory) {
        this.licenseDbRoot = bDirectory;
    }

    protected LicenseDatabase() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LicenseDatabaseIterator
    implements Iterator {
        private String[] hostIds;
        private int hostIdx;
        private VendorLicense[] licensesForHost;
        private int licenseIdx;

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.licensesForHost != null) ** GOTO lbl13
                    if (this.hostIdx + 1 >= this.hostIds.length) {
                        this.licensesForHost = null;
                        this.licenseIdx = -1;
                        return false;
                    }
                    ++this.hostIdx;
                    this.licensesForHost = LicenseDatabase.this.getLicenses(this.hostIds[this.hostIdx]);
                    this.licenseIdx = 0;
                    continue;
lbl13:
                    // 1 sources

                    if (this.licenseIdx < this.licensesForHost.length) {
                        return true;
                    }
                    this.licensesForHost = null;
                    this.licenseIdx = -1;
                    continue;
                    break;
                }
            }
            catch (RuntimeException var1_1) {
                throw var1_1;
            }
            catch (Exception var1_2) {
                throw new BajaRuntimeException(var1_2);
            }
        }

        public Object next() {
            if (this.hasNext()) {
                VendorLicense vendorLicense = this.licensesForHost[this.licenseIdx];
                ++this.licenseIdx;
                return vendorLicense;
            }
            throw new IllegalStateException("Called next() when hasNext==false");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public LicenseDatabaseIterator() throws Exception {
            this.hostIds = LicenseDatabase.this.getHostIds();
            this.hostIdx = -1;
            this.licensesForHost = null;
            this.licenseIdx = -1;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class LocalLicenseDatabase
    extends LicenseDatabase {
        private boolean initialized;
        private String brandId;
        private ArrayList copyList;

        protected void init() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            Log log = Log.getLog("sys.license");
            try {
                this.brandId = this.getBrand();
                this.importDir(BFileSystem.INSTANCE.makeDir(new FilePath("!licenses")), false);
                this.importDir(BFileSystem.INSTANCE.makeDir(new FilePath("!licenses/inbox")), true);
                this.exportNewLicenses();
            }
            catch (Exception exception) {
                log.error("Error initializing local license database", exception);
                exception.printStackTrace();
            }
        }

        /*
         * Exception decompiling
         */
        private final String getBrand() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 96->99)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void importDir(BDirectory bDirectory, boolean bl) throws Exception {
            Log log = Log.getLog("sys.license");
            BIFile[] bIFileArray = bDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                if ("license".equals(bIFileArray[n].getExtension())) {
                    VendorLicense vendorLicense = VendorLicense.make(bIFileArray[n]);
                    this.add(vendorLicense);
                    if (bl || !vendorLicense.getHostId().equals(Sys.getHostId()) && !"*".equals(vendorLicense.getHostId())) {
                        try {
                            bIFileArray[n].delete();
                            log.message("moved " + bIFileArray[n]);
                        }
                        catch (Exception exception) {
                            log.warning("error deleting " + bIFileArray[n], exception);
                        }
                    }
                } else if ("lar".equals(bIFileArray[n].getExtension())) {
                    this.importFile(bIFileArray[n]);
                    try {
                        bIFileArray[n].delete();
                        log.message("imported and removed license archive " + bIFileArray[n]);
                    }
                    catch (Exception exception) {
                        log.warning("error deleting " + bIFileArray[n], exception);
                    }
                }
                ++n;
            }
        }

        public boolean add(VendorLicense vendorLicense) throws Exception {
            boolean bl = super.add(vendorLicense);
            if (!bl) {
                return bl;
            }
            String string = vendorLicense.getSource();
            if (Sys.getHostId().equals(vendorLicense.getHostId()) && ("lar".equals(string) || string.indexOf("licenses/inbox/") > 0)) {
                this.copyList.add(vendorLicense);
            }
            if (this.brandId == null && Sys.getHostId().equals(vendorLicense.getHostId()) && vendorLicense.getBrandId() != null) {
                this.brandId = vendorLicense.getBrandId();
            }
            return bl;
        }

        private final void exportNewLicenses() {
            Log log = Log.getLog("sys.license");
            if (this.brandId == null) {
                log.error("Could not determine brand");
                return;
            }
            Iterator iterator = this.copyList.iterator();
            while (iterator.hasNext()) {
                VendorLicense vendorLicense = (VendorLicense)iterator.next();
                if (vendorLicense.getBrandId() != null && !vendorLicense.getBrandId().equals(this.brandId)) continue;
                try {
                    FilePath filePath = new FilePath("!licenses/" + vendorLicense.getLicenseName() + ".license");
                    BIFile bIFile = BFileSystem.INSTANCE.makeFile(filePath);
                    log.message("LicenseDatabase is exporting new license to " + bIFile);
                    vendorLicense.save(bIFile);
                }
                catch (IOException iOException) {
                    log.error("LicenseDatabase could not copy license file to !licenses", iOException);
                }
            }
            this.copyList.clear();
        }

        private final /* synthetic */ void this() {
            this.initialized = false;
            this.copyList = new ArrayList();
        }

        public LocalLicenseDatabase() {
            this.this();
            try {
                this.licenseDbRoot = BFileSystem.INSTANCE.makeDir(new FilePath("!licenses/db"));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException(exception);
            }
        }
    }
}

