/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.Nre;
import com.tridium.sys.license.FlrException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class XFlrMsg {
    private static final Lexicon lex = Lexicon.make("baja");
    private String type;
    private XChallenge challenge;
    private XElem payload;
    private BFacets metadata;

    public static XFlrMsg make(InputStream inputStream) throws Exception {
        return new XFlrMsg(XParser.make((InputStream)inputStream).parse());
    }

    public static XFlrMsg error(Exception exception) {
        XFlrMsg xFlrMsg = new XFlrMsg("error");
        XElem xElem = new XElem("error").addContent((XContent)new XElem("exception").addText(exception == null ? "?" : exception.toString()));
        if (exception != null && exception.getCause() != null) {
            xElem.addContent((XContent)new XElem("cause").addText(exception.getCause().toString()));
        }
        xFlrMsg.setPayload(xElem);
        return xFlrMsg;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public XChallenge getChallenge() {
        return this.challenge;
    }

    public void setChallenge(XChallenge xChallenge) {
        this.challenge = xChallenge;
    }

    public BFacets getMetadata() {
        return this.metadata;
    }

    public XFlrMsg setMetadata(String string, BIDataValue bIDataValue) {
        this.metadata = BFacets.make(this.metadata, BFacets.make(string, bIDataValue));
        return this;
    }

    public XElem getPayload() {
        return this.payload;
    }

    public void setPayload(XElem xElem) {
        this.payload = xElem;
    }

    public void throwIfError() throws FlrException {
        XElem xElem = this.getPayload();
        if (xElem == null) {
            throw new FlrException("Null payload.");
        }
        if (!xElem.name().equals("error")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer().append(xElem.elem("exception").text());
        XElem xElem2 = xElem.elem("cause");
        if (xElem2 != null) {
            stringBuffer.append(" -- ").append(xElem2.text());
        }
        throw new FlrException(stringBuffer.toString());
    }

    public boolean isError() {
        XElem xElem = this.getPayload();
        boolean bl = false;
        if (xElem == null || xElem.name().equals("error")) {
            bl = true;
        }
        return bl;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, false);
    }

    public void write(OutputStream outputStream, boolean bl) throws IOException {
        XWriter xWriter = new XWriter(outputStream);
        this.asXML().write(xWriter);
        outputStream.flush();
        if (bl) {
            xWriter.close();
        }
    }

    public XElem asXML() {
        String string = "";
        try {
            string = this.metadata.encodeToString();
        }
        catch (Exception exception) {}
        return new XElem("msg").addAttr("type", this.type).addAttr("metadata", string).addContent((XContent)this.challenge.asXML()).addContent((XContent)new XElem("payload").addContent((XContent)this.payload.copy()));
    }

    public void dump() {
        this.asXML().dump();
    }

    public XFlrMsg(String string) {
        this.type = string;
        this.challenge = new XChallenge();
        this.payload = new XElem("empty");
    }

    public XFlrMsg(XElem xElem) {
        this.type = xElem.get("type", "");
        this.challenge = new XChallenge(xElem.elem("challenge"));
        this.metadata = BFacets.DEFAULT;
        try {
            this.metadata = BFacets.make(xElem.get("metadata"));
        }
        catch (Exception exception) {}
        this.payload = xElem.elem("payload").elem(0);
    }

    public static final class XChallenge {
        private Version version;
        private String hostid;
        private long timestamp;
        private String nonce;
        private String cksum;

        public final String getHostid() {
            return this.hostid;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final String getCksum() {
            return this.cksum;
        }

        public final void setCksum(String string) {
            this.cksum = string;
        }

        public final Version getVersion() {
            return this.version;
        }

        public final void setVersion(Version version) {
            this.version = version;
        }

        public final int[] parseNonce() {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.nonce, ":");
                int[] nArray = new int[stringTokenizer.countTokens()];
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                    ++n;
                }
                return nArray;
            }
            catch (Exception exception) {
                return new int[]{1, 2, 3, 4, 5};
            }
        }

        public final XElem asXML() {
            return new XElem("challenge").addAttr("version", this.version.toString()).addAttr("hostid", this.hostid).addAttr("timestamp", Long.toString(this.timestamp)).addAttr("nonce", this.nonce).addAttr("cksum", this.cksum);
        }

        public final void throwIfTooOld(BRelTime bRelTime) throws FlrException {
            long l = Clock.millis();
            long l2 = bRelTime.getMillis();
            if (this.getTimestamp() < l - l2 || this.getTimestamp() > l + l2) {
                throw new FlrException(lex.getText("flm.msg.errGracePeriod"));
            }
        }

        public XChallenge() {
            this.version = Version.ZERO;
            this.hostid = Nre.getHostId();
            this.timestamp = Clock.millis();
            Random random = new Random();
            int n = random.nextInt(20) + 5;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(random.nextInt());
                ++n2;
            }
            this.nonce = stringBuffer.toString();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("md5");
                this.cksum = new BigInteger(messageDigest.digest(this.nonce.getBytes())).toString(16);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.cksum = "F00BA5";
            }
        }

        XChallenge(XElem xElem) {
            this.version = new Version(xElem.get("version", Version.ZERO.toString()));
            this.hostid = xElem.get("hostid", "");
            this.timestamp = xElem.getl("timestamp", 0L);
            this.nonce = xElem.get("nonce", "1:2:3:4:5");
            this.cksum = xElem.get("cksum");
        }
    }
}

