/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.baja.license.LicenseException;
import javax.baja.nre.util.TextUtil;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XText;

public class LicenseUtil {
    private static PublicKey masterPublicKey;
    private static byte[] masterPublicKeyData;

    public static String toKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextUtil.toLowerCase((String)string)).append(':').append(TextUtil.toLowerCase((String)string2));
        return stringBuffer.toString();
    }

    public static String[] parseList(String string) throws LicenseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String formatDate(long l) {
        if (l == Long.MAX_VALUE) {
            return "never";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date(l));
    }

    public static long parseDate(String string) throws LicenseException {
        if (string.equalsIgnoreCase("never")) {
            return Long.MAX_VALUE;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "- ");
            int n = Integer.parseInt(stringTokenizer.nextToken()) - 1900;
            int n2 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            Date date = new GregorianCalendar(n + 1900, n2, n3, 23, 59).getTime();
            return date.getTime();
        }
        catch (Exception exception) {
            throw new LicenseException("Invalid expiration format YYYY-MM-DD: " + string);
        }
    }

    public static byte[] encode(XElem xElem) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LicenseUtil.encode((OutputStream)byteArrayOutputStream, xElem);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new IllegalStateException();
        }
    }

    private static final void encode(OutputStream outputStream, XElem xElem) throws IOException {
        LicenseUtil.encode(outputStream, "<");
        LicenseUtil.encode(outputStream, xElem.qname());
        int n = 0;
        while (n < xElem.attrSize()) {
            LicenseUtil.encode(outputStream, " ");
            LicenseUtil.encode(outputStream, xElem.attrName(n));
            LicenseUtil.encode(outputStream, "=\"");
            LicenseUtil.encode(outputStream, xElem.attrValue(n));
            LicenseUtil.encode(outputStream, "\"");
            ++n;
        }
        LicenseUtil.encode(outputStream, ">\n");
        n = 0;
        while (n < xElem.contentSize()) {
            XContent xContent = xElem.content(n);
            if (xContent instanceof XElem) {
                LicenseUtil.encode(outputStream, (XElem)xContent);
            } else {
                LicenseUtil.encode(outputStream, ((XText)xContent).string());
                LicenseUtil.encode(outputStream, "\n");
            }
            ++n;
        }
        LicenseUtil.encode(outputStream, "</");
        LicenseUtil.encode(outputStream, xElem.qname());
        LicenseUtil.encode(outputStream, ">\n");
    }

    private static final void encode(OutputStream outputStream, String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            outputStream.write(string.charAt(n));
            ++n;
        }
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray3);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        return LicenseUtil.verify(byArray, byArray2, publicKey);
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance("DSA");
        signature.initVerify(publicKey);
        signature.update(byArray);
        return signature.verify(byArray2);
    }

    static PublicKey toPublicKey(byte[] byArray) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    static PublicKey getMasterPublicKey() throws Exception {
        if (masterPublicKey == null) {
            masterPublicKey = LicenseUtil.toPublicKey(masterPublicKeyData);
        }
        return masterPublicKey;
    }

    static {
        byte[] byArray = new byte[444];
        byArray[0] = 48;
        byArray[1] = -126;
        byArray[2] = 1;
        byArray[3] = -72;
        byArray[4] = 48;
        byArray[5] = -126;
        byArray[6] = 1;
        byArray[7] = 44;
        byArray[8] = 6;
        byArray[9] = 7;
        byArray[10] = 42;
        byArray[11] = -122;
        byArray[12] = 72;
        byArray[13] = -50;
        byArray[14] = 56;
        byArray[15] = 4;
        byArray[16] = 1;
        byArray[17] = 48;
        byArray[18] = -126;
        byArray[19] = 1;
        byArray[20] = 31;
        byArray[21] = 2;
        byArray[22] = -127;
        byArray[23] = -127;
        byArray[25] = -3;
        byArray[26] = 127;
        byArray[27] = 83;
        byArray[28] = -127;
        byArray[29] = 29;
        byArray[30] = 117;
        byArray[31] = 18;
        byArray[32] = 41;
        byArray[33] = 82;
        byArray[34] = -33;
        byArray[35] = 74;
        byArray[36] = -100;
        byArray[37] = 46;
        byArray[38] = -20;
        byArray[39] = -28;
        byArray[40] = -25;
        byArray[41] = -10;
        byArray[42] = 17;
        byArray[43] = -73;
        byArray[44] = 82;
        byArray[45] = 60;
        byArray[46] = -17;
        byArray[47] = 68;
        byArray[49] = -61;
        byArray[50] = 30;
        byArray[51] = 63;
        byArray[52] = -128;
        byArray[53] = -74;
        byArray[54] = 81;
        byArray[55] = 38;
        byArray[56] = 105;
        byArray[57] = 69;
        byArray[58] = 93;
        byArray[59] = 64;
        byArray[60] = 34;
        byArray[61] = 81;
        byArray[62] = -5;
        byArray[63] = 89;
        byArray[64] = 61;
        byArray[65] = -115;
        byArray[66] = 88;
        byArray[67] = -6;
        byArray[68] = -65;
        byArray[69] = -59;
        byArray[70] = -11;
        byArray[71] = -70;
        byArray[72] = 48;
        byArray[73] = -10;
        byArray[74] = -53;
        byArray[75] = -101;
        byArray[76] = 85;
        byArray[77] = 108;
        byArray[78] = -41;
        byArray[79] = -127;
        byArray[80] = 59;
        byArray[81] = -128;
        byArray[82] = 29;
        byArray[83] = 52;
        byArray[84] = 111;
        byArray[85] = -14;
        byArray[86] = 102;
        byArray[87] = 96;
        byArray[88] = -73;
        byArray[89] = 107;
        byArray[90] = -103;
        byArray[91] = 80;
        byArray[92] = -91;
        byArray[93] = -92;
        byArray[94] = -97;
        byArray[95] = -97;
        byArray[96] = -24;
        byArray[97] = 4;
        byArray[98] = 123;
        byArray[99] = 16;
        byArray[100] = 34;
        byArray[101] = -62;
        byArray[102] = 79;
        byArray[103] = -69;
        byArray[104] = -87;
        byArray[105] = -41;
        byArray[106] = -2;
        byArray[107] = -73;
        byArray[108] = -58;
        byArray[109] = 27;
        byArray[110] = -8;
        byArray[111] = 59;
        byArray[112] = 87;
        byArray[113] = -25;
        byArray[114] = -58;
        byArray[115] = -88;
        byArray[116] = -90;
        byArray[117] = 21;
        byArray[118] = 15;
        byArray[119] = 4;
        byArray[120] = -5;
        byArray[121] = -125;
        byArray[122] = -10;
        byArray[123] = -45;
        byArray[124] = -59;
        byArray[125] = 30;
        byArray[126] = -61;
        byArray[127] = 2;
        byArray[128] = 53;
        byArray[129] = 84;
        byArray[130] = 19;
        byArray[131] = 90;
        byArray[132] = 22;
        byArray[133] = -111;
        byArray[134] = 50;
        byArray[135] = -10;
        byArray[136] = 117;
        byArray[137] = -13;
        byArray[138] = -82;
        byArray[139] = 43;
        byArray[140] = 97;
        byArray[141] = -41;
        byArray[142] = 42;
        byArray[143] = -17;
        byArray[144] = -14;
        byArray[145] = 34;
        byArray[146] = 3;
        byArray[147] = 25;
        byArray[148] = -99;
        byArray[149] = -47;
        byArray[150] = 72;
        byArray[151] = 1;
        byArray[152] = -57;
        byArray[153] = 2;
        byArray[154] = 21;
        byArray[156] = -105;
        byArray[157] = 96;
        byArray[158] = 80;
        byArray[159] = -113;
        byArray[160] = 21;
        byArray[161] = 35;
        byArray[162] = 11;
        byArray[163] = -52;
        byArray[164] = -78;
        byArray[165] = -110;
        byArray[166] = -71;
        byArray[167] = -126;
        byArray[168] = -94;
        byArray[169] = -21;
        byArray[170] = -124;
        byArray[171] = 11;
        byArray[172] = -16;
        byArray[173] = 88;
        byArray[174] = 28;
        byArray[175] = -11;
        byArray[176] = 2;
        byArray[177] = -127;
        byArray[178] = -127;
        byArray[180] = -9;
        byArray[181] = -31;
        byArray[182] = -96;
        byArray[183] = -123;
        byArray[184] = -42;
        byArray[185] = -101;
        byArray[186] = 61;
        byArray[187] = -34;
        byArray[188] = -53;
        byArray[189] = -68;
        byArray[190] = -85;
        byArray[191] = 92;
        byArray[192] = 54;
        byArray[193] = -72;
        byArray[194] = 87;
        byArray[195] = -71;
        byArray[196] = 121;
        byArray[197] = -108;
        byArray[198] = -81;
        byArray[199] = -69;
        byArray[200] = -6;
        byArray[201] = 58;
        byArray[202] = -22;
        byArray[203] = -126;
        byArray[204] = -7;
        byArray[205] = 87;
        byArray[206] = 76;
        byArray[207] = 11;
        byArray[208] = 61;
        byArray[209] = 7;
        byArray[210] = -126;
        byArray[211] = 103;
        byArray[212] = 81;
        byArray[213] = 89;
        byArray[214] = 87;
        byArray[215] = -114;
        byArray[216] = -70;
        byArray[217] = -44;
        byArray[218] = 89;
        byArray[219] = 79;
        byArray[220] = -26;
        byArray[221] = 113;
        byArray[222] = 7;
        byArray[223] = 16;
        byArray[224] = -127;
        byArray[225] = -128;
        byArray[226] = -76;
        byArray[227] = 73;
        byArray[228] = 22;
        byArray[229] = 113;
        byArray[230] = 35;
        byArray[231] = -24;
        byArray[232] = 76;
        byArray[233] = 40;
        byArray[234] = 22;
        byArray[235] = 19;
        byArray[236] = -73;
        byArray[237] = -49;
        byArray[238] = 9;
        byArray[239] = 50;
        byArray[240] = -116;
        byArray[241] = -56;
        byArray[242] = -90;
        byArray[243] = -31;
        byArray[244] = 60;
        byArray[245] = 22;
        byArray[246] = 122;
        byArray[247] = -117;
        byArray[248] = 84;
        byArray[249] = 124;
        byArray[250] = -115;
        byArray[251] = 40;
        byArray[252] = -32;
        byArray[253] = -93;
        byArray[254] = -82;
        byArray[255] = 30;
        byArray[256] = 43;
        byArray[257] = -77;
        byArray[258] = -90;
        byArray[259] = 117;
        byArray[260] = -111;
        byArray[261] = 110;
        byArray[262] = -93;
        byArray[263] = 127;
        byArray[264] = 11;
        byArray[265] = -6;
        byArray[266] = 33;
        byArray[267] = 53;
        byArray[268] = 98;
        byArray[269] = -15;
        byArray[270] = -5;
        byArray[271] = 98;
        byArray[272] = 122;
        byArray[273] = 1;
        byArray[274] = 36;
        byArray[275] = 59;
        byArray[276] = -52;
        byArray[277] = -92;
        byArray[278] = -15;
        byArray[279] = -66;
        byArray[280] = -88;
        byArray[281] = 81;
        byArray[282] = -112;
        byArray[283] = -119;
        byArray[284] = -88;
        byArray[285] = -125;
        byArray[286] = -33;
        byArray[287] = -31;
        byArray[288] = 90;
        byArray[289] = -27;
        byArray[290] = -97;
        byArray[291] = 6;
        byArray[292] = -110;
        byArray[293] = -117;
        byArray[294] = 102;
        byArray[295] = 94;
        byArray[296] = -128;
        byArray[297] = 123;
        byArray[298] = 85;
        byArray[299] = 37;
        byArray[300] = 100;
        byArray[301] = 1;
        byArray[302] = 76;
        byArray[303] = 59;
        byArray[304] = -2;
        byArray[305] = -49;
        byArray[306] = 73;
        byArray[307] = 42;
        byArray[308] = 3;
        byArray[309] = -127;
        byArray[310] = -123;
        byArray[312] = 2;
        byArray[313] = -127;
        byArray[314] = -127;
        byArray[316] = -117;
        byArray[317] = -24;
        byArray[318] = 19;
        byArray[319] = 70;
        byArray[320] = 80;
        byArray[321] = -13;
        byArray[322] = -91;
        byArray[323] = 91;
        byArray[324] = 33;
        byArray[325] = -33;
        byArray[326] = 99;
        byArray[327] = -67;
        byArray[328] = 97;
        byArray[329] = -80;
        byArray[330] = 1;
        byArray[331] = -34;
        byArray[332] = -33;
        byArray[333] = 25;
        byArray[334] = -80;
        byArray[335] = 27;
        byArray[336] = 121;
        byArray[337] = -11;
        byArray[338] = 71;
        byArray[339] = 26;
        byArray[340] = -70;
        byArray[341] = -126;
        byArray[342] = -85;
        byArray[343] = -95;
        byArray[344] = -106;
        byArray[345] = -84;
        byArray[346] = 45;
        byArray[347] = -73;
        byArray[348] = -9;
        byArray[349] = 71;
        byArray[350] = -87;
        byArray[351] = -43;
        byArray[352] = 113;
        byArray[353] = 70;
        byArray[354] = -59;
        byArray[355] = -24;
        byArray[356] = -122;
        byArray[357] = 31;
        byArray[358] = 58;
        byArray[359] = 100;
        byArray[360] = 3;
        byArray[361] = -95;
        byArray[362] = 91;
        byArray[363] = -27;
        byArray[364] = -104;
        byArray[365] = -99;
        byArray[366] = -119;
        byArray[367] = 16;
        byArray[368] = -42;
        byArray[369] = 85;
        byArray[370] = -36;
        byArray[371] = -67;
        byArray[372] = -102;
        byArray[373] = -52;
        byArray[374] = 78;
        byArray[375] = -93;
        byArray[376] = -95;
        byArray[377] = 94;
        byArray[378] = 67;
        byArray[379] = 53;
        byArray[380] = -34;
        byArray[381] = 13;
        byArray[382] = -13;
        byArray[383] = 72;
        byArray[384] = -57;
        byArray[385] = -115;
        byArray[386] = 82;
        byArray[387] = 56;
        byArray[388] = 82;
        byArray[389] = 60;
        byArray[390] = -23;
        byArray[391] = 98;
        byArray[392] = 113;
        byArray[393] = -128;
        byArray[394] = -56;
        byArray[395] = -105;
        byArray[396] = 81;
        byArray[397] = -4;
        byArray[398] = 63;
        byArray[399] = -75;
        byArray[400] = 81;
        byArray[401] = 3;
        byArray[402] = 38;
        byArray[403] = 38;
        byArray[404] = 103;
        byArray[405] = -48;
        byArray[406] = -33;
        byArray[407] = -108;
        byArray[408] = -128;
        byArray[409] = -1;
        byArray[410] = 25;
        byArray[411] = 83;
        byArray[412] = -112;
        byArray[413] = -61;
        byArray[414] = 57;
        byArray[415] = 84;
        byArray[416] = 68;
        byArray[417] = -94;
        byArray[418] = -24;
        byArray[419] = 15;
        byArray[420] = -80;
        byArray[421] = -44;
        byArray[422] = -106;
        byArray[423] = -19;
        byArray[424] = 55;
        byArray[425] = 5;
        byArray[426] = 14;
        byArray[427] = 40;
        byArray[428] = 75;
        byArray[429] = 35;
        byArray[430] = 42;
        byArray[431] = -17;
        byArray[432] = 47;
        byArray[433] = 53;
        byArray[434] = -15;
        byArray[435] = 77;
        byArray[436] = 56;
        byArray[437] = -106;
        byArray[438] = -63;
        byArray[439] = 100;
        byArray[440] = -11;
        byArray[441] = -96;
        byArray[442] = -114;
        byArray[443] = -106;
        masterPublicKeyData = byArray;
    }
}

