/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.util.PatternFilter;

public class Brand {
    static final Log log = Log.getLog("sys.brand");
    private static boolean init;
    private static String brandId;
    private static AcceptList acceptStationIn;
    private static AcceptList acceptStationOut;
    private static AcceptList acceptWbIn;
    private static AcceptList acceptWbOut;

    public static String getBrandId() {
        Brand.init();
        return brandId;
    }

    public static String getAcceptStationInString() {
        Brand.init();
        return Brand.acceptStationIn.patternString;
    }

    public static String getAcceptStationOutString() {
        Brand.init();
        return Brand.acceptStationOut.patternString;
    }

    public static String getAcceptWbInString() {
        Brand.init();
        return Brand.acceptWbIn.patternString;
    }

    public static String getAcceptWbOutString() {
        Brand.init();
        return Brand.acceptWbOut.patternString;
    }

    public static void checkStationIn(String string) {
        Brand.init();
        acceptStationIn.check(string);
    }

    public static void checkStationOut(String string) {
        Brand.init();
        acceptStationOut.check(string);
    }

    public static void checkWbIn(String string) {
        Brand.init();
        acceptWbIn.check(string);
    }

    public static void checkWbOut(String string) {
        Brand.init();
        acceptWbOut.check(string);
    }

    private static final void init() {
        if (init) {
            return;
        }
        Feature feature = Sys.getLicenseManager().checkFeature("tridium", "brand");
        brandId = feature.get("brandId");
        if (brandId == null) {
            throw new LicenseException("Missing brandId in brand feature");
        }
        acceptStationIn = new AcceptList(feature, "accept.station.in");
        acceptStationOut = new AcceptList(feature, "accept.station.out");
        acceptWbIn = new AcceptList(feature, "accept.wb.in");
        acceptWbOut = new AcceptList(feature, "accept.wb.out");
        init = true;
    }

    public static class AcceptList {
        String id;
        PatternFilter[] patterns;
        String patternString;

        public void check(String string) {
            if (!this.accept(string)) {
                throw new LicenseException("Brand incompatibility [" + this.id + "] " + string + " != " + this.patternString);
            }
        }

        public boolean accept(String string) {
            if (log.isTraceOn()) {
                log.trace("check " + this.id + ": " + string + " against " + this.patternString);
            }
            if (string == null) {
                return true;
            }
            int n = 0;
            while (n < this.patterns.length) {
                if (this.patterns[n].accept(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public String toString() {
            return this.id + '=' + this.patternString;
        }

        public AcceptList(Feature feature, String string) {
            this.id = string;
            this.patternString = feature.get(string, "*");
            this.patterns = PatternFilter.parseList(this.patternString, ";");
        }

        public AcceptList(String string, String string2) {
            this.id = string;
            this.patternString = string2;
            this.patterns = PatternFilter.parseList(string2, ";");
        }
    }
}

