/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.engine.NClockTicket;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TicketQueue {
    public int minScan;
    public int maxScan;
    int scanCount;
    long totalTicksInsideScan;
    int size;
    int peak;
    NClockTicket head;
    NClockTicket tail;
    long nextScan;
    final Object lock;

    public void check() {
        long l = Clock.ticks();
        if (this.nextScan >= l) {
            return;
        }
        long l2 = this.scan();
        long l3 = Clock.ticks();
        if (l2 < (long)this.minScan) {
            l2 = this.minScan;
        }
        if (l2 > (long)this.maxScan) {
            l2 = this.maxScan;
        }
        this.nextScan = l + l2;
        this.totalTicksInsideScan += l3 - l;
        ++this.scanCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueue(NClockTicket nClockTicket) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                block4: {
                    if (this.tail != null) break block4;
                    this.head = this.tail = nClockTicket;
                    break block5;
                }
                this.tail.next = nClockTicket;
                this.tail = nClockTicket;
            }
            ++this.size;
            if (this.size > this.peak) {
                this.peak = this.size;
            }
            this.nextScan = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long scan() {
        long l;
        NClockTicket nClockTicket;
        NClockTicket nClockTicket2;
        NClockTicket nClockTicket3 = null;
        Object object = this.lock;
        synchronized (object) {
            nClockTicket3 = this.head;
            this.tail = null;
            this.head = null;
            this.size = 0;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            nClockTicket2 = null;
            nClockTicket = null;
            l = Long.MAX_VALUE;
        }
        long l2 = Clock.ticks();
        long l3 = Clock.millis();
        int n = 0;
        while (nClockTicket3 != null) {
            NClockTicket nClockTicket4 = nClockTicket3.next;
            nClockTicket3.next = null;
            long l4 = nClockTicket3.process(l2, l3);
            if (l4 != Long.MIN_VALUE) {
                l = Math.min(l, l4);
                if (nClockTicket == null) {
                    nClockTicket2 = nClockTicket = nClockTicket3;
                } else {
                    nClockTicket.next = nClockTicket3;
                    nClockTicket = nClockTicket3;
                }
                ++n;
            }
            nClockTicket3 = nClockTicket4;
        }
        object = this.lock;
        synchronized (object) {
            block11: {
                block13: {
                    block12: {
                        if (nClockTicket2 == null) break block11;
                        if (this.head != null) break block12;
                        this.head = nClockTicket2;
                        this.tail = nClockTicket;
                        break block13;
                    }
                    nClockTicket.next = this.head;
                    this.head = nClockTicket2;
                }
                this.size += n;
                if (this.size > this.peak) {
                    this.peak = this.size;
                }
            }
            return l;
        }
    }

    public void writeSummary(SpyWriter spyWriter, String string) throws Exception {
        long l = Clock.ticks();
        String string2 = this.nextScan < l ? "next cycle" : EngineManager.timeStr(this.nextScan - l);
        spyWriter.prop((Object)"scanCount", "" + this.scanCount);
        spyWriter.prop((Object)"totalTicksInsideScan", EngineManager.timeStr(this.totalTicksInsideScan));
        spyWriter.prop((Object)("<a href='" + spyWriter.href(string) + "'>Queue</a>"), this.size + " (Peak " + this.peak + ')');
        spyWriter.prop((Object)"nextScan", string2);
        spyWriter.prop((Object)"scanBounds", this.minScan + "ms - " + this.maxScan + "ms");
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
    }

    public TicketQueue(int n, int n2) {
        this.this();
        this.minScan = n;
        this.maxScan = n2;
    }
}

