/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.log.Log;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;

public final class EngineUtil {
    public static final Log log = EngineManager.log;

    public static final void invoke(BComponent bComponent, Action action, BValue bValue, Context context) {
        try {
            bComponent.invoke(action, bValue, context);
        }
        catch (ActionInvokeException actionInvokeException) {
            log.error("Action failed: " + action, actionInvokeException.getCause());
        }
        catch (Throwable throwable) {
            log.error("Action failed: " + action, throwable);
        }
    }

    public static final void doInvoke(BComponent bComponent, Action action, BValue bValue, Context context) {
        try {
            ((ComponentSlotMap)bComponent.fw(1)).invoke(action, bValue, context, true);
        }
        catch (ActionInvokeException actionInvokeException) {
            log.error("Action failed: " + action, actionInvokeException.getCause());
        }
        catch (Throwable throwable) {
            log.error("Action failed: " + action, throwable);
        }
    }

    public static final void fire(BComponent bComponent, Topic topic, BValue bValue) {
        try {
            bComponent.fire(topic, bValue);
        }
        catch (Throwable throwable) {
            log.error("Topic failed: " + topic, throwable);
        }
    }

    public static final void activate(BLink bLink) {
        try {
            if (bLink.isEnabled()) {
                bLink.activate();
            }
        }
        catch (UnresolvedException unresolvedException) {
            log.error("Cannot activate link \"" + EngineUtil.toString(bLink) + "\": " + unresolvedException.getMessage());
        }
        catch (Throwable throwable) {
            log.error("Cannot activate link \"" + EngineUtil.toString(bLink) + '\"', throwable);
        }
    }

    public static final void deactivate(BLink bLink) {
        try {
            if (bLink.isActive()) {
                bLink.deactivate();
            }
        }
        catch (Throwable throwable) {
            log.error("Cannot deactivate link \"" + EngineUtil.toString(bLink) + '\"', throwable);
        }
    }

    public static final void started(BComponent bComponent) {
        try {
            bComponent.fw(11, null, null, null, null);
            bComponent.started();
        }
        catch (Throwable throwable) {
            log.error("Cannot start component: " + EngineUtil.toString(bComponent), throwable);
        }
    }

    public static final void stopped(BComponent bComponent) {
        try {
            bComponent.fw(12, null, null, null, null);
            bComponent.stopped();
        }
        catch (Throwable throwable) {
            log.error("Cannot stop component: " + EngineUtil.toString(bComponent), throwable);
        }
    }

    public static final void descendantsStarted(BComponent bComponent) {
        try {
            bComponent.fw(13, null, null, null, null);
            bComponent.descendantsStarted();
        }
        catch (Throwable throwable) {
            log.error("Cannot start component: " + EngineUtil.toString(bComponent), throwable);
        }
    }

    public static final void descendantsStopped(BComponent bComponent) {
        try {
            bComponent.fw(14, null, null, null, null);
            bComponent.descendantsStopped();
        }
        catch (Throwable throwable) {
            log.error("Cannot stop component: " + EngineUtil.toString(bComponent), throwable);
        }
    }

    public static final void stationStarted(BComponent bComponent) {
        try {
            bComponent.fw(23, null, null, null, null);
            bComponent.stationStarted();
        }
        catch (Throwable throwable) {
            log.error("Failed stationStarted: " + EngineUtil.toString(bComponent), throwable);
        }
    }

    public static final void atSteadyState(BComponent bComponent) {
        try {
            bComponent.fw(20, null, null, null, null);
            bComponent.atSteadyState();
        }
        catch (Throwable throwable) {
            log.error("Failed atSteadyState: " + EngineUtil.toString(bComponent), throwable);
        }
    }

    public static final void clockChanged(BComponent bComponent, BRelTime bRelTime) {
        try {
            bComponent.clockChanged(bRelTime);
        }
        catch (Throwable throwable) {
            log.error("Failed clockChanged: " + EngineUtil.toString(bComponent), throwable);
        }
    }

    public static final String toString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (Throwable throwable) {
            return object.getClass().getName() + "???";
        }
    }

    public static final void activateLinks(BComponent bComponent) {
        try {
            SlotCursor slotCursor = bComponent.getProperties();
            while (slotCursor.nextObject()) {
                BObject bObject = slotCursor.get();
                if (bObject instanceof BLink) {
                    EngineUtil.activate((BLink)bObject);
                }
                if (!(bObject instanceof BComponent)) continue;
                EngineUtil.activateLinks((BComponent)bObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final void deactivateLinks(BComponent bComponent) {
        try {
            SlotCursor slotCursor = bComponent.getProperties();
            while (slotCursor.nextObject()) {
                BObject bObject = slotCursor.get();
                if (bObject instanceof BLink) {
                    EngineUtil.deactivate((BLink)bObject);
                }
                if (!(bObject instanceof BComponent)) continue;
                EngineUtil.deactivateLinks((BComponent)bObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

