/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.asm;

import com.tridium.asm.Buffer;
import com.tridium.asm.FieldInfo;
import com.tridium.asm.Jvm;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.baja.nre.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConstantPool {
    Buffer buf;
    int count;
    Hashtable utfTable;
    Hashtable classTable;
    Hashtable stringTable;
    Hashtable floatTable;
    Hashtable doubleTable;
    Hashtable longTable;
    IntHashMap integerTable;
    IntHashMap ntTable;
    IntHashMap fieldTable;
    IntHashMap methodTable;
    IntHashMap ifaceTable;

    public int utf(String string) {
        Integer n = (Integer)this.utfTable.get(string);
        if (n != null) {
            return n;
        }
        this.buf.u1(1);
        this.buf.utf(string);
        ++this.count;
        this.utfTable.put(string, new Integer(this.count));
        return this.count;
    }

    public int cls(String string) {
        Integer n = (Integer)this.classTable.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.utf(string);
        this.buf.u1(7);
        this.buf.u2(n2);
        ++this.count;
        this.classTable.put(string, new Integer(this.count));
        return this.count;
    }

    public int string(String string) {
        Integer n = (Integer)this.stringTable.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.utf(string);
        this.buf.u1(8);
        this.buf.u2(n2);
        ++this.count;
        this.stringTable.put(string, new Integer(this.count));
        return this.count;
    }

    public int integer(int n) {
        Integer n2 = (Integer)this.integerTable.get(n);
        if (n2 != null) {
            return n2;
        }
        this.buf.u1(3);
        this.buf.u4(n);
        ++this.count;
        this.integerTable.put(n, (Object)new Integer(this.count));
        return this.count;
    }

    public int floatConst(float f) {
        Float f2 = new Float(f);
        Integer n = (Integer)this.floatTable.get(f2);
        if (n != null) {
            return n;
        }
        this.buf.u1(4);
        this.buf.u4(Float.floatToIntBits(f));
        ++this.count;
        this.floatTable.put(f2, new Integer(this.count));
        return this.count;
    }

    public int doubleConst(double d) {
        Double d2 = new Double(d);
        Integer n = (Integer)this.doubleTable.get(d2);
        if (n != null) {
            return n;
        }
        this.buf.u1(6);
        this.buf.u8(Double.doubleToLongBits(d));
        ++this.count;
        this.doubleTable.put(d2, new Integer(this.count));
        ++this.count;
        return this.count - 1;
    }

    public int longConst(long l) {
        Long l2 = new Long(l);
        Integer n = (Integer)this.longTable.get(l2);
        if (n != null) {
            return n;
        }
        this.buf.u1(5);
        this.buf.u8(l);
        ++this.count;
        this.longTable.put(l2, new Integer(this.count));
        ++this.count;
        return this.count - 1;
    }

    public int nt(int n, int n2) {
        int n3 = n << 16 | n2;
        Integer n4 = (Integer)this.fieldTable.get(n3);
        if (n4 != null) {
            return n4;
        }
        this.buf.u1(12);
        this.buf.u2(n);
        this.buf.u2(n2);
        ++this.count;
        this.ntTable.put(n3, (Object)new Integer(this.count));
        return this.count;
    }

    public int field(int n, int n2) {
        int n3 = n << 16 | n2;
        Integer n4 = (Integer)this.fieldTable.get(n3);
        if (n4 != null) {
            return n4;
        }
        this.buf.u1(9);
        this.buf.u2(n);
        this.buf.u2(n2);
        ++this.count;
        this.fieldTable.put(n3, (Object)new Integer(this.count));
        return this.count;
    }

    public int method(int n, int n2) {
        int n3 = n << 16 | n2;
        Integer n4 = (Integer)this.methodTable.get(n3);
        if (n4 != null) {
            return n4;
        }
        this.buf.u1(10);
        this.buf.u2(n);
        this.buf.u2(n2);
        ++this.count;
        this.methodTable.put(n3, (Object)new Integer(this.count));
        return this.count;
    }

    public int iface(int n, int n2) {
        int n3 = n << 16 | n2;
        Integer n4 = (Integer)this.ifaceTable.get(n3);
        if (n4 != null) {
            return n4;
        }
        this.buf.u1(11);
        this.buf.u2(n);
        this.buf.u2(n2);
        ++this.count;
        this.ifaceTable.put(n3, (Object)new Integer(this.count));
        return this.count;
    }

    public int cls(Class clazz) {
        return this.cls(clazz.getName().replace('.', '/'));
    }

    public int nt(int n, String string) {
        return this.nt(n, this.utf(string));
    }

    public int nt(String string, String string2) {
        return this.nt(this.utf(string), this.utf(string2));
    }

    public int method(int n, int n2, String string) {
        return this.method(n, this.nt(n2, string));
    }

    public int method(int n, String string, String string2) {
        return this.method(n, this.nt(string, string2));
    }

    public int method(Method method) {
        int n = this.cls(method.getDeclaringClass());
        int n2 = this.utf(method.getName());
        int n3 = this.utf(Jvm.methodDescriptor(method.getParameterTypes(), method.getReturnType()));
        return this.method(n, this.nt(n2, n3));
    }

    public int iface(int n, String string, String string2) {
        return this.iface(n, this.nt(string, string2));
    }

    public int field(int n, int n2, String string) {
        return this.field(n, this.nt(n2, string));
    }

    public int field(int n, String string, String string2) {
        return this.field(n, this.nt(string, string2));
    }

    public int field(FieldInfo fieldInfo) {
        return this.field(fieldInfo.asm.thisClass, this.nt(fieldInfo.name, fieldInfo.type));
    }

    private final /* synthetic */ void this() {
        this.buf = new Buffer();
        this.count = 0;
        this.utfTable = new Hashtable();
        this.classTable = new Hashtable();
        this.stringTable = new Hashtable();
        this.floatTable = new Hashtable();
        this.doubleTable = new Hashtable();
        this.longTable = new Hashtable();
        this.integerTable = new IntHashMap();
        this.ntTable = new IntHashMap();
        this.fieldTable = new IntHashMap();
        this.methodTable = new IntHashMap();
        this.ifaceTable = new IntHashMap();
    }

    public ConstantPool() {
        this.this();
    }
}

