/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pacman.wb;

import com.tridium.pacman.api.PacmanApi;
import com.tridium.pacman.api.XLicense;
import com.tridium.pacman.wb.BLicensePad;
import com.tridium.pacman.wb.BModalFrame;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileWriter;
import javax.baja.gx.BImage;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LicenseProcedure {
    static final Lexicon lex = Lexicon.make((String)PacmanApi.module.getModuleName());
    static final BImage keys32 = BImage.make((String)"module://icons/x32/keys.png");
    static final BImage network32 = BImage.make((String)"module://icons/x32/network.png");
    static final BImage info32 = BImage.make((String)"module://icons/x32/info.png");
    static final BImage error32 = BImage.make((String)"module://icons/x32/error.png");
    BModalFrame frame;

    public static void licenseMe() {
        new LicenseProcedure().doLicenseMe();
    }

    private final void doLicenseMe() {
        this.stepTo(new CheckServer());
        this.frame.openModal();
    }

    public static void requestLicense(BWidgetShell bWidgetShell, String string) throws Exception {
        BLicensePad bLicensePad;
        String string2;
        int n;
        if (string != null) {
            BLicensePad.lastHostId = string;
        }
        if ((n = BDialog.open((BWidget)bWidgetShell, (String)(string2 = lex.getText("submitLicense.title")), (Object)((Object)(bLicensePad = new BLicensePad())), (int)3)) != 1) {
            return;
        }
        try {
            XLicense xLicense = bLicensePad.save();
            PacmanApi.submitLicense(xLicense, true);
            String string3 = lex.getText("licenseSubmitted.description");
            String string4 = lex.getText("licenseSubmitted.message", new Object[]{xLicense.email});
            String string5 = string3 + '\n' + string4;
            BDialog.info((BWidget)bWidgetShell, (String)string2, (Object)string5);
        }
        catch (Exception exception) {
            BDialog.error((BWidget)bWidgetShell, (String)string2, (Object)lex.getText("licenseError.description"), (Throwable)exception);
        }
    }

    void stepTo(Step step) {
        this.frame.setTitle(step.title);
        BWizardHeader bWizardHeader = new BWizardHeader(keys32, step.title, step.description);
        BButton bButton = null;
        BGridPane bGridPane = new BGridPane(step.commands.length);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.setColumnAlign(BHalign.fill);
        int n = 0;
        while (n < step.commands.length) {
            Command command = step.commands[n];
            BButton bButton2 = new BButton(command, true, true);
            if (n == 0 && !(command instanceof ExitCommand)) {
                bButton = bButton2;
            }
            bGridPane.add(null, (BValue)bButton2);
            ++n;
        }
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)bWizardHeader);
        bEdgePane.setCenter((BWidget)new BBorderPane(step.content, 16.0, 8.0, 16.0, 8.0));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane));
        this.frame.setContent((BWidget)bEdgePane);
        this.frame.relayout();
        this.frame.requestFocus();
        this.frame.setDefaultButton(bButton);
        this.frame.center();
        if (step.runInBackground) {
            step.runInBackground();
        } else {
            step.run();
        }
    }

    private final /* synthetic */ void this() {
        this.frame = new BModalFrame();
    }

    public LicenseProcedure() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CheckServer
    extends Step {
        public void run() {
            try {
                XLicense xLicense = PacmanApi.getLicense(PacmanApi.myHostId);
                if (xLicense != null) {
                    LicenseProcedure.this.stepTo(new UpdateLicense(xLicense));
                } else {
                    LicenseProcedure.this.stepTo(new RequestLicense());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                LicenseProcedure.this.stepTo(new LicenseError(null));
            }
        }

        CheckServer() {
            super("checkServer");
            this.runInBackground = true;
            this.content = new BLabel(network32, lex.getText("checkServer.message"));
            this.commands = new Command[]{new ExitCommand(true)};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Step
    implements Runnable {
        boolean runInBackground;
        String title;
        String description;
        BWidget content;
        Command[] commands;

        public void runInBackground() {
            new Thread((Runnable)this, "LicenseProcedure").start();
        }

        public void run() {
        }

        Step(String string) {
            this.title = lex.getText(string + ".title");
            this.description = lex.getText(string + ".description");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ExitCommand
    extends StepCommand {
        boolean confirm;

        public CommandArtifact doInvoke() {
            int n;
            if (this.confirm && (n = BDialog.confirm((BWidget)LicenseProcedure.this.frame, (Object)lex.getText("exit.confirm"))) != 4) {
                return null;
            }
            System.exit(0);
            return null;
        }

        ExitCommand(boolean bl) {
            super("exit");
            this.confirm = bl;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LicenseError
    extends Step {
        LicenseError(XLicense xLicense) {
            super("licenseError");
            if (xLicense == null) {
                xLicense = new XLicense();
            }
            String string = xLicense.toSubmitString();
            BTextEditor bTextEditor = new BTextEditor(string, false);
            BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 15, 40);
            BLabel bLabel = new BLabel(lex.getText("licenseError.message"));
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setLeft((BWidget)new BBorderPane((BWidget)new BLabel(error32)));
            bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bLabel));
            BEdgePane bEdgePane2 = new BEdgePane();
            bEdgePane2.setTop((BWidget)new BBorderPane((BWidget)bEdgePane));
            bEdgePane2.setCenter((BWidget)bTextEditorPane);
            this.content = bEdgePane2;
            this.commands = new Command[]{new ExitCommand(false)};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LicenseSubmitted
    extends Step {
        XLicense lic;

        LicenseSubmitted(XLicense xLicense) {
            super("licenseSubmitted");
            this.lic = xLicense;
            this.content = new BLabel(info32, lex.getText("licenseSubmitted.message", new Object[]{xLicense.email}));
            this.commands = new Command[]{new ExitCommand(false)};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LicenseInstalled
    extends Step {
        XLicense lic;

        public void run() {
            try {
                File file = new File(Sys.getBajaHome(), "licenses");
                if (!file.exists()) {
                    file.mkdirs();
                }
                File file2 = new File(file, "Tridium.license");
                FileWriter fileWriter = new FileWriter(file2);
                fileWriter.write(this.lic.file);
                fileWriter.close();
                Nre.licenseManager.reload();
            }
            catch (Throwable throwable) {
                BDialog.error((BWidget)LicenseProcedure.this.frame, (String)lex.getText("licenseInstalled.cannotWrite"), (Object)throwable);
            }
        }

        LicenseInstalled(XLicense xLicense) {
            super("licenseInstalled");
            this.lic = xLicense;
            this.content = new BLabel(info32, lex.getText("licenseInstalled.message"));
            this.commands = new Command[]{new ContinueCommand()};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SubmitLicense
    extends Step {
        XLicense lic;

        public void run() {
            try {
                XLicense xLicense = PacmanApi.submitLicense(this.lic, false);
                if (xLicense != null) {
                    LicenseProcedure.this.stepTo(new LicenseInstalled(xLicense));
                } else {
                    LicenseProcedure.this.stepTo(new LicenseSubmitted(this.lic));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                LicenseProcedure.this.stepTo(new LicenseError(this.lic));
            }
        }

        SubmitLicense(XLicense xLicense) {
            super("submitLicense");
            this.lic = xLicense;
            this.runInBackground = true;
            this.content = new BLabel(network32, lex.getText("submitLicense.message"));
            this.commands = new Command[]{new ExitCommand(true)};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RequestLicense
    extends Step {
        BLicensePad pad = new BLicensePad();

        RequestLicense() {
            super("requestLicense");
            this.content = this.pad;
            this.commands = new Command[]{new SubmitCommand(this.pad), new ExitCommand(true)};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UpdateLicense
    extends Step {
        BLicensePad pad = new BLicensePad();

        UpdateLicense(XLicense xLicense) {
            super("updateLicense");
            this.content = this.pad;
            this.pad.load(xLicense);
            this.commands = new Command[]{new SubmitCommand(this.pad), new ExitCommand(true)};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ContinueCommand
    extends StepCommand {
        public CommandArtifact doInvoke() {
            LicenseProcedure.this.frame.closeModal();
            return null;
        }

        ContinueCommand() {
            super("continue");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SubmitCommand
    extends StepCommand {
        BLicensePad pad;

        public CommandArtifact doInvoke() {
            XLicense xLicense = this.pad.save();
            if (xLicense == null) {
                return null;
            }
            LicenseProcedure.this.stepTo(new SubmitLicense(xLicense));
            return null;
        }

        SubmitCommand(BLicensePad bLicensePad) {
            super("submit");
            this.pad = bLicensePad;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StepCommand
    extends Command {
        StepCommand(String string) {
            super((BWidget)LicenseProcedure.this.frame, LicenseProcedure.lex.module, string);
        }
    }
}

