/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pacman.api;

import com.tridium.pacman.api.PacmanApi;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class XMessage {
    public String uri;
    public XElem envelope;
    public XElem body;

    public byte[] toBytes() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
        this.envelope.write(xWriter);
        xWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    public XMessage fromBytes(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.envelope = XParser.make((InputStream)byteArrayInputStream).parse();
        this.body = this.envelope.elem("body");
        return this;
    }

    public String toString() {
        return this.uri;
    }

    public void dump() {
        System.out.println("--- XMessage: " + this.uri);
        this.envelope.dump();
    }

    public XMessage(String string) {
        this.uri = string;
        this.body = new XElem("body");
        this.envelope = new XElem("envelope");
        this.envelope.addAttr("version", PacmanApi.version.toString());
        this.envelope.addAttr("fromHostId", PacmanApi.myHostId);
        this.envelope.addContent((XContent)this.body);
    }
}

