/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.px.editor.factory;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.sys.Nre;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.converters.BEnumToSimpleMap;
import javax.baja.converters.BNumericToSimpleMap;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.file.types.image.BIImageFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.factory.WidgetFactory;
import javax.baja.px.editor.factory.WidgetInserter;
import javax.baja.spy.BSpy;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;

public class ImageFileFactory
extends WidgetFactory {
    Lexicon LEX = Lexicon.make((String)"pxEditor");
    private static final String NOT_FOUND = "Spy Not Found";

    public ImageFileFactory(BPxEditor bPxEditor) {
        super(bPxEditor, BIImageFile.TYPE);
    }

    public WidgetInserter make(BObject[] bObjectArray) {
        if (!this.canConvert(bObjectArray)) {
            throw new IllegalStateException();
        }
        BWidget[] bWidgetArray = new BWidget[bObjectArray.length];
        for (int i = 0; i < bObjectArray.length; ++i) {
            BIImageFile bIImageFile = (BIImageFile)bObjectArray[i];
            BOrd bOrd = bIImageFile.getAbsoluteOrd();
            if (BOrdFE.isRelativize((BOrd)bOrd, null, (BWbShell)this.getPxEditor().getWbShell())) {
                bOrd = bOrd.relativizeToSession();
            }
            bOrd = this.convertImageOrd(bOrd);
            BImage bImage = BImage.make((BOrd)bOrd);
            bImage.setBaseOrd(this.getPxEditor().getWbShell().getActiveOrd());
            bImage.sync();
            bWidgetArray[i] = new BLabel(bImage);
            bWidgetArray[i].setLayout(BLayout.make((double)0.0, (int)0, (double)0.0, (int)0, (double)bImage.getWidth(), (int)0, (double)bImage.getHeight(), (int)0));
        }
        return new WidgetInserter(bWidgetArray);
    }

    public BOrd convertImageOrd(BOrd bOrd) {
        long l;
        String string;
        int n;
        OrdQuery ordQuery;
        BPxEditor bPxEditor = this.getPxEditor();
        BIFile bIFile = bPxEditor.getPxFile();
        BFileSpace bFileSpace = bIFile.getFileSpace();
        BIFile bIFile2 = (BIFile)bOrd.get((BObject)bFileSpace);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = !(bFileSpace instanceof BFoxFileSpace);
        BOrd bOrd2 = bPxEditor.getWbShell().getActiveOrd();
        OrdTarget ordTarget = bOrd2.resolve();
        OrdQuery[] ordQueryArray = ordTarget.getOrdQueries();
        for (int i = 0; i < ordQueryArray.length; ++i) {
            ordQuery = ordQueryArray[i];
            String string2 = ordQuery.getScheme();
            if (!string2.equals("local")) continue;
            bl = true;
        }
        if (bIFile2.getFileSpace() instanceof BModule && ((long)(n = (int)(ordQuery = Nre.moduleManager.loadModule(string = ((BModule)bIFile2.getFileSpace()).getModuleInfo().getModuleName())).getFile().length() / 1024) > (l = Long.parseLong(System.getProperty("niagara.ui.px.maxImageModuleFileSize", "2048"))) || !bl)) {
            boolean bl3 = false;
            Version version = null;
            if (!bl2) {
                version = (Version)((BFoxSession)bFileSpace.getSession()).fw(404, (Object)string, null, null, null);
            }
            if (version == null) {
                if (this.remoteModuleExists(string, bFileSpace)) {
                    bl3 = true;
                }
            } else if (!version.isNull()) {
                bl3 = true;
            }
            if (!bl3 || bl && !bl2) {
                FilePath filePath = new FilePath("^px/" + string + bIFile2.getFilePath().getBody());
                try {
                    bOrd = BOrd.make((OrdQuery)filePath);
                    bOrd.resolve((BObject)bFileSpace).get();
                }
                catch (UnresolvedException unresolvedException) {
                    try {
                        BIFile bIFile3;
                        OutputStream outputStream = null;
                        if (bl2) {
                            bIFile3 = ((BFileSystem)bFileSpace).makeFile(filePath, null);
                            outputStream = bIFile3.getOutputStream();
                        } else {
                            bIFile3 = ((BFoxFileSpace)bFileSpace).makeFile(filePath, null);
                            outputStream = ((BFoxFileSpace)bFileSpace).channel().write((BFoxFileStore)bIFile3.getStore());
                        }
                        if (outputStream == null) {
                            throw new Exception("Cannot open output stream to: " + new FilePath("^px/" + string + bIFile2.getFilePath().getBody()));
                        }
                        BProgressDialog.open((BWidget)bPxEditor, (String)this.LEX.getText("ImageFileFactory.trasferingImageFile"), (BProgressDialog.Worker)new ImageTransferWorker(bIFile2.getFileName() + " (" + bIFile2.getSize() / 1024L + "kB)", bIFile2.getInputStream(), outputStream), (BImage)BImage.make((String)this.LEX.getText("ImageFileFactory.trasferingImageFile.icon")));
                        outputStream.flush();
                        outputStream.close();
                        BImage.make((BOrd)bIFile3.getAbsoluteOrd()).sync();
                    }
                    catch (Exception exception) {
                        BDialog.error((BWidget)bPxEditor, (String)"Error", (Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }
        return bOrd;
    }

    public void convertImages(BComplex bComplex) {
        Property[] propertyArray = bComplex.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            BSimple bSimple;
            BSimple[] bSimpleArray;
            BImage bImage;
            Property property = propertyArray[i];
            if (property.getType().is(BImage.TYPE) || bComplex.get(property) instanceof BImage) {
                bImage = (BImage)bComplex.get(property);
                if (bImage.isNull()) continue;
                bSimpleArray = this.convertImage(bImage);
                bComplex.set(property, (BValue)bSimpleArray);
                continue;
            }
            if (property.getType().is(BNumericToSimpleMap.TYPE)) {
                bImage = (BNumericToSimpleMap)bComplex.get(property);
                bSimpleArray = bImage.getValues();
                for (int j = 0; j < bSimpleArray.length; ++j) {
                    if (!(bSimpleArray[j] instanceof BImage)) continue;
                    bSimpleArray[j] = this.convertImage((BImage)bSimpleArray[j]);
                }
                bSimple = bImage.getDefault();
                if (bSimple instanceof BImage) {
                    bSimple = this.convertImage((BImage)bImage.getDefault());
                }
                bComplex.set(property, (BValue)BNumericToSimpleMap.make((double[])bImage.getMinimums(), (double[])bImage.getMaximums(), (BSimple[])bSimpleArray, (BSimple)bSimple));
                continue;
            }
            if (property.getType().is(BEnumToSimpleMap.TYPE)) {
                bImage = (BEnumToSimpleMap)bComplex.get(property);
                bSimpleArray = bImage.getValues();
                for (int j = 0; j < bSimpleArray.length; ++j) {
                    if (!(bSimpleArray[j] instanceof BImage)) continue;
                    bSimpleArray[j] = this.convertImage((BImage)bSimpleArray[j]);
                }
                bSimple = bImage.getDefault();
                if (bSimple instanceof BImage) {
                    bSimple = this.convertImage((BImage)bImage.getDefault());
                }
                bComplex.set(property, (BValue)BEnumToSimpleMap.make((int[][])bImage.getOrdinals(), (BSimple[])bSimpleArray, (BSimple)bSimple));
                continue;
            }
            if (!property.getType().is(BComplex.TYPE)) continue;
            this.convertImages(bComplex.get(property).asComplex());
        }
    }

    public BImage convertImage(BImage bImage) {
        BOrdList bOrdList = bImage.getOrdList();
        BOrd[] bOrdArray = new BOrd[bOrdList.size()];
        for (int i = 0; i < bOrdList.size(); ++i) {
            bOrdArray[i] = this.convertImageOrd(bOrdList.get(i));
        }
        BImage bImage2 = BImage.make((BOrdList)BOrdList.make((BOrd[])bOrdArray));
        bImage2.setBaseOrd(this.getPxEditor().getWbShell().getActiveOrd());
        bImage2.sync();
        return bImage2;
    }

    private boolean remoteModuleExists(String string, BFileSpace bFileSpace) {
        try {
            BSpy bSpy = (BSpy)BOrd.make((String)("spy:/nav/localhost/modules/" + string)).resolve((BObject)bFileSpace).get();
            return !NOT_FOUND.equals(bSpy.get().getTitle());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    class ImageTransferWorker
    extends BProgressDialog.Worker {
        String fileName;
        InputStream is;
        OutputStream os;

        ImageTransferWorker(String string, InputStream inputStream, OutputStream outputStream) {
            this.is = inputStream;
            this.os = outputStream;
            this.fileName = string;
        }

        public void doRun() throws Exception {
            this.getDialog().getProgressBar().setIndeterminate(true);
            this.updateProgress(this.fileName);
            FileUtil.pipe((InputStream)this.is, (OutputStream)this.os);
        }

        public void doCancel() throws Exception {
            throw new Exception("Cannot Cancel");
        }
    }
}

