/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.px.editor;

import com.tridium.px.editor.BPxEditorOptions;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.util.EventUtil;
import com.tridium.ui.Binder;
import com.tridium.ui.PxIncludeManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.log.Log;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.px.editor.BPxProfile;
import javax.baja.px.editor.PxEditorController;
import javax.baja.px.editor.PxEditorSelection;
import javax.baja.px.editor.event.PxComponentEvent;
import javax.baja.px.editor.event.PxEditorEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.px.editor.event.PxPropertyEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BWbView;

public class BPxEditor
extends BWbPxView {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$px$editor$BPxEditor == null ? (class$javax$baja$px$editor$BPxEditor = BPxEditor.class$("javax.baja.px.editor.BPxEditor")) : class$javax$baja$px$editor$BPxEditor));
    private static final Log eventLogger = Log.getLog((String)"px.event");
    private ToggleCommand cmdToggleMode;
    private BPxEditorPane editorPane = null;
    private BMenu[] viewMenus = null;
    private BToolBar viewToolBar = null;
    private BWidget viewStatus = null;
    private Array listeners = new Array(class$javax$baja$px$editor$event$PxListener == null ? (class$javax$baja$px$editor$event$PxListener = BPxEditor.class$("javax.baja.px.editor.event.PxListener")) : class$javax$baja$px$editor$event$PxListener);
    private BPxProfile pxProfile;
    private PxEditorController controller = new PxEditorController(this);
    private Binder binder;
    static /* synthetic */ Class class$javax$baja$px$editor$BPxEditor;
    static /* synthetic */ Class class$javax$baja$px$editor$event$PxListener;

    public Type getType() {
        return TYPE;
    }

    public BPxEditor() {
        this(null);
    }

    public BPxEditor(BAbstractPxView bAbstractPxView) {
        super(bAbstractPxView);
        this.cmdToggleMode = new BWbPxView.ToggleMode((BWbPxView)this, (BWbPxView)this);
        this.cmdToggleMode.setSelected(true);
    }

    public void doLoadValue(BObject bObject, Context context) {
        BWidget bWidget = this.loadPx(bObject, context);
        if (this.getWidget() == null) {
            this.setContent(bWidget);
        } else {
            this.setReadonly(!this.isEditable());
            this.editorPane = new BPxEditorPane(this);
            this.setContent((BWidget)this.editorPane);
            this.editorPane.initSideBarPane();
            this.viewMenus = this.getPxProfile().getViewMenus(this.editorPane.getViewMenus());
            this.viewToolBar = this.getPxProfile().getViewToolBar(this.editorPane.getViewToolBar());
            this.viewStatus = this.getPxProfile().getViewStatusBarSupplement(this.editorPane.getViewStatusBarSupplement());
            this.editorPane.load(context);
        }
        this.firePxEvent(new PxEditorEvent(0));
    }

    public BObject doSaveValue(BObject bObject, Context context) {
        BObject bObject2 = null;
        if (this.isDynamic()) {
            try {
                bObject2 = ((BWbView)this.getContent()).saveValue(bObject, context);
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        } else {
            bObject2 = this.editorPane.save(bObject, context);
        }
        PxIncludeManager.trimAll();
        this.firePxEvent(new PxEditorEvent(1));
        return bObject2;
    }

    public BMenu[] getViewMenus() {
        return this.viewMenus;
    }

    public BToolBar getViewToolBar() {
        return this.viewToolBar;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.viewStatus;
    }

    public void deactivated() {
        if (this.editorPane != null) {
            this.editorPane.deactivated();
        }
    }

    public boolean isEditor() {
        return true;
    }

    public ToggleCommand getToggleMode() {
        return this.cmdToggleMode;
    }

    public PxListener[] getPxListeners() {
        return (PxListener[])this.listeners.trim();
    }

    public void addPxListener(PxListener pxListener) {
        if (!this.listeners.contains((Object)pxListener)) {
            this.listeners.add((Object)pxListener);
        }
    }

    public void removePxListener(PxListener pxListener) {
        this.listeners.remove((Object)pxListener);
    }

    public void firePxEvent(PxEvent pxEvent) {
        block1 : switch (pxEvent.getEventType()) {
            case 0: {
                switch (((PxEditorEvent)pxEvent).getEventId()) {
                    case 3: {
                        this.editorPane.updateToolbar();
                        this.editorPane.repaint();
                        break block1;
                    }
                }
                break;
            }
            case 2: {
                this.editorPane.updateToolbar();
                this.editorPane.repaint();
                break;
            }
            case 5: 
            case 6: {
                this.editorPane.getSelectedWidgets().resetHandles();
                this.editorPane.forceRootLayout();
                this.doUpdate();
                break;
            }
            case 1: {
                switch (((PxPropertyEvent)pxEvent).getEventId()) {
                    case 1: 
                    case 2: {
                        this.editorPane.getSelectedWidgets().resetHandles();
                        this.editorPane.forceRootLayout();
                        this.doUpdate();
                        break block1;
                    }
                    case 0: 
                    case 3: {
                        this.doUpdate();
                        break block1;
                    }
                }
                break;
            }
            case 8: {
                this.doUpdate();
                break;
            }
            case 3: 
            case 4: {
                switch (EventUtil.getEventType((PxComponentEvent)pxEvent)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        this.editorPane.getSelectedWidgets().resetHandles();
                        this.editorPane.forceRootLayout();
                        this.doUpdate();
                        break block1;
                    }
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.doUpdate();
                        break block1;
                    }
                }
            }
        }
        if (eventLogger.isTraceOn()) {
            eventLogger.trace(pxEvent.toString());
        }
        PxListener[] pxListenerArray = this.getPxListeners();
        for (int i = 0; i < pxListenerArray.length; ++i) {
            try {
                pxListenerArray[i].pxEvent(pxEvent);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void doUpdate() {
        this.editorPane.getCommandStudio().getPainter().reset();
        this.editorPane.updateToolbar();
        this.setModified();
        this.editorPane.repaint();
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 403: {
                this.binder = new PxEditorBinder((BWidget)this);
                return this.binder;
            }
            case 302: {
                return this.binder;
            }
            case 401: {
                return null;
            }
            case 402: {
                if (null != this.binder) {
                    this.binder.stop();
                }
                this.binder = null;
                if (this.editorPane != null) {
                    this.editorPane.saveState();
                }
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public BWidget cloneWidget(BWidget bWidget) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PxEncoder pxEncoder = new PxEncoder((OutputStream)byteArrayOutputStream);
            pxEncoder.encodeDocument(bWidget);
            pxEncoder.close();
            BWidget bWidget2 = new PxDecoder(this.getWbShell().getActiveOrd(), (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).decodeDocument();
            bWidget2.setLocation(bWidget.getX(), bWidget.getY());
            bWidget2.setSize(bWidget.getWidth(), bWidget.getHeight());
            this.forcePxIncludeLoad(bWidget2);
            BPxEditorPane.addDynamicPxIncludeProperties(bWidget2);
            return bWidget2;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private void forcePxIncludeLoad(BWidget bWidget) {
        if (bWidget instanceof BPxInclude) {
            bWidget.computePreferredSize();
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.forcePxIncludeLoad(bWidgetArray[i]);
        }
    }

    public BWidget[] cloneWidgets(BWidget[] bWidgetArray) {
        BWidget[] bWidgetArray2 = new BWidget[bWidgetArray.length];
        for (int i = 0; i < bWidgetArray.length; ++i) {
            bWidgetArray2[i] = this.cloneWidget(bWidgetArray[i]);
        }
        return bWidgetArray2;
    }

    public BPxProfile getPxProfile() {
        if (this.pxProfile == null) {
            BWbProfile bWbProfile = this.getWbShell().getProfile();
            AgentList agentList = bWbProfile.getAgents().filter(AgentFilter.is((Type)BPxProfile.TYPE));
            Class clazz = agentList.getDefault().getAgentType().getTypeSpec().getResolvedType().getTypeClass();
            try {
                Constructor constructor = clazz.getConstructor(class$javax$baja$px$editor$BPxEditor == null ? (class$javax$baja$px$editor$BPxEditor = BPxEditor.class$("javax.baja.px.editor.BPxEditor")) : class$javax$baja$px$editor$BPxEditor);
                this.pxProfile = (BPxProfile)((Object)constructor.newInstance(new Object[]{this}));
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return this.pxProfile;
    }

    public PxEditorSelection getSelection() {
        return this.editorPane.getSelectedWidgets();
    }

    public void setPxProperties(PxProperty[] pxPropertyArray) {
        this.pxProperties = pxPropertyArray;
    }

    public void setPxLayers(PxLayer[] pxLayerArray) {
        this.pxLayers = pxLayerArray;
    }

    public PxEditorController getController() {
        return this.controller;
    }

    public void setController(PxEditorController pxEditorController) {
        this.controller = pxEditorController;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PxEditorBinder
    extends Binder {
        PxEditorBinder(BWidget bWidget) {
            super(bWidget);
        }

        protected void updateBindings(ArrayList arrayList, OrdTarget ordTarget) {
            if (BPxEditor.this.editorPane != null && BPxEditorOptions.make().getAnimateBindings()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    PxEditorBinder.updateBinding((BBinding)((BBinding)arrayList.get(i)), (OrdTarget)ordTarget);
                }
                BPxEditor.this.editorPane.repaint();
            }
        }
    }
}

