/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.Reflector;
import javax.baja.nre.util.Array;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.PxEditorSelection;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.transfer.TransferEnvelope;

public class SelectedWidgets
implements PxEditorSelection {
    private static final int SEARCH_RADIUS = 3;
    private BPxEditor editor;
    private BPxEditorPane editorPane;
    private Array widgets = new Array(class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = SelectedWidgets.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget);
    static /* synthetic */ Class class$com$tridium$px$editor$util$Handle;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;

    public SelectedWidgets(BPxEditor bPxEditor, BPxEditorPane bPxEditorPane) {
        this.editor = bPxEditor;
        this.editorPane = bPxEditorPane;
    }

    public void deselectAll() {
        this.widgets.clear();
    }

    public void deselect(BWidget bWidget) {
        int n = this.lookupWidgetIndex(bWidget);
        if (n != -1) {
            this.widgets.remove(n);
        }
    }

    public void select(BWidget bWidget) {
        int n = this.lookupWidgetIndex(bWidget);
        if (n == -1) {
            this.widgets.add((Object)bWidget);
            this.checkTabbedPane((BComplex)bWidget);
        }
    }

    public void setWidgets(BWidget[] bWidgetArray) {
        this.widgets.clear();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.widgets.add((Object)bWidgetArray[i]);
            this.checkTabbedPane((BComplex)bWidgetArray[i]);
        }
    }

    public BWidget[] getWidgets() {
        return (BWidget[])this.widgets.trim();
    }

    public boolean isSelected(BWidget bWidget) {
        return this.lookupWidgetIndex(bWidget) != -1;
    }

    public Handle getHandle(double d, double d2) {
        return (Handle)this.getPointMap().get((double)((int)d), (double)((int)d2));
    }

    public BWidget get(int n) {
        return (BWidget)this.widgets.get(n);
    }

    public int size() {
        return this.widgets.size();
    }

    public Handle[] getHandlesHavingRole(Object object) {
        Object[] objectArray = this.getPointMap().getValues();
        Array array = new Array(class$com$tridium$px$editor$util$Handle == null ? (class$com$tridium$px$editor$util$Handle = SelectedWidgets.class$("com.tridium.px.editor.util.Handle")) : class$com$tridium$px$editor$util$Handle);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((Handle)objectArray[i]).role.equals(object)) continue;
            array.add(objectArray[i]);
        }
        return (Handle[])array.trim();
    }

    public boolean canSelect(BWidget bWidget) {
        if (this.widgets.size() == 0) {
            return true;
        }
        if (!Reflector.isFreeFormPane(bWidget.getParentWidget())) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getParent() == bWidget.getParent()) continue;
            return false;
        }
        return true;
    }

    public void resetHandles() {
    }

    private int lookupWidgetIndex(BWidget bWidget) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            if (bWidget != this.widgets.get(i)) continue;
            return i;
        }
        return -1;
    }

    private PointMap getPointMap() {
        PointMap pointMap = new PointMap(3);
        if (this.editor.isReadonly()) {
            return pointMap;
        }
        Artisan artisan = Artisan.instance();
        for (int i = 0; i < this.widgets.size(); ++i) {
            artisan.addHandles(this.editorPane.getTrackerStudio(), this.get(i), pointMap);
        }
        return pointMap;
    }

    private void checkTabbedPane(BComplex bComplex) {
        while (bComplex != null && bComplex instanceof BWidget) {
            BComplex bComplex2;
            if (bComplex instanceof BLabelPane && (bComplex2 = bComplex.getParent()) instanceof BTabbedPane) {
                ((BTabbedPane)bComplex2).selectLabelPane((BLabelPane)bComplex);
                this.editorPane.forceRootLayout();
                return;
            }
            bComplex = bComplex.getParent();
        }
    }

    public TransferEnvelope envelope() throws Exception {
        if (this.size() == 0) {
            return null;
        }
        BWidget[] bWidgetArray = new BWidget[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            bWidgetArray[i] = this.editor.cloneWidget(this.get(i));
        }
        return TransferEnvelope.make((Mark)new Mark((BObject[])bWidgetArray));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

