/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.px.editor.BPxEditorPane;
import javax.baja.chart.BChartPane;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BBinding;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BConverter;
import javax.baja.util.Lexicon;

public abstract class Reflector {
    static /* synthetic */ Class class$javax$baja$sys$Property;
    static /* synthetic */ Class class$javax$baja$ui$BBinding;

    public static boolean isDroppable(BWidget bWidget) {
        if (Reflector.isLeaf(bWidget)) {
            return false;
        }
        if (Reflector.isFreeFormPane(bWidget)) {
            return true;
        }
        if (bWidget instanceof BBorderPane) {
            BBorderPane bBorderPane = (BBorderPane)bWidget;
            return bBorderPane.getContent() instanceof BNullWidget;
        }
        if (bWidget instanceof BEdgePane) {
            BEdgePane bEdgePane = (BEdgePane)bWidget;
            return bEdgePane.getCenter() instanceof BNullWidget;
        }
        return false;
    }

    public static boolean isLeaf(BWidget bWidget) {
        return !(bWidget instanceof BPane);
    }

    public static boolean isFreeFormPane(BWidget bWidget) {
        if (!(bWidget instanceof BPane)) {
            return false;
        }
        if (bWidget instanceof BTabbedPane) {
            return true;
        }
        if (bWidget instanceof BChartPane) {
            return true;
        }
        if (bWidget.getType().toString().equals("report:ReportPane")) {
            return true;
        }
        try {
            if (bWidget.getType().is(Sys.getType((String)"mobile:IMobilePane"))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            BPane bPane = (BPane)bWidget.getClass().newInstance();
            BWidget[] bWidgetArray = bPane.getChildWidgets();
            return bWidgetArray.length == 0;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static BConverter converter(String string, BBinding[] bBindingArray) {
        for (int i = 0; i < bBindingArray.length; ++i) {
            BValue bValue = bBindingArray[i].get(string);
            if (bValue == null || !(bValue instanceof BConverter)) continue;
            return (BConverter)bValue;
        }
        return null;
    }

    public static BComplex cloneFrozen(BComplex bComplex) {
        try {
            BComplex bComplex2 = (BComplex)bComplex.getClass().newInstance();
            bComplex2.copyFrom(bComplex);
            return bComplex2;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static Property[] dynamicProperties(BComponent bComponent) {
        Array array = new Array(class$javax$baja$sys$Property == null ? (class$javax$baja$sys$Property = Reflector.class$("javax.baja.sys.Property")) : class$javax$baja$sys$Property);
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            if (!property.isDynamic()) continue;
            array.add((Object)property);
        }
        return (Property[])array.trim();
    }

    public static BCanvasPane canvas(BWidget bWidget) {
        if (bWidget == null) {
            return null;
        }
        while (!(bWidget instanceof BCanvasPane)) {
            if ((bWidget = bWidget.getParentWidget()) != null) continue;
            return null;
        }
        return (BCanvasPane)bWidget;
    }

    public static BMenu optionsMenu(BTable bTable) {
        BMenu bMenu = new BMenu();
        bMenu.add("resizeColumns", (Command)new OptionsMenu(bTable));
        return bMenu;
    }

    public static String displayName(BComplex bComplex, boolean bl) {
        return Reflector.displayName(bComplex, TextUtil.getClassName(bComplex.getClass()).substring(1), bl);
    }

    public static String displayName(BComplex bComplex, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl) {
            Property property = bComplex.getPropertyInParent();
            if (property != null && property.isFrozen()) {
                Reflector.paren(stringBuffer, bComplex.getDisplayName(null));
            }
            if (bComplex instanceof BComponent) {
                BComponent bComponent = (BComponent)bComplex;
                BBinding[] bBindingArray = (BBinding[])bComponent.getChildren(class$javax$baja$ui$BBinding == null ? (class$javax$baja$ui$BBinding = Reflector.class$("javax.baja.ui.BBinding")) : class$javax$baja$ui$BBinding);
                if (bBindingArray.length == 0) {
                    BPxInclude bPxInclude;
                    if (bComponent instanceof BLabel) {
                        BLabel bLabel = (BLabel)bComponent;
                        if (!bLabel.getText().equals("")) {
                            Reflector.paren(stringBuffer, bLabel.getText());
                        } else if (!bLabel.getImage().isNull()) {
                            Reflector.paren(stringBuffer, bLabel.getImage().getOrdList().toString());
                        }
                    } else if (bComponent instanceof BPxInclude && !(bPxInclude = (BPxInclude)bComponent).getOrd().isNull()) {
                        Reflector.brace(stringBuffer, bPxInclude.getOrd().toString());
                    }
                } else {
                    Reflector.brace(stringBuffer, bBindingArray[0].getOrd().toString());
                }
            }
        }
        return stringBuffer.toString();
    }

    private static StringBuffer paren(StringBuffer stringBuffer, String string) {
        stringBuffer.append(" (").append(string).append(")");
        return stringBuffer;
    }

    private static StringBuffer brace(StringBuffer stringBuffer, String string) {
        stringBuffer.append(" [").append(string).append("]");
        return stringBuffer;
    }

    public static boolean mediaWarning(BWidget bWidget, TypeInfo[] typeInfoArray) {
        if (typeInfoArray.length == 1) {
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setTop((BWidget)new BBorderPane((BWidget)new BLabel(Reflector.text("unsupportedType", typeInfoArray), BHalign.left), 0.0, 0.0, 0.0, 0.0));
            bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)new BLabel(Reflector.text("unsupportedTypeAddAnyway"), BHalign.left), 5.0, 0.0, 0.0, 0.0));
            return BDialog.open((BWidget)bWidget, (String)Reflector.text("unsupportedTypeTitle"), (Object)new BBorderPane((BWidget)bEdgePane), (int)12, (BImage)BDialog.WARNING_ICON) == 4;
        }
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        for (int i = 0; i < typeInfoArray.length; ++i) {
            bGridPane.add(null, (BValue)new BLabel("    " + typeInfoArray[i].toString(), BHalign.left));
        }
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)new BLabel(Reflector.text("unsupportedTypes"), BHalign.left), 0.0, 0.0, 5.0, 0.0));
        bEdgePane.setCenter((BWidget)bGridPane);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)new BLabel(Reflector.text("unsupportedTypesAddAnyway"), BHalign.left), 5.0, 0.0, 0.0, 0.0));
        return BDialog.open((BWidget)bWidget, (String)Reflector.text("unsupportedTypesTitle"), (Object)new BBorderPane((BWidget)bEdgePane), (int)12, (BImage)BDialog.WARNING_ICON) == 4;
    }

    private static String text(String string) {
        return BPxEditorPane.text("media." + string);
    }

    private static String text(String string, Object[] objectArray) {
        return BPxEditorPane.lexicon().getText("media." + string, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class OptionsMenu
    extends Command {
        BTable table;

        OptionsMenu(BTable bTable) {
            super((BWidget)bTable, (Lexicon)UiLexicon.bajaui, "commands.table.resizeColumns");
            this.table = bTable;
        }

        public CommandArtifact doInvoke() {
            this.table.sizeColumnsToFit();
            return null;
        }
    }
}

