/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.util.ClassUtil;
import javax.baja.px.editor.event.PxBindingEvent;
import javax.baja.px.editor.event.PxComponentEvent;
import javax.baja.px.editor.event.PxCompoundBindingEvent;
import javax.baja.px.editor.event.PxCompoundWidgetEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxWidgetEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.util.BConverter;

public abstract class EventUtil {
    public static final int UNKNOWN = 0;
    public static final int WIDGET_ADDED = 1;
    public static final int WIDGET_REMOVED = 2;
    public static final int WIDGET_CHANGED = 3;
    public static final int WIDGET_RENAMED = 4;
    public static final int WIDGET_REPLACED = 5;
    public static final int WIDGET_REORDERED = 6;
    public static final int BINDING_ADDED = 7;
    public static final int BINDING_CHANGED = 8;
    public static final int BINDING_REMOVED = 9;
    public static final int CONVERTER_ADDED = 10;
    public static final int CONVERTER_CHANGED = 11;
    public static final int CONVERTER_REMOVED = 12;
    private static String[] ID_STRINGS = new String[]{"UNKNOWN", "WIDGET_ADDED", "WIDGET_REMOVED", "WIDGET_CHANGED", "WIDGET_RENAMED", "WIDGET_REPLACED", "WIDGET_REORDERED", "BINDING_ADDED", "BINDING_CHANGED", "BINDING_REMOVED", "CONVERTER_ADDED", "CONVERTER_CHANGED", "CONVERTER_REMOVED"};

    public static int getEventType(PxComponentEvent pxComponentEvent) {
        int n = pxComponentEvent.getEventId();
        if (pxComponentEvent instanceof PxWidgetEvent) {
            if (n == 4) {
                return 6;
            }
            if (n == 3) {
                return 4;
            }
            Type type = ClassUtil.getCommonSuperType((BObject[])pxComponentEvent.getValues());
            if (type.is(BBinding.TYPE)) {
                switch (n) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 9;
                    }
                }
            } else if (type.is(BWidget.TYPE)) {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                }
            } else if (n == 2) {
                return 3;
            }
        } else if (pxComponentEvent instanceof PxBindingEvent) {
            Type type = ClassUtil.getCommonSuperType((BObject[])pxComponentEvent.getValues());
            if (type.is(BConverter.TYPE)) {
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                    case 1: {
                        return 12;
                    }
                }
            } else if (n == 2) {
                return 8;
            }
        }
        return 0;
    }

    public static PxEvent widgetsChanged(BWidget[] bWidgetArray, String string) {
        String[] stringArray = new String[bWidgetArray.length];
        for (int i = 0; i < bWidgetArray.length; ++i) {
            stringArray[i] = string;
        }
        return EventUtil.widgetsChanged(bWidgetArray, stringArray);
    }

    public static PxEvent widgetsChanged(BWidget[] bWidgetArray, String[] stringArray) {
        if (bWidgetArray.length != stringArray.length) {
            throw new IllegalStateException();
        }
        if (bWidgetArray.length == 1) {
            return new PxWidgetEvent(2, bWidgetArray[0], stringArray[0], bWidgetArray[0].get(stringArray[0]));
        }
        PxWidgetEvent[] pxWidgetEventArray = new PxWidgetEvent[bWidgetArray.length];
        for (int i = 0; i < pxWidgetEventArray.length; ++i) {
            pxWidgetEventArray[i] = new PxWidgetEvent(2, bWidgetArray[i], stringArray[i], bWidgetArray[i].get(stringArray[i]));
        }
        return new PxCompoundWidgetEvent(2, pxWidgetEventArray);
    }

    public static PxEvent bindingsChanged(BBinding[] bBindingArray, String[] stringArray) {
        if (bBindingArray.length != stringArray.length) {
            throw new IllegalStateException();
        }
        if (bBindingArray.length == 1) {
            return new PxBindingEvent(2, bBindingArray[0], stringArray[0], bBindingArray[0].get(stringArray[0]));
        }
        PxBindingEvent[] pxBindingEventArray = new PxBindingEvent[bBindingArray.length];
        for (int i = 0; i < pxBindingEventArray.length; ++i) {
            pxBindingEventArray[i] = new PxBindingEvent(2, bBindingArray[i], stringArray[i], bBindingArray[i].get(stringArray[i]));
        }
        return new PxCompoundBindingEvent(2, pxBindingEventArray);
    }
}

