/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.gx.util.GeomUtil;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.artisans.ArtisanRouter;
import com.tridium.px.editor.studio.artisans.RectangularArtisan;
import com.tridium.px.editor.studio.commands.MorphWidget;
import com.tridium.px.editor.studio.painters.DefaultPainter;
import com.tridium.px.editor.studio.painters.GeomPainter;
import com.tridium.px.editor.studio.trackers.GeomSupplier;
import com.tridium.px.editor.studio.trackers.HandleTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.studio.trackers.UnpressedTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.Geom;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.Array;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.event.BMouseEvent;

public class RectangularHandleTracker
extends HandleTracker
implements GeomSupplier {
    private boolean dragged = false;
    private RectangularArtisan artisan;
    private boolean preserveAspectRatio;
    private RectangularHandleTracker[] friendly;
    private Geom[] geoms;

    public static RectangularHandleTracker make(BPxEditorPane bPxEditorPane, Handle handle, RectangularArtisan rectangularArtisan, boolean bl) {
        return new RectangularHandleTracker(bPxEditorPane, handle, rectangularArtisan, true, bl);
    }

    private RectangularHandleTracker(BPxEditorPane bPxEditorPane, Handle handle, RectangularArtisan rectangularArtisan, boolean bl, boolean bl2) {
        super(bPxEditorPane, handle);
        this.artisan = rectangularArtisan;
        this.preserveAspectRatio = bl2;
        if (bl) {
            Object[] objectArray = bPxEditorPane.getSelectedWidgets().getHandlesHavingRole(handle.role);
            Array array = new Array(objectArray);
            array.remove((Object)handle);
            objectArray = (Handle[])array.trim();
            this.friendly = new RectangularHandleTracker[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.friendly[i] = new RectangularHandleTracker(bPxEditorPane, (Handle)objectArray[i], (RectangularArtisan)ArtisanRouter.artisan(((Handle)objectArray[i]).widget), false, bl2);
            }
            this.geoms = new Geom[this.friendly.length + 1];
        } else {
            this.geoms = new Geom[1];
            this.friendly = new RectangularHandleTracker[0];
        }
    }

    public Geom[] geoms() {
        this.geoms[0] = this.geom();
        for (int i = 0; i < this.friendly.length; ++i) {
            this.geoms[i + 1] = this.friendly[i].geom();
        }
        return this.geoms;
    }

    private Geom geom() {
        RectGeom rectGeom = this.artisan.bounds(this.handle.widget);
        this.applyDelta(rectGeom);
        return GeomUtil.makeRectangle((double)rectGeom.x, (double)rectGeom.y, (double)(rectGeom.x + rectGeom.width), (double)(rectGeom.y + rectGeom.height));
    }

    private void applyDelta(RectGeom rectGeom) {
        double d = rectGeom.width;
        double d2 = rectGeom.height;
        if (this.handle.cursor == MouseCursor.eResize) {
            rectGeom.width += this.delta.x;
            if (this.preserveAspectRatio && d != 0.0) {
                rectGeom.height *= rectGeom.width / d;
            }
        } else if (this.handle.cursor == MouseCursor.wResize) {
            rectGeom.width -= this.delta.x;
            rectGeom.x += this.delta.x;
            if (this.preserveAspectRatio && d != 0.0) {
                rectGeom.height *= rectGeom.width / d;
            }
        } else if (this.handle.cursor == MouseCursor.sResize) {
            rectGeom.height += this.delta.y;
            if (this.preserveAspectRatio && d2 != 0.0) {
                rectGeom.width *= rectGeom.height / d2;
            }
        } else if (this.handle.cursor == MouseCursor.nResize) {
            rectGeom.height -= this.delta.y;
            rectGeom.y += this.delta.y;
            if (this.preserveAspectRatio && d2 != 0.0) {
                rectGeom.width *= rectGeom.height / d2;
            }
        } else if (this.handle.cursor == MouseCursor.nwResize) {
            rectGeom.height -= this.delta.y;
            rectGeom.width -= this.delta.x;
            this.applyAspectToCorner(rectGeom, d, d2);
            rectGeom.y += d2 - rectGeom.height;
            rectGeom.x += d - rectGeom.width;
        } else if (this.handle.cursor == MouseCursor.neResize) {
            rectGeom.height -= this.delta.y;
            rectGeom.width += this.delta.x;
            this.applyAspectToCorner(rectGeom, d, d2);
            rectGeom.y += d2 - rectGeom.height;
        } else if (this.handle.cursor == MouseCursor.swResize) {
            rectGeom.height += this.delta.y;
            rectGeom.width -= this.delta.x;
            this.applyAspectToCorner(rectGeom, d, d2);
            rectGeom.x += d - rectGeom.width;
        } else if (this.handle.cursor == MouseCursor.seResize) {
            rectGeom.height += this.delta.y;
            rectGeom.width += this.delta.x;
            this.applyAspectToCorner(rectGeom, d, d2);
        }
    }

    private void applyAspectToCorner(RectGeom rectGeom, double d, double d2) {
        if (this.preserveAspectRatio && d2 != 0.0 && rectGeom.height != 0.0) {
            double d3 = d / d2;
            double d4 = rectGeom.width / rectGeom.height;
            if (d3 > d4) {
                if (d != 0.0) {
                    rectGeom.height = d2 * rectGeom.width / d;
                }
            } else if (d3 < d4) {
                rectGeom.width = d * rectGeom.height / d2;
            }
        }
    }

    public Tracker mouseDragged(BMouseEvent bMouseEvent) {
        this.setAllDeltas(bMouseEvent);
        if (!this.dragged && this.moved(bMouseEvent)) {
            this.dragged = true;
            this.studio.setPainter(new GeomPainter(this.editorPane.getPainterStudio(), this, this.canvas.getScaleTransform(), this.studio.translateToRoot((BWidget)this.canvas, new Point(0.0, 0.0))));
        }
        this.editorPane.repaint();
        return this;
    }

    public Tracker mouseReleased(BMouseEvent bMouseEvent) {
        if (this.dragged) {
            this.dragged = false;
            this.setAllDeltas(bMouseEvent);
            if (this.friendly.length == 0) {
                this.morphWidget().invoke();
            } else {
                Command[] commandArray = new Command[this.friendly.length + 1];
                commandArray[0] = this.morphWidget();
                for (int i = 0; i < this.friendly.length; ++i) {
                    commandArray[i + 1] = this.friendly[i].morphWidget();
                }
                new CompoundCommand((BWidget)this.editorPane, "morph", commandArray).invoke();
            }
            this.studio.setPainter(new DefaultPainter(this.editorPane.getPainterStudio()));
            this.editorPane.repaint();
        }
        return new UnpressedTracker(this.editorPane);
    }

    private void setAllDeltas(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        this.setDelta(d, d2);
        for (int i = 0; i < this.friendly.length; ++i) {
            this.friendly[i].setDelta(d + (this.friendly[i].anchor.x - this.anchor.x), d2 + (this.friendly[i].anchor.y - this.anchor.y));
        }
    }

    private MorphWidget morphWidget() {
        return new MorphWidget(this.editorPane, this.handle.widget, (IGeom)this.artisan.bounds(this.handle.widget), (IGeom)this.geoms()[0], this.artisan);
    }
}

