/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.commands.MoveWidget;
import com.tridium.px.editor.studio.painters.DefaultPainter;
import com.tridium.px.editor.studio.painters.MovePainter;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.studio.trackers.UnpressedTracker;
import javax.baja.gx.BSize;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;

public class MoveTracker
extends Tracker {
    private TrackerStudio studio;
    private boolean dragged = false;
    private BCanvasPane canvas;
    private BWidget[] widgets;
    private BSize viewBox;
    private Point anchor;
    private RectGeom origBounds;
    private RectGeom moveRect;

    public MoveTracker(BPxEditorPane bPxEditorPane, BCanvasPane bCanvasPane, BWidget[] bWidgetArray) {
        super(bPxEditorPane);
        this.studio = bPxEditorPane.getTrackerStudio();
        this.studio.setMouseCursor(MouseCursor.move);
        this.canvas = bCanvasPane;
        this.viewBox = bCanvasPane.getViewSize();
        this.widgets = bWidgetArray;
        Artisan artisan = Artisan.instance();
        this.origBounds = Artisan.boundsUnion(artisan, bWidgetArray);
        this.moveRect = new RectGeom((IRectGeom)this.origBounds);
        this.anchor = this.studio.toViewbox(MoveTracker.getAnchorX(), MoveTracker.getAnchorY(), bCanvasPane);
    }

    public IGeom[] geoms() {
        double d = this.moveRect.x - this.origBounds.x;
        double d2 = this.moveRect.y - this.origBounds.y;
        Artisan artisan = Artisan.instance();
        IGeom[] iGeomArray = new IGeom[this.widgets.length];
        for (int i = 0; i < this.widgets.length; ++i) {
            iGeomArray[i] = artisan.translateGeom(this.widgets[i], d, d2);
        }
        return iGeomArray;
    }

    void setDelta(BMouseEvent bMouseEvent) {
        Point point = this.studio.toViewbox(bMouseEvent.getX(), bMouseEvent.getY(), this.canvas);
        double d = point.x - this.anchor.x;
        double d2 = point.y - this.anchor.y;
        this.moveRect = new RectGeom((IRectGeom)this.origBounds);
        this.moveRect.x += d;
        this.moveRect.y += d2;
        if (this.moveRect.x < 0.0) {
            this.moveRect.x = 0.0;
        } else if (this.moveRect.x + this.moveRect.width > this.viewBox.width) {
            this.moveRect.x = this.viewBox.width - this.moveRect.width;
        }
        if (this.moveRect.y < 0.0) {
            this.moveRect.y = 0.0;
        } else if (this.moveRect.y + this.moveRect.height > this.viewBox.height) {
            this.moveRect.y = this.viewBox.height - this.moveRect.height;
        }
        Point point2 = this.studio.snap(this.moveRect.x, this.moveRect.y);
        this.moveRect.x = point2.x;
        this.moveRect.y = point2.y;
    }

    public Tracker mouseDragged(BMouseEvent bMouseEvent) {
        if (!this.dragged && this.moved(bMouseEvent)) {
            this.dragged = true;
            this.studio.setPainter(new MovePainter(this.editorPane.getPainterStudio(), this, this.canvas.getScaleTransform(), this.studio.translateToRoot((BWidget)this.canvas, new Point(0.0, 0.0))));
        }
        this.setDelta(bMouseEvent);
        this.editorPane.repaint();
        return this;
    }

    public Tracker mouseReleased(BMouseEvent bMouseEvent) {
        if (this.dragged) {
            this.dragged = false;
            this.setDelta(bMouseEvent);
            new MoveWidget(this.editorPane, this.widgets, this.moveRect.x - this.origBounds.x, this.moveRect.y - this.origBounds.y).invoke();
            this.studio.setPainter(new DefaultPainter(this.editorPane.getPainterStudio()));
            this.editorPane.repaint();
        }
        return new UnpressedTracker(this.editorPane);
    }
}

