/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.artisans.LineArtisan;
import com.tridium.px.editor.studio.trackers.GeomSupplier;
import com.tridium.px.editor.studio.trackers.ShapeHandleTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.BLineGeom;
import javax.baja.gx.BSize;
import javax.baja.gx.Geom;
import javax.baja.gx.LineGeom;
import javax.baja.gx.Point;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.shape.BLine;

public class LineHandleTracker
extends ShapeHandleTracker
implements GeomSupplier {
    private Point here;
    private Point there;

    public LineHandleTracker(BPxEditorPane bPxEditorPane, Handle handle, LineArtisan lineArtisan) {
        super(bPxEditorPane, handle, lineArtisan);
        BLine bLine = (BLine)handle.widget;
        BLineGeom bLineGeom = bLine.getGeom();
        switch ((Integer)handle.role) {
            case 1: {
                this.here = new Point(bLineGeom.x1, bLineGeom.y1);
                this.there = new Point(bLineGeom.x2, bLineGeom.y2);
                break;
            }
            case 2: {
                this.there = new Point(bLineGeom.x1, bLineGeom.y1);
                this.here = new Point(bLineGeom.x2, bLineGeom.y2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public Geom[] geoms() {
        double d = this.here.x + this.delta.x;
        double d2 = this.here.y + this.delta.y;
        BCanvasPane bCanvasPane = (BCanvasPane)this.handle.widget.getParent();
        BSize bSize = bCanvasPane.getViewSize();
        if (d < 0.0) {
            d = 0.0;
        } else if (d > bSize.width) {
            d = bSize.width;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > bSize.height) {
            d2 = bSize.height;
        }
        return new Geom[]{new LineGeom(d, d2, this.there.x, this.there.y)};
    }
}

