/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.painters.MovePainter;
import com.tridium.px.editor.studio.trackers.MoveTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.studio.trackers.UnpressedTracker;
import com.tridium.px.editor.util.Reflector;
import javax.baja.gx.Point;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;

public class HitSelectedTracker
extends Tracker {
    private TrackerStudio studio;
    private BWidget widget;

    public HitSelectedTracker(BPxEditorPane bPxEditorPane, BWidget bWidget) {
        super(bPxEditorPane);
        this.studio = bPxEditorPane.getTrackerStudio();
        this.widget = bWidget;
    }

    public Tracker mouseDragged(BMouseEvent bMouseEvent) {
        if (this.editor.isReadonly()) {
            return this;
        }
        if (!this.editorPane.getLayerManager().isNormal(this.widget)) {
            return this;
        }
        if (!this.moved(bMouseEvent)) {
            return this;
        }
        BWidget bWidget = this.widget.getParentWidget();
        BCanvasPane bCanvasPane = Reflector.canvas(bWidget);
        if (bCanvasPane == null) {
            return this;
        }
        MoveTracker moveTracker = UnpressedTracker.makeMoveTracker(this.editorPane, bCanvasPane, bWidget);
        this.studio.setPainter(new MovePainter(this.editorPane.getPainterStudio(), moveTracker, bCanvasPane.getScaleTransform(), this.studio.translateToRoot((BWidget)bCanvasPane, new Point(0.0, 0.0))));
        this.editorPane.repaint();
        return moveTracker;
    }

    public Tracker mouseReleased(BMouseEvent bMouseEvent) {
        BWidget[] bWidgetArray = this.studio.rootDescendants(new Point(bMouseEvent.getX(), bMouseEvent.getY()));
        if (bWidgetArray == null) {
            throw new IllegalStateException();
        }
        if (bWidgetArray.length == 0) {
            throw new IllegalStateException();
        }
        if (bMouseEvent.isControlDown()) {
            this.editorPane.getSelectedWidgets().deselect(this.widget);
        } else {
            this.editorPane.getSelectedWidgets().deselectAll();
            this.editorPane.getSelectedWidgets().select(this.widget);
        }
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        return new UnpressedTracker(this.editorPane);
    }
}

