/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.gx.util.GeomUtil;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.PathArtisan;
import com.tridium.px.editor.studio.artisans.PolygonArtisan;
import com.tridium.px.editor.studio.commands.MorphWidget;
import com.tridium.px.editor.studio.painters.PointPainter;
import com.tridium.px.editor.studio.trackers.GeometryTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.Reflector;
import com.tridium.px.editor.util.SelectedWidgets;
import java.lang.reflect.Method;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.shape.BPath;
import javax.baja.ui.shape.BPolygon;

public class AddPointTracker
extends GeometryTracker {
    private SelectedWidgets selected;
    private TrackerStudio studio;

    public AddPointTracker(BPxEditorPane bPxEditorPane, TrackerStudio trackerStudio) {
        super(bPxEditorPane);
        this.studio = trackerStudio;
        this.selected = bPxEditorPane.getSelectedWidgets();
        this.selected.deselectAll();
        trackerStudio.setPainter(new PointPainter(bPxEditorPane.getPainterStudio(), this.selected));
        this.selectShapes(this.selected, (BWidget)bPxEditorPane.getRootContainer());
        bPxEditorPane.repaint();
    }

    public Tracker mousePressed(BMouseEvent bMouseEvent) {
        double d;
        if (bMouseEvent.getClickCount() != 1 || !bMouseEvent.isButton1Down()) {
            return this;
        }
        double d2 = bMouseEvent.getX();
        Handle handle = this.selected.getHandle(d2, d = bMouseEvent.getY());
        if (handle == null) {
            BWidget bWidget = this.studio.rootDescendant(new Point(d2, d));
            if (bWidget instanceof BPath || bWidget instanceof BPolygon) {
                this.addPoint(d2, d, bWidget);
            }
        } else {
            if (!(handle.widget instanceof BPath) && !(handle.widget instanceof BPolygon)) {
                throw new IllegalStateException();
            }
            this.addPoint(d2, d, handle.widget);
        }
        this.editorPane.repaint();
        return this;
    }

    private void addPoint(double d, double d2, BWidget bWidget) {
        Point point = this.studio.toViewbox(d, d2, Reflector.canvas(bWidget));
        if (bWidget instanceof BPath) {
            BPath bPath = (BPath)bWidget;
            BPathGeom bPathGeom = bPath.getGeom();
            Object[] objectArray = bPathGeom.segments();
            Point[] pointArray = this.toPoints((IPathGeom.Segment[])objectArray);
            int n = GeomUtil.nearest((Point)point, (Point[])pointArray, (boolean)false);
            Array array = new Array(objectArray);
            array.add(n + 1, (Object)new IPathGeom.LineTo(true, point.x, point.y));
            objectArray = (IPathGeom.Segment[])array.trim();
            bPathGeom = BPathGeom.make((IPathGeom.Segment[])objectArray);
            new MorphWidget(this.editorPane, (BWidget)bPath, (IGeom)bPath.getGeom(), (IGeom)bPathGeom, new PathArtisan()).invoke();
        } else if (bWidget instanceof BPolygon) {
            BPolygon bPolygon = (BPolygon)bWidget;
            BPolygonGeom bPolygonGeom = bPolygon.getGeom();
            Object[] objectArray = this.toPoints(bPolygonGeom);
            int n = GeomUtil.nearest((Point)point, (Point[])objectArray, (boolean)true);
            Array array = new Array(objectArray);
            if (n == objectArray.length - 1) {
                array.add((Object)point);
            } else {
                array.add(n + 1, (Object)point);
            }
            objectArray = (Point[])array.trim();
            bPolygonGeom = this.fromPoints((Point[])objectArray);
            new MorphWidget(this.editorPane, (BWidget)bPolygon, (IGeom)bPolygon.getGeom(), (IGeom)bPolygonGeom, new PolygonArtisan()).invoke();
        } else {
            throw new IllegalStateException();
        }
    }

    private BPolygonGeom fromPoints(Point[] pointArray) {
        double[] dArray = new double[pointArray.length];
        double[] dArray2 = new double[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            dArray[i] = pointArray[i].x;
            dArray2[i] = pointArray[i].y;
        }
        return BPolygonGeom.make((double[])dArray, (double[])dArray2);
    }

    private Point[] toPoints(BPolygonGeom bPolygonGeom) {
        Point[] pointArray = new Point[bPolygonGeom.size()];
        for (int i = 0; i < bPolygonGeom.size(); ++i) {
            pointArray[i] = new Point(bPolygonGeom.x(i), bPolygonGeom.y(i));
        }
        return pointArray;
    }

    private Point[] toPoints(IPathGeom.Segment[] segmentArray) {
        Point[] pointArray = new Point[segmentArray.length];
        for (int i = 0; i < segmentArray.length; ++i) {
            try {
                Class<?> clazz = segmentArray[i].getClass();
                Method method = clazz.getMethod("getX", null);
                Method method2 = clazz.getMethod("getY", null);
                double d = (Double)method.invoke((Object)segmentArray[i], null);
                double d2 = (Double)method2.invoke((Object)segmentArray[i], null);
                pointArray[i] = new Point(d, d2);
                continue;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return pointArray;
    }
}

