/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.painters;

import com.tridium.px.editor.studio.PainterStudio;
import com.tridium.px.editor.studio.painters.Painter;
import com.tridium.px.editor.studio.trackers.MoveTracker;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;

public class MovePainter
extends Painter {
    private PainterStudio studio;
    private MoveTracker tracker;
    private BTransform scaleTransform;
    private Point pageOffset;

    public MovePainter(PainterStudio painterStudio, MoveTracker moveTracker, BTransform bTransform, Point point) {
        this.studio = painterStudio;
        this.tracker = moveTracker;
        this.scaleTransform = bTransform;
        this.pageOffset = point;
        painterStudio.buffer();
    }

    public synchronized void doPaint(Graphics graphics) {
        this.studio.paintBuffer(graphics);
        graphics.setBrush(BColor.black);
        graphics.setPen(BPen.DEFAULT);
        graphics.translate(this.pageOffset.x, this.pageOffset.y);
        graphics.transform(this.scaleTransform);
        IGeom[] iGeomArray = this.tracker.geoms();
        for (int i = 0; i < iGeomArray.length; ++i) {
            graphics.stroke(iGeomArray[i]);
        }
        graphics.transform(this.scaleTransform.getInverse());
        graphics.translate(-this.pageOffset.x, -this.pageOffset.y);
    }
}

