/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.painters;

import com.tridium.px.editor.studio.PainterStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.painters.Painter;
import com.tridium.px.editor.studio.trackers.AddGeometryTracker;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Geom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;

public class AddGeometryPainter
extends Painter {
    private PainterStudio studio;
    private AddGeometryTracker tracker;

    public AddGeometryPainter(PainterStudio painterStudio, AddGeometryTracker addGeometryTracker) {
        this.studio = painterStudio;
        this.tracker = addGeometryTracker;
        painterStudio.buffer();
    }

    public synchronized void doPaint(Graphics graphics) {
        int n;
        this.studio.paintBuffer(graphics);
        if (this.tracker.pageOffset == null || this.tracker.scaleTransform == null) {
            return;
        }
        graphics.setBrush(BColor.black);
        graphics.setPen(BPen.DEFAULT);
        graphics.translate(this.tracker.pageOffset.x, this.tracker.pageOffset.y);
        graphics.transform(this.tracker.scaleTransform);
        Geom[] geomArray = this.tracker.geoms();
        for (int i = 0; i < geomArray.length; ++i) {
            if (geomArray[i] == null) continue;
            graphics.stroke((IGeom)geomArray[i]);
        }
        graphics.transform(this.tracker.scaleTransform.getInverse());
        graphics.translate(-this.tracker.pageOffset.x, -this.tracker.pageOffset.y);
        Point[] pointArray = this.tracker.handles();
        Point[] pointArray2 = this.tracker.bars();
        Artisan.smallHandles();
        for (n = 0; n < pointArray2.length; ++n) {
            if (pointArray2[n] == null) continue;
            Point point = pointArray[n];
            Point point2 = pointArray2[n];
            double d = point2.x - point.x;
            double d2 = point2.y - point.y;
            Point point3 = new Point(point.x - d, point.y - d2);
            graphics.setBrush(BColor.fuchsia);
            graphics.strokeLine(point.x, point.y, point2.x, point2.y);
            graphics.strokeLine(point.x, point.y, point3.x, point3.y);
            Artisan.paintHandle(graphics, BColor.fuchsia, point2.x, point2.y);
            Artisan.paintHandle(graphics, BColor.fuchsia, point3.x, point3.y);
        }
        for (n = 0; n < pointArray.length; ++n) {
            Artisan.paintHandle(graphics, BColor.lime, pointArray[n].x, pointArray[n].y);
        }
        Artisan.largeHandles();
    }

    public void reset() {
        this.studio.unbuffer();
        this.studio.buffer();
    }
}

