/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.commands;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.util.EventUtil;
import java.util.Comparator;
import javax.baja.nre.util.SortUtil;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

public class Distribute
extends Command {
    private BPxEditorPane editorPane;
    private int type;
    private Artisan artisan = Artisan.instance();
    private BWidget[] widgets;
    private double[] deltaX;
    private double[] deltaY;
    public static final int HORIZ = 0;
    public static final int VERT = 1;

    public Distribute(BPxEditorPane bPxEditorPane, int n) {
        super((BWidget)bPxEditorPane, BPxEditorPane.lexicon(), n == 0 ? "commands.distribute.horizontal" : "commands.distribute.vertical");
        this.editorPane = bPxEditorPane;
        this.type = n;
    }

    public CommandArtifact doInvoke() throws Exception {
        double d;
        this.widgets = this.editorPane.getSelectedWidgets().getWidgets();
        int n = this.widgets.length;
        this.deltaX = new double[n];
        this.deltaY = new double[n];
        if (this.type == 0) {
            d = 0.0;
            BWidget bWidget = null;
            BWidget bWidget2 = null;
            for (int i = 0; i < n; ++i) {
                if (bWidget2 == null || bWidget2.getX() > this.widgets[i].getX()) {
                    bWidget2 = this.widgets[i];
                }
                if (bWidget == null || bWidget.getX() + bWidget.getWidth() < this.widgets[i].getX() + this.widgets[i].getWidth()) {
                    bWidget = this.widgets[i];
                }
                d += this.widgets[i].getWidth();
            }
            double d2 = bWidget.getX() + bWidget.getWidth() - bWidget2.getX();
            double d3 = (d2 - d) / (double)(n - 1);
            SortUtil.sort((Object[])this.widgets, (Object[])this.widgets, (Comparator)new Comparator(){

                public int compare(Object object, Object object2) {
                    return Double.compare(((BWidget)object).getX(), ((BWidget)object2).getX());
                }
            });
            if (this.widgets[0].getX() > this.widgets[n - 1].getX()) {
                double d4 = bWidget.getX() + bWidget.getWidth();
                for (int i = 0; i < n; ++i) {
                    this.deltaX[i] = Math.round((float)(d4 - (this.widgets[i].getX() + this.widgets[i].getWidth())));
                    d4 -= this.widgets[i].getWidth() + d3;
                }
            } else {
                double d5 = bWidget2.getX();
                for (int i = 0; i < n; ++i) {
                    this.deltaX[i] = Math.round((float)(d5 - this.widgets[i].getX()));
                    d5 += this.widgets[i].getWidth() + d3;
                }
            }
        } else {
            d = 0.0;
            BWidget bWidget = null;
            BWidget bWidget3 = null;
            for (int i = 0; i < n; ++i) {
                if (bWidget3 == null || bWidget3.getY() > this.widgets[i].getY()) {
                    bWidget3 = this.widgets[i];
                }
                if (bWidget == null || bWidget.getY() + bWidget.getHeight() < this.widgets[i].getY() + this.widgets[i].getHeight()) {
                    bWidget = this.widgets[i];
                }
                d += this.widgets[i].getHeight();
            }
            double d6 = bWidget.getY() + bWidget.getHeight() - bWidget3.getY();
            double d7 = (d6 - d) / (double)(n - 1);
            SortUtil.sort((Object[])this.widgets, (Object[])this.widgets, (Comparator)new Comparator(){

                public int compare(Object object, Object object2) {
                    return Double.compare(((BWidget)object).getX(), ((BWidget)object2).getX());
                }
            });
            if (this.widgets[0].getY() > this.widgets[n - 1].getY()) {
                double d8 = bWidget.getY() + bWidget.getHeight();
                for (int i = 0; i < n; ++i) {
                    this.deltaY[i] = Math.round((float)(d8 - (this.widgets[i].getY() + this.widgets[i].getHeight())));
                    d8 -= this.widgets[i].getHeight() + d7;
                }
            } else {
                double d9 = bWidget3.getY();
                for (int i = 0; i < n; ++i) {
                    this.deltaY[i] = Math.round((float)(d9 - this.widgets[i].getY()));
                    d9 += this.widgets[i].getHeight() + d7;
                }
            }
        }
        Artifact artifact = new Artifact();
        artifact.redo();
        return artifact;
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void redo() throws Exception {
            String[] stringArray = new String[Distribute.this.widgets.length];
            for (int i = 0; i < Distribute.this.widgets.length; ++i) {
                stringArray[i] = Distribute.this.artisan.move(Distribute.this.widgets[i], Distribute.this.deltaX[i], Distribute.this.deltaY[i]);
            }
            this.update(stringArray);
        }

        public void undo() throws Exception {
            String[] stringArray = new String[Distribute.this.widgets.length];
            for (int i = 0; i < Distribute.this.widgets.length; ++i) {
                stringArray[i] = Distribute.this.artisan.move(Distribute.this.widgets[i], -Distribute.this.deltaX[i], -Distribute.this.deltaY[i]);
            }
            this.update(stringArray);
        }

        private void update(String[] stringArray) {
            Distribute.this.editorPane.getSelectedWidgets().setWidgets(Distribute.this.widgets);
            Distribute.this.editorPane.getPxEditor().firePxEvent(EventUtil.widgetsChanged(Distribute.this.widgets, stringArray));
        }
    }
}

