/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public abstract class SegmentArtisan {
    public abstract Point point(Point var1, IPathGeom.Segment var2);

    public abstract IPathGeom.Segment move(Point var1, IPathGeom.Segment var2, double var3, double var5);

    public abstract Point paintBars(Graphics var1, TrackerStudio var2, BPath var3, Point var4, IPathGeom.Segment var5);

    public abstract Point paintHandles(Graphics var1, TrackerStudio var2, BPath var3, Point var4, IPathGeom.Segment var5);

    public abstract Point addHandles(TrackerStudio var1, BPath var2, Point var3, IPathGeom.Segment var4, int var5, PointMap var6);

    protected static final void paintBar(Graphics graphics, TrackerStudio trackerStudio, BPath bPath, Point point, Point point2, BColor bColor) {
        Point point3 = trackerStudio.translateToRoot((BWidget)bPath, new Point(point.x, point.y));
        Point point4 = trackerStudio.translateToRoot((BWidget)bPath, new Point(point2.x, point2.y));
        Point point5 = SegmentArtisan.mirror(point3, point4);
        graphics.setBrush(bColor);
        graphics.strokeLine(point4.x, point4.y, point5.x, point5.y);
        Artisan.paintHandle(graphics, bColor, point4.x, point4.y);
        Artisan.paintHandle(graphics, bColor, point5.x, point5.y);
    }

    protected static final void paintHandle(Graphics graphics, TrackerStudio trackerStudio, BPath bPath, Point point, BColor bColor) {
        Point point2 = trackerStudio.translateToRoot((BWidget)bPath, new Point(point.x, point.y));
        Artisan.paintHandle(graphics, bColor, point2.x, point2.y);
    }

    protected static final void addHandle(TrackerStudio trackerStudio, BPath bPath, Point point, PointMap pointMap, MouseCursor mouseCursor, Object object) {
        Point point2 = trackerStudio.translateToRoot((BWidget)bPath, new Point(point.x, point.y));
        Artisan.addHandle(point2.x, point2.y, pointMap, (BWidget)bPath, mouseCursor, object);
    }

    protected static final Point nextPoint(Point point, boolean bl, double d, double d2) {
        return bl ? new Point(d, d2) : new Point(point.x + d, point.y + d2);
    }

    protected static final Point mirror(Point point, Point point2) {
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        return new Point(point.x - d, point.y - d2);
    }
}

