/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.trackers.HandleTracker;
import com.tridium.px.editor.studio.trackers.PolygonHandleTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.Point;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPolygon;

public class PolygonArtisan
extends Artisan {
    public void paintSelected(TrackerStudio trackerStudio, BWidget bWidget, Graphics graphics) {
        Point[] pointArray = this.rootPoints(trackerStudio, (BPolygon)bWidget);
        int n = pointArray.length;
        graphics.setPen(BPen.DEFAULT);
        graphics.setBrush(BColor.lime);
        for (int i = 0; i < n; ++i) {
            PolygonArtisan.paintHandle(graphics, BColor.lime, pointArray[i].x, pointArray[i].y);
        }
    }

    public RectGeom bounds(BWidget bWidget) {
        BPolygon bPolygon = (BPolygon)bWidget;
        BPolygonGeom bPolygonGeom = bPolygon.getGeom();
        double[] dArray = bPolygonGeom.x();
        double[] dArray2 = bPolygonGeom.y();
        RectGeom rectGeom = new RectGeom(dArray[0], dArray2[0], 0.0, 0.0);
        for (int i = 1; i < dArray.length; ++i) {
            rectGeom = RectGeom.bounds((double)rectGeom.x, (double)rectGeom.y, (double)rectGeom.width, (double)rectGeom.height, (double)dArray[i], (double)dArray2[i], (double)0.0, (double)0.0, (RectGeom)rectGeom);
        }
        return rectGeom;
    }

    public String move(BWidget bWidget, double d, double d2) {
        BPolygon bPolygon = (BPolygon)bWidget;
        BPolygonGeom bPolygonGeom = bPolygon.getGeom();
        double[] dArray = bPolygonGeom.x();
        double[] dArray2 = bPolygonGeom.y();
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            int n3 = n++;
            dArray2[n3] = dArray2[n3] + d2;
        }
        bPolygon.setGeom(BPolygonGeom.make((double[])dArray, (double[])dArray2));
        return "geom";
    }

    public String zero(BWidget bWidget) {
        RectGeom rectGeom = this.bounds(bWidget);
        return this.move(bWidget, -rectGeom.x, -rectGeom.y);
    }

    public IGeom translateGeom(BWidget bWidget, double d, double d2) {
        BPolygon bPolygon = (BPolygon)bWidget;
        BPolygonGeom bPolygonGeom = bPolygon.getGeom();
        double[] dArray = bPolygonGeom.x();
        double[] dArray2 = bPolygonGeom.y();
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            int n3 = n++;
            dArray2[n3] = dArray2[n3] + d2;
        }
        return new PolygonGeom(dArray, dArray2, dArray.length);
    }

    public void addHandles(TrackerStudio trackerStudio, BWidget bWidget, PointMap pointMap) {
        Point[] pointArray = this.rootPoints(trackerStudio, (BPolygon)bWidget);
        for (int i = 0; i < pointArray.length; ++i) {
            PolygonArtisan.addHandle(pointArray[i].x, pointArray[i].y, pointMap, bWidget, MouseCursor.move, new Integer(i));
        }
    }

    public HandleTracker makeHandleTracker(BPxEditorPane bPxEditorPane, Handle handle, boolean bl) {
        return new PolygonHandleTracker(bPxEditorPane, handle, this);
    }

    public String setGeom(BWidget bWidget, IGeom iGeom) {
        BPolygon bPolygon = (BPolygon)bWidget;
        IPolygonGeom iPolygonGeom = (IPolygonGeom)iGeom;
        bPolygon.setGeom(BPolygonGeom.make((double[])iPolygonGeom.x(), (double[])iPolygonGeom.y(), (int)iPolygonGeom.size()));
        return "geom";
    }

    private Point[] rootPoints(TrackerStudio trackerStudio, BPolygon bPolygon) {
        BPolygonGeom bPolygonGeom = bPolygon.getGeom();
        double[] dArray = bPolygonGeom.x();
        double[] dArray2 = bPolygonGeom.y();
        Point[] pointArray = new Point[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            pointArray[i] = trackerStudio.translateToRoot((BWidget)bPolygon, new Point(dArray[i], dArray2[i]));
        }
        return pointArray;
    }
}

