/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans;

import com.tridium.gx.util.GeomUtil;
import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.trackers.HandleTracker;
import com.tridium.px.editor.studio.trackers.LineHandleTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.BColor;
import javax.baja.gx.BLineGeom;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.LineGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BLine;

public class LineArtisan
extends Artisan {
    public void paintSelected(TrackerStudio trackerStudio, BWidget bWidget, Graphics graphics) {
        BLine bLine = (BLine)bWidget;
        BLineGeom bLineGeom = bLine.getGeom();
        Point point = trackerStudio.translateToRoot((BWidget)bLine, new Point(bLineGeom.x1, bLineGeom.y1));
        Point point2 = trackerStudio.translateToRoot((BWidget)bLine, new Point(bLineGeom.x2, bLineGeom.y2));
        graphics.setPen(BPen.DEFAULT);
        graphics.setBrush(BColor.lime);
        LineArtisan.paintHandle(graphics, BColor.lime, point.x, point.y);
        LineArtisan.paintHandle(graphics, BColor.lime, point2.x, point2.y);
    }

    public RectGeom bounds(BWidget bWidget) {
        BLine bLine = (BLine)bWidget;
        BLineGeom bLineGeom = bLine.getGeom();
        return GeomUtil.makeRectangle((double)bLineGeom.x1, (double)bLineGeom.y1, (double)bLineGeom.x2, (double)bLineGeom.y2);
    }

    public String move(BWidget bWidget, double d, double d2) {
        BLine bLine = (BLine)bWidget;
        BLineGeom bLineGeom = bLine.getGeom();
        bLine.setGeom(BLineGeom.make((double)(bLineGeom.x1 + d), (double)(bLineGeom.y1 + d2), (double)(bLineGeom.x2 + d), (double)(bLineGeom.y2 + d2)));
        return "geom";
    }

    public String zero(BWidget bWidget) {
        BLine bLine = (BLine)bWidget;
        BLineGeom bLineGeom = bLine.getGeom();
        double d = Math.min(bLineGeom.x1, bLineGeom.x2);
        double d2 = Math.min(bLineGeom.y1, bLineGeom.y2);
        bLine.setGeom(BLineGeom.make((double)(bLineGeom.x1 - d), (double)(bLineGeom.y1 - d2), (double)(bLineGeom.x2 - d), (double)(bLineGeom.y2 - d2)));
        return "geom";
    }

    public IGeom translateGeom(BWidget bWidget, double d, double d2) {
        BLine bLine = (BLine)bWidget;
        BLineGeom bLineGeom = bLine.getGeom();
        return new LineGeom(bLineGeom.x1() + d, bLineGeom.y1() + d2, bLineGeom.x2() + d, bLineGeom.y2() + d2);
    }

    public void addHandles(TrackerStudio trackerStudio, BWidget bWidget, PointMap pointMap) {
        BLine bLine = (BLine)bWidget;
        BLineGeom bLineGeom = bLine.getGeom();
        Point point = trackerStudio.translateToRoot((BWidget)bLine, new Point(bLineGeom.x1, bLineGeom.y1));
        Point point2 = trackerStudio.translateToRoot((BWidget)bLine, new Point(bLineGeom.x2, bLineGeom.y2));
        LineArtisan.addHandle(point.x, point.y, pointMap, bWidget, MouseCursor.move, new Integer(1));
        LineArtisan.addHandle(point2.x, point2.y, pointMap, bWidget, MouseCursor.move, new Integer(2));
    }

    public HandleTracker makeHandleTracker(BPxEditorPane bPxEditorPane, Handle handle, boolean bl) {
        return new LineHandleTracker(bPxEditorPane, handle, this);
    }

    public String setGeom(BWidget bWidget, IGeom iGeom) {
        BLine bLine = (BLine)bWidget;
        ILineGeom iLineGeom = (ILineGeom)iGeom;
        bLine.setGeom(BLineGeom.make((double)iLineGeom.x1(), (double)iLineGeom.y1(), (double)iLineGeom.x2(), (double)iLineGeom.y2()));
        return "geom";
    }
}

