/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.tree;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.tree.PxTreeModel;
import com.tridium.px.editor.util.Reflector;
import javax.baja.gx.BImage;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;

abstract class WidgetNode
extends TreeNode {
    protected final BPxEditorPane editorPane;
    private BWidget widget;
    private String text;
    private BImage image;
    private PxTreeModel model;

    WidgetNode(BPxEditorPane bPxEditorPane, PxTreeModel pxTreeModel, BWidget bWidget) {
        super((TreeModel)pxTreeModel);
        this.model = pxTreeModel;
        this.editorPane = bPxEditorPane;
        this.widget = bWidget;
        this.image = BImage.make((BIcon)bWidget.getIcon());
        this.text = this.makeText();
        pxTreeModel.putNode(this);
    }

    WidgetNode(BPxEditorPane bPxEditorPane, WidgetNode widgetNode, BWidget bWidget) {
        super((TreeNode)widgetNode);
        this.model = widgetNode.model;
        this.editorPane = bPxEditorPane;
        this.widget = bWidget;
        this.image = BImage.make((BIcon)bWidget.getIcon());
        this.text = this.makeText();
        this.model.putNode(this);
    }

    void refreshText() {
        this.text = this.makeText();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((WidgetNode)this.getChild(i)).refreshText();
        }
    }

    private String makeText() {
        return this.editorPane.getOptions().getPreserveIdentities() ? Reflector.displayName((BComplex)this.widget, this.widget.getName(), true) : (this.widget instanceof BNullWidget ? this.widget.getName() : Reflector.displayName((BComplex)this.widget, true));
    }

    public String toString() {
        return "(WidgetNode: " + this.widget + ")";
    }

    abstract int dragOver();

    public final Object getSubject() {
        return this.widget;
    }

    public final String getText() {
        return this.text;
    }

    public final BImage getIcon() {
        return this.image;
    }

    BWidget getWidget() {
        return this.widget;
    }
}

