/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.tree;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.commands.Delete;
import com.tridium.px.editor.commands.EditPropertiesContext;
import com.tridium.px.editor.commands.Insert;
import com.tridium.px.editor.commands.InsertDynamic;
import com.tridium.px.editor.commands.InsertFrozen;
import com.tridium.px.editor.commands.Rename;
import com.tridium.px.editor.sidebars.tree.ExpandAll;
import com.tridium.px.editor.sidebars.tree.PaneNode;
import com.tridium.px.editor.sidebars.tree.PxTreeController;
import com.tridium.px.editor.sidebars.tree.PxTreeModel;
import com.tridium.px.editor.sidebars.tree.PxTreeSelection;
import com.tridium.px.editor.sidebars.tree.WidgetNode;
import com.tridium.px.editor.studio.TreeStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.commands.MoveWidget;
import com.tridium.px.editor.studio.commands.PreferredSize;
import com.tridium.px.editor.util.EventUtil;
import com.tridium.px.editor.util.MenuBuilder;
import com.tridium.px.editor.util.Reflector;
import com.tridium.px.editor.util.SelectedWidgets;
import com.tridium.util.ClassUtil;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.Array;
import javax.baja.px.editor.BDrawingTool;
import javax.baja.px.editor.BIPxTransferWidget;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.event.PxComponentEvent;
import javax.baja.px.editor.event.PxCompoundWidgetEvent;
import javax.baja.px.editor.event.PxEditorEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.px.editor.event.PxPropertyEvent;
import javax.baja.px.editor.event.PxWidgetEvent;
import javax.baja.px.editor.factory.WidgetInserter;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;

public class BPxTree
extends BTree
implements BIPxTransferWidget,
PxListener {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$px$editor$sidebars$tree$BPxTree == null ? (class$com$tridium$px$editor$sidebars$tree$BPxTree = BPxTree.class$("com.tridium.px.editor.sidebars.tree.BPxTree")) : class$com$tridium$px$editor$sidebars$tree$BPxTree));
    private BPxEditor editor;
    private BPxEditorPane editorPane;
    private SelectedWidgets selected;
    private TreeStudio studio;
    private Artisan artisan = Artisan.instance();
    private PxTreeModel model;
    private PxTreeSelection selModel;
    private boolean duplicating;
    private BWidget duplParent;
    private RectGeom[] duplBounds;
    private WidgetNode popupNode = null;
    static /* synthetic */ Class class$com$tridium$px$editor$sidebars$tree$BPxTree;
    static /* synthetic */ Class class$javax$baja$sys$Type;

    public Type getType() {
        return TYPE;
    }

    public BPxTree(BPxEditor bPxEditor) {
        this.editor = bPxEditor;
        this.editorPane = (BPxEditorPane)bPxEditor.getContent();
        this.selected = this.editorPane.getSelectedWidgets();
        this.studio = this.editorPane.getTreeStudio();
        bPxEditor.addPxListener(this);
        this.setMultipleSelection(true);
        this.model = new PxTreeModel(this.editorPane);
        this.setModel(this.model);
        this.selModel = new PxTreeSelection(this.editorPane, this.selected);
        this.setSelection(this.selModel);
        this.setController(this.makeController());
    }

    public void pxEvent(PxEvent pxEvent) {
        block0 : switch (pxEvent.getEventType()) {
            case 0: {
                PxEditorEvent pxEditorEvent = (PxEditorEvent)pxEvent;
                switch (pxEditorEvent.getEventId()) {
                    case 0: {
                        this.model.buildRoot(this.editorPane.getRootContainer().getRoot());
                        break block0;
                    }
                    case 2: {
                        if (!((String)pxEditorEvent.getEventValue()).equals("preserveIdentities")) break block0;
                        this.model.refreshNodeText();
                        this.relayout();
                        break block0;
                    }
                    case 3: {
                        this.updateSelection();
                        BDrawingTool bDrawingTool = (BDrawingTool)((Object)pxEditorEvent.getEventValue());
                        this.setEnabled(bDrawingTool.isNormal());
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.updateSelection();
                break;
            }
            case 1: {
                switch (((PxPropertyEvent)pxEvent).getEventId()) {
                    case 1: 
                    case 2: {
                        this.model.refreshNodeText();
                        this.relayout();
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                PxCompoundWidgetEvent pxCompoundWidgetEvent = (PxCompoundWidgetEvent)pxEvent;
                if (pxCompoundWidgetEvent.getId() == 2 && this.valuesType(pxCompoundWidgetEvent.getEvents()).is(BWidget.TYPE)) {
                    this.getController().setFocus(null);
                    this.model.updateNodes(this.editorPane.getRootContainer().getRoot());
                    this.relayout();
                    this.updateSelection();
                    break;
                }
                this.model.refreshNodeText();
                this.relayout();
                break;
            }
            case 6: {
                this.model.refreshNodeText();
                this.relayout();
                break;
            }
            case 3: 
            case 4: {
                switch (EventUtil.getEventType((PxComponentEvent)pxEvent)) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: {
                        this.getController().setFocus(null);
                        this.model.updateNodes(this.editorPane.getRootContainer().getRoot());
                        this.relayout();
                        this.updateSelection();
                        break block0;
                    }
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.model.refreshNodeText();
                        this.relayout();
                        break block0;
                    }
                }
            }
        }
    }

    private Type valuesType(PxWidgetEvent[] pxWidgetEventArray) {
        Array array = new Array(class$javax$baja$sys$Type == null ? (class$javax$baja$sys$Type = BPxTree.class$("javax.baja.sys.Type")) : class$javax$baja$sys$Type);
        for (int i = 0; i < pxWidgetEventArray.length; ++i) {
            BValue[] bValueArray = pxWidgetEventArray[i].getValues();
            for (int j = 0; j < bValueArray.length; ++j) {
                array.add((Object)bValueArray[j].getType());
            }
        }
        return ClassUtil.getCommonSuperType((Type[])((Type[])array.trim()));
    }

    private void updateSelection() {
        this.selModel.superDeselectAll();
        int n = this.selected.size();
        for (int i = 0; i < n; ++i) {
            BWidget bWidget = this.selected.get(i);
            WidgetNode widgetNode = this.model.getNode(bWidget);
            this.selModel.superSelect(widgetNode);
            if (i != n - 1) continue;
            this.expandToNode(widgetNode);
            this.scrollNodeToVisible(widgetNode);
        }
        this.repaint();
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        super.focusGained(bFocusEvent);
        this.editor.setTransferWidget((BTransferWidget)this);
    }

    public CommandArtifact doDuplicate() throws Exception {
        this.duplicating = true;
        return super.doDuplicate();
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (this.duplicating) {
            this.duplParent = this.selected.get(0).getParentWidget();
            BWidget[] bWidgetArray = this.selected.getWidgets();
            this.duplBounds = new RectGeom[bWidgetArray.length];
            for (int i = 0; i < bWidgetArray.length; ++i) {
                this.duplBounds[i] = this.artisan.bounds(bWidgetArray[i]);
            }
        }
        return this.selected.envelope();
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return this.doDelete();
    }

    public CommandArtifact doDelete() throws Exception {
        if (this.selected.size() > 0 && this.editorPane.getLayerManager().allNormal(this.selected.getWidgets())) {
            return new Delete(this.editorPane).doInvoke();
        }
        return null;
    }

    public int dragOver(TransferContext transferContext) {
        if (this.preventEdits() || !this.editor.getController().allowDrop(this, transferContext)) {
            return 0;
        }
        TreeNode treeNode = this.yToTreeNode(transferContext.getY());
        return treeNode == null ? 0 : ((WidgetNode)treeNode).dragOver();
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        WidgetInserter widgetInserter;
        BObject[] bObjectArray = ((Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues();
        if (bObjectArray.length > 1 && this.popupNode != null && this.popupNode.getWidget() instanceof BNullWidget) {
            bObjectArray = new BObject[]{bObjectArray[0]};
        }
        if ((widgetInserter = this.editor.getController().getWidgetInserter(this, bObjectArray)) == null) {
            return null;
        }
        if (widgetInserter.getWidgets() == null) {
            return null;
        }
        if (widgetInserter.getWidgets().length == 0) {
            return null;
        }
        Insert insert = this.makeInsertCommand(widgetInserter.getWidgets());
        return this.makeInsertArtifact(insert, widgetInserter.getAuxillaryCommand());
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        WidgetInserter widgetInserter;
        if (this.preventEdits() || !this.editor.getController().allowDrop(this, transferContext)) {
            throw new IllegalStateException();
        }
        BObject[] bObjectArray = ((Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues();
        TreeNode treeNode = this.yToTreeNode(transferContext.getY());
        if (treeNode == null) {
            return null;
        }
        WidgetNode widgetNode = (WidgetNode)treeNode;
        if (bObjectArray.length > 1 && widgetNode.getWidget() instanceof BNullWidget) {
            bObjectArray = new BObject[]{bObjectArray[0]};
        }
        if ((widgetInserter = this.editor.getController().getWidgetInserter(this, bObjectArray)) == null) {
            return null;
        }
        if (widgetInserter.getWidgets() == null) {
            return null;
        }
        if (widgetInserter.getWidgets().length == 0) {
            return null;
        }
        Insert insert = this.makeDropCommand(widgetNode, widgetInserter.getWidgets(), widgetInserter.getColumnCount());
        return this.makeInsertArtifact(insert, widgetInserter.getAuxillaryCommand());
    }

    public BMenu getDefaultPopupMenu(BMouseEvent bMouseEvent) {
        BMenu bMenu;
        BCanvasPane bCanvasPane = this.studio.getCurrentCanvas();
        BPane bPane = this.studio.getCurrentFreeForm();
        BMenu bMenu2 = new BMenu();
        BSubMenuItem bSubMenuItem = new BSubMenuItem(UiLexicon.bajaui.getText("menu.new.label"));
        CutCommand cutCommand = new CutCommand((BTransferWidget)this);
        CopyCommand copyCommand = new CopyCommand((BTransferWidget)this);
        PasteCommand pasteCommand = new PasteCommand((BTransferWidget)this);
        DuplicateCommand duplicateCommand = new DuplicateCommand((BTransferWidget)this);
        DeleteCommand deleteCommand = new DeleteCommand((BTransferWidget)this);
        EditPropertiesContext editPropertiesContext = new EditPropertiesContext(this.editor);
        PreferredSize preferredSize = new PreferredSize(this.editorPane, bPane);
        ExpandAll expandAll = new ExpandAll(this.editorPane, this, this.popupNode);
        if (this.popupNode.getWidget() instanceof BNullWidget) {
            cutCommand.setEnabled(false);
            copyCommand.setEnabled(false);
            duplicateCommand.setEnabled(false);
            deleteCommand.setEnabled(false);
            editPropertiesContext.setEnabled(false);
            preferredSize.setEnabled(false);
            expandAll.setEnabled(false);
        } else {
            BWidget bWidget = this.popupNode.getWidget().getParentWidget();
            if (!Reflector.isFreeFormPane(bWidget)) {
                duplicateCommand.setEnabled(false);
            }
            if (!Reflector.isFreeFormPane(this.popupNode.getWidget())) {
                pasteCommand.setEnabled(false);
                bSubMenuItem.setEnabled(false);
            }
        }
        boolean bl = this.preventEdits();
        if (cutCommand.isEnabled()) {
            cutCommand.setEnabled(!bl);
        }
        if (pasteCommand.isEnabled()) {
            pasteCommand.setEnabled(!bl);
        }
        if (bSubMenuItem.isEnabled()) {
            bSubMenuItem.setEnabled(!bl);
        }
        if (duplicateCommand.isEnabled()) {
            duplicateCommand.setEnabled(!bl);
        }
        if (deleteCommand.isEnabled()) {
            deleteCommand.setEnabled(!bl);
        }
        if (editPropertiesContext.isEnabled()) {
            editPropertiesContext.setEnabled(!bl);
        }
        if (preferredSize.isEnabled()) {
            preferredSize.setEnabled(!bl);
        }
        if (expandAll.isEnabled()) {
            expandAll.setEnabled(!bl);
        }
        if (bSubMenuItem.isEnabled()) {
            bMenu = MenuBuilder.newMenu(this.editorPane, (BTransferWidget)this);
            if (bMenu == null) {
                bSubMenuItem.setEnabled(false);
            } else {
                bSubMenuItem.setMenu(bMenu);
            }
        }
        bMenu = new BSubMenuItem(BPxEditorPane.text("commands.align"), MenuBuilder.alignMenu(this.editorPane, this.studio.alignable(bCanvasPane)));
        BSubMenuItem bSubMenuItem2 = new BSubMenuItem(BPxEditorPane.text("commands.distribute"), MenuBuilder.distributeMenu(this.editorPane, this.studio.distributable(bCanvasPane)));
        BSubMenuItem bSubMenuItem3 = new BSubMenuItem(BPxEditorPane.text("commands.reorder"), MenuBuilder.reorgMenu(this.editorPane, this.studio.reorgable(bPane)));
        BSubMenuItem bSubMenuItem4 = new BSubMenuItem(BPxEditorPane.text("commands.border"), MenuBuilder.borderMenu(this.editorPane, this.editorPane.getSelectedWidgets()));
        bMenu2.add(null, (BValue)bSubMenuItem);
        bMenu2.add(null, (BValue)new BSeparator());
        bMenu2.add(null, (Command)cutCommand);
        bMenu2.add(null, (Command)copyCommand);
        bMenu2.add(null, (Command)pasteCommand);
        bMenu2.add(null, (Command)duplicateCommand);
        bMenu2.add(null, (Command)deleteCommand);
        bMenu2.add(null, (BValue)new BSeparator());
        bMenu2.add(null, (Command)editPropertiesContext);
        bMenu2.add(null, (BValue)bMenu);
        bMenu2.add(null, (BValue)bSubMenuItem2);
        bMenu2.add(null, (BValue)bSubMenuItem3);
        bMenu2.add(null, (BValue)bSubMenuItem4);
        bMenu2.add(null, (Command)preferredSize);
        bMenu2.add(null, (Command)expandAll);
        if (this.editorPane.getOptions().getPreserveIdentities()) {
            Rename rename = new Rename(this.editorPane);
            if (this.selected.size() != 1 || !Reflector.isFreeFormPane(this.selected.get(0).getParentWidget())) {
                rename.setEnabled(false);
            }
            if (rename.isEnabled()) {
                rename.setEnabled(!this.preventEdits());
            }
            bMenu2.add(null, (Command)rename);
        }
        return bMenu2;
    }

    private CommandArtifact makeInsertArtifact(Insert insert, Command command) throws Exception {
        if (insert == null) {
            return null;
        }
        if (!insert.checkMedia()) {
            return null;
        }
        if (command == null) {
            return insert.doInvoke();
        }
        return new CompoundCommand((BWidget)this.editor, "compound", new Command[]{insert, command}).doInvoke();
    }

    private Insert makeInsertCommand(BWidget[] bWidgetArray) {
        BWidget bWidget;
        if (this.selected.get(0) instanceof BNullWidget) {
            if (bWidgetArray.length != 1) {
                throw new IllegalStateException();
            }
            if (this.duplicating) {
                throw new IllegalStateException();
            }
            this.popupNode = null;
            this.artisan.zero(bWidgetArray[0]);
            return new InsertFrozen(this.editor, this.editorPane, this.selected.get(0).getParentWidget(), bWidgetArray[0], this.selected.get(0).getName());
        }
        BWidget bWidget2 = bWidget = this.duplicating ? this.duplParent : this.selected.get(0);
        if (!Reflector.isFreeFormPane(bWidget)) {
            throw new IllegalStateException();
        }
        if (bWidget instanceof BCanvasPane) {
            if (this.duplicating) {
                MoveWidget.toZero(bWidgetArray, this.artisan);
                for (int i = 0; i < bWidgetArray.length; ++i) {
                    this.artisan.move(bWidgetArray[i], this.duplBounds[i].x + 10.0, this.duplBounds[i].y + 10.0);
                }
            } else {
                RectGeom rectGeom = this.artisan.bounds(bWidgetArray[0]);
                for (int i = 1; i < bWidgetArray.length; ++i) {
                    rectGeom = RectGeom.bounds((IRectGeom)this.artisan.bounds(bWidgetArray[i]), (IRectGeom)rectGeom, (RectGeom)rectGeom);
                }
                MoveWidget.shiftWidgets(bWidgetArray, this.artisan, -rectGeom.x, -rectGeom.y);
            }
        } else if (bWidget instanceof BTabbedPane) {
            MoveWidget.toZero(bWidgetArray, this.artisan);
            bWidgetArray = this.editorPane.getTreeStudio().makeTabs(bWidgetArray);
        } else {
            MoveWidget.toZero(bWidgetArray, this.artisan);
        }
        this.duplicating = false;
        this.popupNode = null;
        return new InsertDynamic(this.editor, this.editorPane, bWidget, bWidgetArray);
    }

    private Insert makeDropCommand(WidgetNode widgetNode, BWidget[] bWidgetArray, int n) {
        if (widgetNode.getWidget() instanceof BNullWidget) {
            if (bWidgetArray.length != 1) {
                throw new IllegalStateException();
            }
            return new InsertFrozen(this.editor, this.editorPane, widgetNode.getWidget().getParentWidget(), bWidgetArray[0], widgetNode.getText());
        }
        if (widgetNode instanceof PaneNode) {
            BWidget bWidget = widgetNode.getWidget();
            if (!Reflector.isFreeFormPane(bWidget)) {
                throw new IllegalStateException();
            }
            if (bWidget instanceof BCanvasPane) {
                this.editorPane.getTreeStudio().dropWidgetsInCanvas(0.0, 0.0, bWidgetArray, n);
            } else if (bWidget instanceof BTabbedPane) {
                bWidgetArray = this.editorPane.getTreeStudio().makeTabs(bWidgetArray);
            }
            return new InsertDynamic(this.editor, this.editorPane, bWidget, bWidgetArray);
        }
        throw new IllegalStateException();
    }

    private boolean preventEdits() {
        return this.editor.isReadonly() || !this.editorPane.getLayerManager().allNormal(this.selected.getWidgets());
    }

    protected PxTreeController makeController() {
        return new PxTreeController(this.editor, this.editorPane, this, this.selected);
    }

    void setPopupNode(WidgetNode widgetNode) {
        this.popupNode = widgetNode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

