/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.layersheet;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.layersheet.BPxLayerSheet;
import com.tridium.util.ObjectUtil;
import javax.baja.px.editor.event.PxLayerEvent;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.px.PxLayer;
import javax.baja.util.Lexicon;

class RenamePxLayer
extends Command
implements ObjectUtil.NameContainer {
    private static final Lexicon lex = Lexicon.make((String)"pxEditor");
    private static final String title = lex.getText("commands.rename.label");
    private static final String defaultPxLayerName = lex.getText("pxLayerSheet.defaultPxLayerName");
    private static final String alreadyExists = lex.getText("pxLayerSheet.alreadyExists");
    private BPxEditorPane editorPane;
    private BPxLayerSheet sheet;

    RenamePxLayer(BPxEditorPane bPxEditorPane, BPxLayerSheet bPxLayerSheet) {
        super((BWidget)bPxLayerSheet, Lexicon.make((String)"pxEditor"), "commands.rename");
        this.editorPane = bPxEditorPane;
        this.sheet = bPxLayerSheet;
        this.setEnabled(!bPxLayerSheet.readonly);
    }

    public boolean contains(String string) {
        PxLayer[] pxLayerArray = this.sheet.editor.getPxLayers();
        for (int i = 0; i < pxLayerArray.length; ++i) {
            if (!pxLayerArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public CommandArtifact doInvoke() throws Exception {
        PxLayer[] pxLayerArray = this.sheet.editor.getPxLayers();
        final int n = this.sheet.table.getSelection().getRow();
        final PxLayer pxLayer = pxLayerArray[n];
        final String string = pxLayer.getName();
        BTextField bTextField = new BTextField(ObjectUtil.generateUniqueName((String)defaultPxLayerName, (ObjectUtil.NameContainer)this), 20);
        int n2 = BDialog.open((BWidget)this.sheet, (String)title, (Object)bTextField, (int)3);
        if (n2 != 1) {
            return null;
        }
        final String string2 = bTextField.getText();
        if (string.equals(string2)) {
            return null;
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("Layer name must be defined.");
        }
        for (int i = 0; i < pxLayerArray.length; ++i) {
            PxLayer pxLayer2 = pxLayerArray[i];
            if (pxLayer2 == pxLayer || !pxLayer2.getName().equals(string2)) continue;
            BDialog.error((BWidget)this.sheet, (String)title, (Object)alreadyExists);
            return null;
        }
        CommandArtifact commandArtifact = new CommandArtifact(){

            public void redo() throws Exception {
                pxLayer.setName(string2);
                ((RenamePxLayer)RenamePxLayer.this).sheet.table.setRowName(n, string2);
                ((RenamePxLayer)RenamePxLayer.this).sheet.layerMgr.renameLayerTag(string, string2);
                RenamePxLayer.this.sheet.updateUI(pxLayer, new PxLayerEvent(3, pxLayer));
            }

            public void undo() throws Exception {
                pxLayer.setName(string);
                ((RenamePxLayer)RenamePxLayer.this).sheet.table.setRowName(n, string);
                ((RenamePxLayer)RenamePxLayer.this).sheet.layerMgr.renameLayerTag(string2, string);
                RenamePxLayer.this.sheet.updateUI(pxLayer, new PxLayerEvent(3, pxLayer));
            }
        };
        commandArtifact.redo();
        return commandArtifact;
    }
}

