/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.cellsheet.commands;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheet;
import com.tridium.px.editor.util.LayerManager;
import javax.baja.px.editor.event.PxLayerEvent;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.px.BLayerTag;
import javax.baja.ui.px.PxLayer;

public class ChangeLayer
extends Command {
    private BPxEditorPane editorPane;
    private LayerManager layerMgr;
    private BPxCellSheet cellSheet;
    private BWidget[] widgets;
    private PxLayer[] oldLayers;
    private PxLayer[] newLayers;

    public ChangeLayer(BPxEditorPane bPxEditorPane, BPxCellSheet bPxCellSheet, PxLayer pxLayer) {
        super((BWidget)bPxEditorPane, BPxEditorPane.lexicon(), "commands.changeLayer");
        this.editorPane = bPxEditorPane;
        this.layerMgr = bPxEditorPane.getLayerManager();
        this.widgets = bPxEditorPane.getSelectedWidgets().getWidgets();
        this.cellSheet = bPxCellSheet;
        this.oldLayers = new PxLayer[this.widgets.length];
        this.newLayers = new PxLayer[this.widgets.length];
        for (int i = 0; i < this.widgets.length; ++i) {
            BLayerTag bLayerTag = this.layerMgr.getTag(this.widgets[i]);
            this.oldLayers[i] = bLayerTag == null ? null : this.layerMgr.getLayerByName(bLayerTag.getLayerName());
            this.newLayers[i] = pxLayer;
        }
    }

    public CommandArtifact doInvoke() throws Exception {
        Artifact artifact = new Artifact();
        artifact.redo();
        return artifact;
    }

    private class Artifact
    implements CommandArtifact {
        private Artifact() {
        }

        public void redo() throws Exception {
            this.perform(ChangeLayer.this.newLayers);
        }

        public void undo() throws Exception {
            this.perform(ChangeLayer.this.oldLayers);
        }

        private void perform(PxLayer[] pxLayerArray) {
            for (int i = 0; i < ChangeLayer.this.widgets.length; ++i) {
                ChangeLayer.this.layerMgr.removeTag(ChangeLayer.this.widgets[i]);
                if (pxLayerArray[i] == null) continue;
                ChangeLayer.this.layerMgr.addTag(ChangeLayer.this.widgets[i], pxLayerArray[i]);
            }
            ChangeLayer.this.editorPane.getSelectedWidgets().setWidgets(ChangeLayer.this.widgets);
            ChangeLayer.this.editorPane.getPxEditor().firePxEvent(new PxLayerEvent(2, pxLayerArray[0]));
        }
    }
}

