/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.property;

import com.tridium.px.editor.property.Target;
import com.tridium.px.editor.property.TargetArray;
import javax.baja.sys.BComponent;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxProperty;

public class PxPropertyComponent {
    private BComponent comp;
    private final TargetArray targets;

    public PxPropertyComponent(BComponent bComponent) {
        this.comp = bComponent;
        this.targets = new TargetArray();
    }

    public void addTarget(PxProperty pxProperty, String string) {
        this.targets.add(pxProperty, string);
    }

    public void removeTarget(PxProperty pxProperty, String string) {
        this.targets.remove(pxProperty, string);
    }

    public boolean hasTargets() {
        return this.targets.size() > 0;
    }

    public void cloneTargets(PxPropertyComponent pxPropertyComponent) {
        TargetArray targetArray = pxPropertyComponent.getTargets();
        for (int i = 0; i < targetArray.size(); ++i) {
            Target target = targetArray.get(i);
            this.targets.add(target.getPxProperty(), target.getPropertyName());
        }
    }

    public BComponent getComponent() {
        return this.comp;
    }

    public BWidget getWidget() {
        if (this.comp instanceof BWidget) {
            return (BWidget)this.comp;
        }
        if (!(this.comp instanceof BBinding)) {
            throw new IllegalStateException();
        }
        return (BWidget)this.comp.getParent();
    }

    public String toString() {
        return "PxPropertyComponent:" + this.comp.getClass().getName() + ":" + this.targets;
    }

    TargetArray getTargets() {
        return this.targets;
    }

    void setComponent(BComponent bComponent) {
        this.comp = bComponent;
    }
}

