/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.make;

import com.tridium.px.editor.make.PropertyNodeFactory;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;

class PropertyNode
extends TreeNode {
    private BObject object;
    private String name;
    private String displayName;
    private BImage icon;
    private String namePath;
    private String displayNamePath;
    private PropertyNode[] kids;
    private PropertyNodeFactory factory = new PropertyNodeFactory(){

        protected PropertyNode make(BObject bObject, String string, String string2) {
            return new PropertyNode(PropertyNode.this, bObject, string, string2);
        }
    };

    PropertyNode(TreeModel treeModel, BObject bObject, String string, String string2) {
        super(treeModel);
        this.object = bObject;
        this.name = string;
        this.displayName = string2;
        this.icon = BImage.make((BIcon)bObject.getIcon());
    }

    private PropertyNode(TreeNode treeNode, BObject bObject, String string, String string2) {
        super(treeNode);
        this.object = bObject;
        this.name = string;
        this.displayName = string2;
        this.icon = BImage.make((BIcon)bObject.getIcon());
    }

    public boolean equals(Object object) {
        PropertyNode propertyNode = (PropertyNode)((Object)object);
        if (!this.name.equals(propertyNode.name)) {
            return false;
        }
        if (!this.displayName.equals(propertyNode.displayName)) {
            return false;
        }
        return this.object.getClass().equals(propertyNode.object.getClass());
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public Object getSubject() {
        return this.object;
    }

    public String getText() {
        return this.displayName;
    }

    public BImage getIcon() {
        return this.icon;
    }

    public boolean hasChildren() {
        if (this.kids == null) {
            return true;
        }
        return this.kids.length > 0;
    }

    public final int getChildCount() {
        if (this.kids == null) {
            this.kids = this.factory.makeAll(this.object);
        }
        return this.kids.length;
    }

    public final TreeNode getChild(int n) {
        if (this.kids == null) {
            this.kids = this.factory.makeAll(this.object);
        }
        return this.kids[n];
    }

    String namePath() {
        if (this.namePath == null) {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            for (PropertyNode propertyNode = (PropertyNode)this.getParent(); propertyNode != null; propertyNode = (PropertyNode)propertyNode.getParent()) {
                stringBuffer.insert(0, "/").insert(0, propertyNode.name);
            }
            this.namePath = stringBuffer.toString();
        }
        return this.namePath;
    }

    String displayNamePath() {
        if (this.displayNamePath == null) {
            StringBuffer stringBuffer = new StringBuffer(this.displayName);
            for (PropertyNode propertyNode = (PropertyNode)this.getParent(); propertyNode != null; propertyNode = (PropertyNode)propertyNode.getParent()) {
                stringBuffer.insert(0, " ").insert(0, propertyNode.displayName);
            }
            this.displayNamePath = stringBuffer.toString();
        }
        return this.displayNamePath;
    }

    BObject object() {
        return this.object;
    }
}

